package org.pigeonblood.impl.core.modelizer;

import java.util.ArrayList;

import javax.xml.transform.dom.DOMSource;

import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.list.AttributesList;
import org.lixm.core.list.XMLDocumentList;
import org.lixm.core.model.AbstractModel;
import org.lixm.core.model.AttributeModel;
import org.lixm.core.model.ElementModel;
import org.lixm.optional.v16.framework.model.AttributeModelImpl;
import org.lixm.optional.v16.framework.model.CharactersModelImpl;
import org.lixm.optional.v16.framework.model.CommentModelImpl;
import org.lixm.optional.v16.framework.model.ElementModelImpl;
import org.lixm.optional.v16.framework.model.EndCdataModelImpl;
import org.lixm.optional.v16.framework.model.EndDocumentModelImpl;
import org.lixm.optional.v16.framework.model.EndTagModelImpl;
import org.lixm.optional.v16.framework.model.ProcessingInstructionModelImpl;
import org.lixm.optional.v16.framework.model.StartCdataModelImpl;
import org.lixm.optional.v16.framework.model.StartDocumentModelImpl;
import org.lixm.optional.v16.framework.model.StartTagModelImpl;
import org.lixm.optional.v16.framework.model.XmlDeclModelImpl;
import org.pigeonblood.impl.core.list.SimpleDocumentList;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/**
 * <p>DOM𗘗pXMLfCY܂B</p>
 * 
 * @author tasogare
 * @version 0.3
 * @since 0.1
 */
public class TreeXMLModelizer extends AbstractXMLModelizer<DOMSource> {

    protected ArrayList<AbstractModel> models;
//    protected DOMSource source;

    /**
     * <p>ی삳ꂽRXgN^łB</p>
     * @param source fCŸׂ̕ϊ\[X
     */
    protected TreeXMLModelizer(
        DOMSource source)
    {
        super(source);
    }

    /**
     * <p>ی삳ꂽRXgN^łB<p>
     * @param source fCŸׂ̕ϊ\[X
     * @param list ϊʂi[郂fXg
     */
    protected TreeXMLModelizer(
        DOMSource source, XMLDocumentList<AbstractModel> list)
    {
        super(source);
        this.setList(list);
    }

    /**
     * <p>̃fCU𐶐t@NgłBϊ\[Xw肵܂B</p>
     * 
     * @param source ϊ\[X
     * @return ̃fCŨCX^X
     */
    public static AbstractXMLModelizer<DOMSource> newInstance(
        DOMSource source)
    {
        return new TreeXMLModelizer(source);
    }

    /**
     * <p>̃fCU𐶐t@NgłB
     * ϊ\[Xƕϊʂi[郊Xgw肵܂B</p>
     * 
     * @param source ϊ\[X
     * @param list ϊʂi[郂fXg
     * @return ̃fCŨCX^X
     */
    public static AbstractXMLModelizer<DOMSource> newInstance(
        DOMSource source, XMLDocumentList<AbstractModel> list)
    {
        return new TreeXMLModelizer(source, list);
    }

    /**
     * {@inheritDoc}
     */
    public void modelize() throws LIXMPhaseException {
        modelizing = true;

        /*
         * TODO DOM̃G[ĂȂ
         */
        if (this.list == null) {
            throw new LIXMPhaseException(
                "fCYs悤Ƃ܂Xg֘AtĂ܂",
                LIXMPhaseException.PHASE_MODELAIZE);
        }

        models = new ArrayList<AbstractModel>(1000);

        try {
            Document doc = (Document) source.getNode( );

            modelaizeStartDocment(doc);

            /*
             * vÕfCYsS
             */
            modelaizeXmlDecl(doc);

            //[gvf牺wSăfCY
            modelaizeElement(doc.getDocumentElement( ));
            modelaizeEndDocment(doc);
        } catch (Exception e) {
            throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_MODELAIZE);
        }
        list = new SimpleDocumentList(models.size( ));
        for(AbstractModel model : models){
        	list.add(model);
        }
        list.setSeal(true);
        modelizing = false;
    }

    /**
     * <p>̊JnfCY܂</p>
     * @param doc <code>Document</code>m[h
     */
    private void modelaizeStartDocment(
        Document doc)
    {
        DocumentType docType = doc.getDoctype( );

        if(docType!=null){
        models.add(new StartDocumentModelImpl(docType.getPublicId( ), docType
            .getSystemId( )));
        }else{
        	models.add(new StartDocumentModelImpl(null, null));
        }
    }

    /**
     * <p>̏IfCY܂</p>
     * @param doc <code>Document</code>m[h
     */
    private void modelaizeEndDocment(
        Document doc)
    {
        DocumentType docType = doc.getDoctype( );
        if(docType != null){
        models.add(new EndDocumentModelImpl(docType.getPublicId( ), docType
            .getSystemId( )));
        }else{
        	models.add(new EndDocumentModelImpl(null, null));
        }
    }

    /**
     * <p>XML錾fCY܂</p>
     * @param doc <code>Document</code>m[h
     */
    private void modelaizeXmlDecl(
        Document doc)
    {
        models.add(new XmlDeclModelImpl(doc.getXmlVersion( ),
            doc.getXmlEncoding( ), ( doc.getXmlStandalone( ) ? "yes" : "no" )));
    }

    /**
     * <p>vff</p>
     * <p>vf̊Jn^OAeAI^ȌɃfCY</p>
     * @param elm fJnvf
     */
    private void modelaizeElement(
        Element elm)
    {
        modelaizeStartTag(elm);
        if (elm.getChildNodes( ).getLength( ) != 0) {
            modelaizeContent(elm.getChildNodes( ));
        }
        modelaizeEndTag(elm);
    }

    /**
     * <p>eċAIɃf</p>
     * @param nodes vfe<code>NodeList</code>
     */
    private void modelaizeContent(
        NodeList nodes)
    {

        for (int i = 0; i < nodes.getLength( ); i++) {

            final Node node = nodes.item(i);
            switch (node.getNodeType( )) {

            case Node.ELEMENT_NODE :
                modelaizeElement((Element) node);
                break;

            case Node.TEXT_NODE :
                modelaizeText((Text) node);
                break;

            case Node.CDATA_SECTION_NODE :
                modelaizeCDATASection((CDATASection) node);
                break;

            case Node.COMMENT_NODE :
                modelaizeComment((Comment) node);
                break;

            case Node.PROCESSING_INSTRUCTION_NODE :
                modelaizePI((ProcessingInstruction) node);
                break;

            default :
                new AssertionError("z肳ꂽm[hł͂܂");
            }
        }
    }

    /**
     * <p>Jn^OfCY܂B</p>
     * @param elm <code>Element</code>m[h
     */
    private void modelaizeStartTag(
        Element elm)
    {
        NamedNodeMap atts = elm.getAttributes( );
        AttributeModel[] att_models = null;
        if (atts != null) {

            att_models = new AttributeModel[atts.getLength( )];
            for (int i = 0; i < atts.getLength( ); i++) {

                String name = atts.item(i).getLocalName( );
                String value = atts.item(i).getNodeValue( );
                String pref = atts.item(i).getPrefix( );
                String id = atts.item(i).getNamespaceURI( );

                att_models[i] = new AttributeModelImpl(name, value, pref, id);
            }
        }

        ElementModel elm_model = new ElementModelImpl(elm.getLocalName( ), elm
            .getPrefix( ), elm.getNamespaceURI( ));
        models.add(new StartTagModelImpl(elm_model, new AttributesList(att_models)));
    }

    /**
     *  <p>I^OfCY܂B</p>
     * @param elm <code>Element</code>m[h
     */
    private void modelaizeEndTag(
        Element elm)
    {
        ElementModel elm_model = new ElementModelImpl(elm.getLocalName( ), elm
            .getPrefix( ), elm.getNamespaceURI( ));
        models.add(new EndTagModelImpl(elm_model));
    }

    /**
     * <p>͑Ώەf[^fCY܂B</p>
     * @param txt <code>Text</code>m[h
     */
    private void modelaizeText(
        Text txt)
    {
        models.add(new CharactersModelImpl(txt.getNodeValue( )));
    }

    /**
     * <p>͑ΏۊOf[^fCY܂B</p>
     * @param cdata <code>CDATASection</code>m[h
     */
    private void modelaizeCDATASection(
        CDATASection cdata)
    {
        models.add(new StartCdataModelImpl( ));
        models.add(new CharactersModelImpl(cdata.getNodeValue( )));
        models.add(new EndCdataModelImpl( ));
    }

    /**
     * <p>RgfCY܂B</p>
     * @param comm <code>Comment</code>m[h
     */
    private void modelaizeComment(
        Comment comm)
    {
                models.add(new CommentModelImpl(comm.getNodeValue( )));
    }
   

    /**
     * <p>PIfCY܂</p>
     * @param pi <code>ProcessingInstruction</code>m[h
     */
    private void modelaizePI(
        ProcessingInstruction pi)
    {
        models
            .add(new ProcessingInstructionModelImpl(pi.getTarget( ), pi.getData( )));
    }

	public void modelize(
        String arg0) throws LIXMPhaseException
    {}

}
