package org.pigeonblood.impl.core.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

import org.lixm.core.common.XMLType;
import org.lixm.core.list.XMLCursor;
import org.lixm.core.list.XMLDocumentList;
import org.lixm.core.model.AbstractModel;
import org.lixm.optional.v15.atattch.XMLManipulator;

/**
 * <p><code>XMLDocumentList<E extends AbstractModel></code>̒PȎłB<br>
 * <code>Collection<AbstractModel></code>̂ő
 * <em>Java Collections Framework</em>Ɠ̈\łB</p>
 * 
 * <h3>eANZX@</h3>
 * 
 * <h4>fւ̏ANZX</h4>
 * 
 * <p>fւ̏ANZXsɂ̓}js[^擾܂B</p>
 * 
 * <pre class="code">
 *     //fXg}js[^̎擾
 *     XMLManipulator<AbstractModel> mani = list.Iterator();
 *     for( ; mani.hasNext(); ){
 *         System.out.println(mani.next());
 *     }
 * </pre>
 * 
 * <p>̃R[h͈ȉƓ`łB</p>
 * 
 * <pre class="code">
 *     for(AbstractModel model : list){
 *         System.out.println(model);
 *     }
 * </pre>
 *
 * <p>܂A}js[^̑Oiƌނ͓ƗCfbNX炻ꂼJn܂B</p>
 * 
 * <h4>fւ̃_ANZX</h4>
 * 
 * <p>fւ̃_ANZXsɂ{@link #get(int)}
 * 𒼐ڗp邩AJ[\擾܂B</p>
 * 
 * <pre class="code">
 *
 *     XMLCursor cur = list.getCursor();
 *
 *     //ڃCfbNXw肵ăANZX
 *     System.out.println(list.get(10));
 *
 *     //J[\胂f̈ʒu擾ĂANZX
 *     System.out.println(list.get(cur.getRootStartTag()));
 *     System.out.println(list.get(cur.getFirst()));
 * </pre>
 * 
 * <h4>f̈ʒuւ̃ANZX</h4>
 * 
 * <p>f̈ʒu擾ɂ̓J[\擾܂B</p>
 * 
 * <pre class="code">
 *     XMLCursor cur = list.getCursor();
 * 
 *     System.out.println("[gvf̊Jn^Öʒu" + list.get(cur.getRootStartTag()) + "łB");
 *     System.out.println("[gvf̏I^Öʒu" + list.get(cur.getRootEndTag()) + "łB");
 *     
 * </pre>
 * 
 * @author tasogare
 * @version 0.3
 * @since 0.1
 *
 */
public class SimpleDocumentList implements XMLDocumentList<AbstractModel>, RandomAccess{

	private ArrayList<AbstractModel> models;

    private XMLCursor cursor;

    private boolean seal;

    private class SimpleXMLCursor implements XMLCursor {

        private int current;
        private int mark;

        SimpleXMLCursor() {
            resetIndex( );
            resetMark( );
        }

        public int dec() throws IndexOutOfBoundsException {

            if (!hasPrevious( )) {
                throw new IndexOutOfBoundsException( );
            }
            return ++current;
        }

        public int getFirst() {
            return 0;
        }

        public int getIndex() {
            return current;
        }

        public int getLast() {
            return models.size() - 1;
        }

        public XMLDocumentList<? extends AbstractModel> getList() {
            return SimpleDocumentList.this;
        }

        public int getMark() {
            return mark;
        }

        public boolean hasNext() {
            return ( next( ) < size() );
        }

        public boolean hasPrevious() {
            return ( previous( ) > -1 );
        }

        public int inc() throws IndexOutOfBoundsException {

            if (!hasNext( )) {
                throw new IndexOutOfBoundsException( );
            }
            return ++current;
        }

        public int next() {
            return current + 1;
        }

        public int nextTag() {

            if (!hasNext( )) return -1;

            int tempCurrent = getIndex( );
            AbstractModel nextModel = null;

            final int MAX_COUNT = size( );
            for (int i = 1; tempCurrent < MAX_COUNT; i++) {
                nextModel = get(getIndex( ) + i);

                boolean nextModelOfStartOrEndTag = ( nextModel
                    .matchTypes(XMLType.START_TAG) || nextModel
                    .matchTypes(XMLType.END_TAG) );

                if (nextModelOfStartOrEndTag) {
                    return ( getIndex( ) + i );
                }
            }
            return -1;
        }

        public int previous() {
            return current - 1;
        }

        public int previousTag() {
            if (!hasPrevious( )) return -1;

            AbstractModel previousModel = null;

            final int MAX_COUNT = getIndex( );
            for (int i = 1; i != MAX_COUNT; i++) {
                previousModel = get(getIndex( ) - i);

                boolean previousModelOfStartOrEndTag = ( previousModel
                    .matchTypes(XMLType.START_TAG) || previousModel
                    .matchTypes(XMLType.END_TAG) );

                if (previousModelOfStartOrEndTag) {
                    return ( getIndex( ) - i );
                }
            }
            return -1;
        }

        public void resetIndex() {
            current = -1;
        }

        public void resetMark() {
            mark = -1;
        }

        public void seek(
            int index) throws IndexOutOfBoundsException
        {
            setMark(current);
            setIndex(index);
        }

        public void setIndex(
            int index) throws IndexOutOfBoundsException
        {
            if (-1 <= index && index < size( )) {
                current = index;
            } else {
                throw new IndexOutOfBoundsException( );
            }
        }

        public void setMark(
            int index) throws IndexOutOfBoundsException
        {
            if (-1 <= index && index < size( )) {
                mark = index;
            } else {
                throw new ArrayIndexOutOfBoundsException( );
            }
        }

    }

    private class SimpleXMLManipulator implements XMLManipulator<AbstractModel>
    {

        private int headTo;
        private int tileTo;

        SimpleXMLManipulator() {
            headTo = -1;
            tileTo = size( );
        }

        public boolean hasNext() {
            return ( headTo + 1 < size( ) );
        }

        public boolean hasPrevious() {
            return ( tileTo-1 > -1 );
        }

        public AbstractModel next() throws NoSuchElementException {
            if(!hasNext()){
                throw new NoSuchElementException();
            }
            return models.get(++headTo);
        }

        public AbstractModel previous() throws NoSuchElementException {
            if(!hasPrevious( )){
                throw new NoSuchElementException();
            }
            return models.get(--tileTo);
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException( );
        }

    }

    /**
     * <p>\[XfzɐVȃXg쐬܂B</p>
     * 
     * @param models \[Xz
     */
    public SimpleDocumentList(
        AbstractModel[] models)
    {
    	for(AbstractModel model : models){
    		this.models.add(model);
    	}
        setSeal(true);
    }

    /**
     * <p>Xg̒w肵ĐVȃXg쐬܂B</p>
     * 
     * @param length Xg̒
     */
    public SimpleDocumentList(
        int length)
    {
        models = new ArrayList<AbstractModel>(length);
    }


    /**
     * XgɃfǉ܂B
     * 
     * @throws NullPointerException <code>null</code>nꂽƂ
     * @throws IllegalStateException XgV[Ăꍇ
     */
    public boolean add(
        AbstractModel model) throws NullPointerException, IllegalStateException
    {
    	if(model == null) throw new NullPointerException();

    	if(!isSealed( )){
    		models.add(model);
    		return true;
        }else{
        	throw new IllegalStateException();
        }
        
    }

    /**
     * <p>RNV̑SĂ̗vfXgɒǉ܂B<br>
     * RNV̗vf͑SăfłȂ΂Ȃ炸A
     * RNV܂̓f<code>null</code>̏ꍇ<code>NullPointerException</code>
     * ܂B</p>
     * 
     * <p>ɁAx̑삪ꍇɂ̓XgV[ꂽԂɂȂA
     * Xgɑ΂郂f̒ǉ삪s\ɂȂ܂B̂Ƃfǉ悤Ƃ
     * <code>IllegalStateException</code>܂B</p>
     * 
     * <p>̎ł̓Xgւ̃f̒ǉsꍇɉ炩̗OA
     * łȂꍇ͏ɖ߂lƂ<code>true</code>Ԃ܂B</p>
     * 
     * @return ̑삪ꍇA<code>true</code>
     * 
     * @throws NullPointerException RNV܂́Af<code>null</code>̏ꍇ
     * @throws IllegalStateException XgV[Ăꍇ
     * @throws ClassCastException f̃X[p[NX<code>AbstractModel</code>ł͂Ȃꍇ
     */
    public boolean addAll(
        Collection<? extends AbstractModel> c) throws NullPointerException,
        IllegalStateException, ClassCastException
    {
        //IɃXgV[Ăꍇ̓f̒ǉ͕s\
        if (isSealed( )) {
            throw new IllegalStateException( );
        }

        if (c == null) {
            throw new NullPointerException( );
        }

        for (AbstractModel model : c) {

            if (model.equals(null)) {
                throw new NullPointerException( );
            }

            models.add(model);
        }
        models.trimToSize( );
        return true;
    }

    /**
     * <p>XgNA܂B</p>
     * @throws IllegalStateException XgV[Ă鎞
     */
    public void clear() throws IllegalStateException{
    	if(isSealed( )) throw new IllegalStateException();

    	models = new ArrayList<AbstractModel>();
    }

    /**
     * <p>XgɎw肳ꂽf܂܂Ă邩ǂׂ܂B</p>
     * 
     * <p><code>o</code><code>AbstractModel</code>ɃLXgłȂꍇ
     * <code>ClassCastException</code>܂B</p>
     * 
     * <p>܂A<code>null</code>̏ꍇ
     * <code>NullPointerException</code>܂B</p>
     * 
     * @return XgɃf܂܂Ăꍇ<code>true</code>
     * 
     * @throws ClassCastException <code>AbstractModel</code>ɃLXgłȂꍇ
     * @throws NullPointerException <code>null</code>̏ꍇ
     */
    public boolean contains(
        Object o) throws ClassCastException, NullPointerException
    {
    	return models.contains(o);
//        if (o == null) {
//            throw new NullPointerException( );
//        }
//
//        final AbstractModel model = (AbstractModel) o;
//        for (AbstractModel target : this) {
//            if (target.equals(model)) {
//                return true;
//            }
//        }
//
//        return false;
    }

    /**
     * <p>XgɎw肳ꂽRNV̑SĂ܂܂Ă邩ǂׂ܂B</p>
     * 
     * <p><code>c</code>̎vf<code>AbstractModel</code>ɃLXgłȂꍇ
     * <code>ClassCastException</code>܂B</p>
     * 
     * <p>܂A<code>c</code>̂<code>null</code>̏ꍇ
     * <code>NullPointerException</code>܂B</p>
     * 
     * @return XgɃRNV̑SĂ܂܂Ăꍇ<code>true</code>
     */
    public boolean containsAll(
        Collection<?> c) throws ClassCastException, NullPointerException
    {
    	return models.containsAll(c);
//        if (c == null) {
//            throw new NullPointerException( );
//        }
//
//        for (Iterator<?> iterator = c.iterator( ); iterator.hasNext( );) {
//
//            if (!this.contains(iterator.next( ))) {
//                return false;
//            }
//        }
//        return true;
    }

    /**
     * Xg̎w肵ʒũf擾 
     * @param index 擾郂f̃Xgł̐Έʒu
     * @return AbstractModel^̃f
     */
    public AbstractModel get(
        int index)
    {
        return models.get(index);
    }

    /**
     * {@inheritDoc}
     */
    public XMLCursor getCursor() {

        //xƂ
        if (cursor == null) {
            cursor = new SimpleXMLCursor( );
        }
        return cursor;
    }

    /**
     * {@inheritDoc}
     */
    public AbstractModel getRootEndTag() {

        AbstractModel model = null;
        for (int idx = getCursor( ).getLast( ); idx > -1; idx--) {

            model = (AbstractModel) get(idx);
            if (model.matchTypes(XMLType.END_TAG)) {
                return model;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    public AbstractModel getRootStartTag() {

        AbstractModel model = null;
        for (int idx = getCursor( ).getFirst( ); idx < size( ); idx++) {

            model = (AbstractModel) get(idx);
            if (model.matchTypes(XMLType.START_TAG)) {
                return model;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    public boolean isEmpty() {
        return models.isEmpty( );
    }

    /**
     * {@inheritDoc}
     */
    public Iterator<AbstractModel> iterator() {
        return new SimpleXMLManipulator( );
    }

    /**
     * <p>T|[g܂B<code>UnsupportedOperationException</code>܂B</p>
     * @throws UnsupportedOperationException ̃Iy[VsꍇAɓ܂
     */
    public boolean remove(
        Object o) throws UnsupportedOperationException
    {
        throw new UnsupportedOperationException( );
    }

    /**
     * <p>T|[g܂B<code>UnsupportedOperationException</code>܂B</p>
     * <p>{@link #clear()}𗘗pĂB</p>
     * @throws UnsupportedOperationException ̃Iy[VsꍇAɓ܂
     */
    public boolean removeAll(
        Collection<?> c) throws UnsupportedOperationException
    {
        throw new UnsupportedOperationException( );
    }

    /**
     * <p>w肳ꂽRNVɊi[Ăvfێ܂ B</p>
     * <p>܂Aw肳ꂽRNVɊi[ĂȂׂĂ̗vf̃RNV폜܂B</p>
     * 
     * @throws IllegalStateException XgV[Ă鎞
     */
    public boolean retainAll(
        Collection<?> c) throws IllegalStateException
    {
		if(isSealed( )) throw new IllegalStateException();
		return models.retainAll(c);
    }

    /**
     * {@inheritDoc}
     */
    public int size() {
        return models.size();
    }

    /**
     * <p>\bh́Azx[X API ƃRNVx[X API ̊Ԃ̋nƂċ@\܂B</p>
     */
    public Object[] toArray() {
        return models.toArray();
    }

    /**
     * <p>\bh́Azx[X API ƃRNVx[X API ̊Ԃ̋nƂċ@\܂B</p>
     */
    public <T> T[] toArray(
        T[] a)
    {
        return models.toArray(a);
    }

    /**
     * {@inheritDoc}
     */
    public boolean isSealed() {
        return seal;
    }


    /**
     * <p>Xg̎w肳ꂽʒuɂvfAw肳ꂽvfɒu܂B</p>
     * 
     * @throws IllegalArgumentException w肳ꂽvf̂vpeB[ŁÃXgɂ̗vfǉłȂꍇB
     * @throws ArrayIndexOutOfBoundsException CfbNX͈͊Ȍꍇ (index < 0 || index > size())
     * @throws NullPointerException fXg<code>null</code>e܂B
     * @throws IllegalStateException XgV[Ă鎞
     */
	public void set(
        AbstractModel model, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException, NullPointerException, IllegalStateException
    {
		if(model==null) throw new NullPointerException();
		if(isSealed( )) throw new IllegalStateException();
		models.set(index, model);
    }

	/**
	 * {@inheritDoc}
	 */
	public void setSeal(
        boolean seal) throws IllegalStateException
    {
		if(isSealed( )) throw new IllegalStateException();
		this.seal = seal;
    }

}
