--------------------------------------------------------------------------------
-- EZweb
--------------------------------------------------------------------------------

-- V[Y
INSERT INTO ezweb_series (name) VALUES ('Tu-Ka');
INSERT INTO ezweb_series (name) VALUES ('C200');
INSERT INTO ezweb_series (name) VALUES ('C300');
INSERT INTO ezweb_series (name) VALUES ('C400');
INSERT INTO ezweb_series (name) VALUES ('C1000');
INSERT INTO ezweb_series (name) VALUES ('C3000');
INSERT INTO ezweb_series (name) VALUES ('C5000');
INSERT INTO ezweb_series (name) VALUES ('A1000');
INSERT INTO ezweb_series (name) VALUES ('A1100');
INSERT INTO ezweb_series (name) VALUES ('A1300');
INSERT INTO ezweb_series (name) VALUES ('A1400');
INSERT INTO ezweb_series (name) VALUES ('A3000');
INSERT INTO ezweb_series (name) VALUES ('A5000');
INSERT INTO ezweb_series (name) VALUES ('W');

--------------------------------------------------------------------------------

-- Ezweb [

-- Tu-Ka
INSERT INTO ezweb (device_type, series_name, product_name)
	VALUES ('SYT1', 'Tu-Ka', 'TS01');
INSERT INTO ezweb (device_type, series_name, product_name)
	VALUES ('TST1', 'Tu-Ka', 'TT01');
INSERT INTO ezweb (device_type, series_name, product_name)
	VALUES ('KCT1', 'Tu-Ka', 'TK01');
INSERT INTO ezweb (device_type, series_name, product_name)
	VALUES ('KCT2', 'Tu-Ka', 'TK02');
INSERT INTO ezweb (device_type, series_name, product_name)
	VALUES ('KCT3', 'Tu-Ka', 'TK0K');
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, bmp_1bit)
	VALUES ('TST2', 'Tu-Ka', 'TT02', 120, 98, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, bmp_1bit, bmp_2bit)
	VALUES ('MAT1', 'Tu-Ka', 'TP01', 128, 78, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, bmp_1bit, bmp_2bit)
	VALUES ('MAT2', 'Tu-Ka', 'TP01', 128, 78, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('SYT2', 'Tu-Ka', 'TS02', 96, 92, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('KCT4', 'Tu-Ka', 'TK03', 96, 104, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('KCT5', 'Tu-Ka', 'TK04', 96, 104, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('TST3', 'Tu-Ka', 'TT03', 120, 128, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('KCT6', 'Tu-Ka', 'TK05', 96, 104, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('MAT3', 'Tu-Ka', 'TP11', 96, 108, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('MIT1', 'Tu-Ka', 'TD11', 120, 117, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('KCT7', 'Tu-Ka', 'TK11', 96, 104, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit)
	VALUES ('SYT3', 'Tu-Ka', 'TS11', 120, 128, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('KCT8', 'Tu-Ka', 'TK12', 120, 137, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit, bmp_1bit)
	VALUES ('TST4', 'Tu-Ka', 'TT11', 120, 143, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit, bmp_1bit)
	VALUES ('TST5', 'Tu-Ka', 'TT21', 144, 133, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit, bmp_1bit)
	VALUES ('KCT9', 'Tu-Ka', 'TK21', 120, 137, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit, bmp_1bit)
	VALUES ('TST6', 'Tu-Ka', 'TT22', 144, 155, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit)
	VALUES ('KCTA', 'Tu-Ka', 'TK22', 120, 137, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('KCTB', 'Tu-Ka', 'TK23', 120, 137, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit, bmp_1bit)
	VALUES ('SYT4', 'Tu-Ka', 'TS31', 120, 112, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit, bmp_1bit)
	VALUES ('KCTC', 'Tu-Ka', 'TK31', 120, 137, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit, bmp_1bit)
	VALUES ('TST7', 'Tu-Ka', 'TT31', 144, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit, bmp_1bit)
	VALUES ('TST8', 'Tu-Ka', 'TT32', 144, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit, bmp_1bit)
	VALUES ('KCTD', 'Tu-Ka', 'TK40', 120, 137, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit)
	VALUES ('SYT5', 'Tu-Ka', 'TS41', 132, 144, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('KCU1', 'Tu-Ka', 'TK41', 120, 137, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit, bmp_1bit)
	VALUES ('TST9', 'Tu-Ka', 'TT51', 240, 320, TRUE, TRUE, TRUE);

INSERT INTO ezweb (device_type, series_name, product_name)
	VALUES ('HI01', 'C200', 'C201H');
INSERT INTO ezweb (device_type, series_name, product_name)
	VALUES ('HI02', 'C200', 'C201H');
INSERT INTO ezweb (device_type, series_name, product_name)
	VALUES ('DN01', 'C200', 'C202DE');
INSERT INTO ezweb (device_type, series_name, product_name)
	VALUES ('TS11', 'C300', 'C301T');
INSERT INTO ezweb (device_type, series_name, product_name)
	VALUES ('HI11', 'C300', 'C302H');
INSERT INTO ezweb (device_type, series_name, product_name)
	VALUES ('CA11', 'C300', 'C303CA');
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, bmp_1bit)
	VALUES ('SY11', 'C300', 'C304SA', 128, 96, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, bmp_2bit, bmp_1bit)
	VALUES ('SN11', 'C300', 'C305S', 120, 96, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, bmp_1bit)
	VALUES ('KC11', 'C300', 'C307K', 121, 90, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, bmp_2bit, bmp_1bit)
	VALUES ('MA11', 'C300', 'C308P', 122, 78, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, bmp_2bit, bmp_1bit)
	VALUES ('MA12', 'C300', 'C308P', 122, 78, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('HI12', 'C300', 'C309H', 120, 96, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('TS12', 'C300', 'C310T', 96, 112, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, bmp_1bit)
	VALUES ('CA12', 'C300', 'C311CA', 127, 93, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit, bmp_1bit)
	VALUES ('KC12', 'C300', 'C313K', 120, 111, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('SY12', 'C400', 'C401SA', 120, 128, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit, bmp_1bit)
	VALUES ('DN11', 'C400', 'C402DE', 120, 112, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit, bmp_1bit)
	VALUES ('ST11', 'C400', 'C403ST', 120, 108, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit, bmp_1bit)
	VALUES ('SN12', 'C400', 'C404S', 120, 120, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit, bmp_1bit)
	VALUES ('SN14', 'C400', 'C404S', 120, 120, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, bmp_2bit, bmp_1bit)
	VALUES ('SY13', 'C400', 'C405SA', 120, 96, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit, bmp_1bit)
	VALUES ('SN13', 'C400', 'C406S', 120, 120, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit, bmp_1bit)
	VALUES ('HI13', 'C400', 'C407H', 120, 112, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit, bmp_1bit)
	VALUES ('MA13', 'C400', 'C408P', 120, 115, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit, bmp_1bit)
	VALUES ('CA13', 'C400', 'C409CA', 120, 96, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('TS13', 'C400', 'C410T', 96, 112, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit, bmp_1bit)
	VALUES ('ST12', 'C400', 'C411ST', 120, 104, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit, bmp_1bit)
	VALUES ('SY14', 'C400', 'C412SA', 120, 128, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('SN15', 'C400', 'C413S', 120, 120, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('SN16', 'C400', 'C413S', 120, 120, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit)
	VALUES ('KC13', 'C400', 'C414K/C414U', 120, 120, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('TS14', 'C400', 'C415T', 96, 112, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('HI14', 'C400', 'C451H', 120, 112, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('CA14', 'C400', 'C452CA', 120, 109, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit, bmp_1bit)
	VALUES ('SY15', 'C1000', 'C1001SA', 120, 128, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, png_8bit)
	VALUES ('SN17', 'C1000', 'C1002S', 120, 120, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit, bmp_1bit)
	VALUES ('ST13', 'A1000', 'A1011ST', 128, 129, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit)
	VALUES ('KC14', 'A1000', 'A1012K', 120, 120, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit)
	VALUES ('KC15', 'A1000', 'A1013K', 120, 160, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, jpeg, png_8bit, bmp_1bit)
	VALUES ('ST14', 'A1000', 'A1014ST', 132, 147, TRUE, TRUE, TRUE);

INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('HI21', 'C3000', 'C3001H', 120, 116, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('KC21', 'C3000', 'C3002K', 128, 120, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('MA21', 'C3000', 'C3003P', 132, 176, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('SA21', 'A3000', 'A3011SA', 132, 128, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('CA21', 'A3000', 'A3012CA', 132, 147, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('TS22', 'A3000', 'A3013T', 144, 156, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SN21', 'A3000', 'A3014S', 120, 120, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('SA22', 'A3000', 'A3015SA', 132, 176, TRUE, TRUE, TRUE, TRUE);

INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SN22', 'A1300', 'A1101S', 120, 120, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SN23', 'A1300', 'A1301S', 120, 145, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SA24', 'A1300', 'A1302SA', 132, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SA25', 'A1300', 'A1303SA', 132, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('TS25', 'A1300', 'A1304T/A1304TU', 144, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SA28', 'A1300', 'A1305SA', 132, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('KC23', 'A1400', 'A1401K', 132, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SN26', 'A1400', 'A1402S', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SN28', 'A1400', 'A1402SUJ', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SN27', 'A1400', 'A1402SU', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('KC26', 'A1400', 'A1403K', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SN29', 'A1400', 'A1404S/SU', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('PT21', 'A1400', 'A1405PT', 240, 320, TRUE, TRUE, TRUE);

INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('TS21', 'C5000', 'C5001T', 144, 135, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('TS23', 'A5000', 'A5301T', 144, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('CA22', 'A5000', 'A5302CA', 132, 163, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('HI23', 'A5000', 'A5303H', 132, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('HI24', 'A5000', 'A5303HU', 132, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('TS24', 'A5000', 'A5304T', 144, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('KC22', 'A5000', 'A5305K', 132, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('ST21', 'A5000', 'A5306ST', 132, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('CA23', 'A5000', 'A5401CA/A5401CAU', 132, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SN24', 'A5000', 'A5402S', 120, 160, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('CA24', 'A5000', 'A5403CA', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SN25', 'A5000', 'A5404S', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('ST23', 'A5000', 'A5405SA', 132, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('CA25', 'A5000', 'A5406CA', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('CA26', 'A5000', 'A5407CA', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('TS26', 'A5000', 'A5501T', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('KC24', 'A5000', 'A5502K', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('KC25', 'A5000', 'A5502K', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SA26', 'A5000', 'A5503SA', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('TS27', 'A5000', 'A5504T', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SA27', 'A5000', 'A5505SA', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('TS28', 'A5000', 'A5506T', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('ST24', 'A5000', 'A5507SA', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('TS29', 'A5000', 'A5509T', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('TS2A', 'A5000', 'A5511T', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('CA27', 'A5000', 'A5512CA', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('ST27', 'A5000', 'A5514SA', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('TS2B', 'A5000', 'A5516T', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('TS2C', 'A5000', 'A5517T', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('ST22', NULL, 'INFOBAR', 132, 176, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('ST25', NULL, 'talby', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('ST26', NULL, 'Sweets', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('CA28', NULL, 'G''zOne TYPE-R', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('ST29', NULL, 'Sweets pure', 240, 320, TRUE, TRUE, TRUE);

INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('HI31', 'W', 'W11H', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('KC31', 'W', 'W11K', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('HI32', 'W', 'W21H', 132, 176, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('KC32', 'W', 'W21K', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SN31', 'W', 'W21S', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('SA31', 'W', 'W21SA', 240, 320, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('TS31', 'W', 'W21T', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('CA31', 'W', 'W21CA/CAU', 240, 400, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('HI33', 'W', 'W22H', 240, 320, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('SA32', 'W', 'W22SA', 240, 320, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('SA33', 'W', 'W31SA/SAU', 240, 320, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('KC33', 'W', 'W31K/KU', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SN32', 'W', 'W31S', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('TS32', 'W', 'W31T', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('CA32', 'W', 'W31CA', 240, 400, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SN33', 'W', 'W32S', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('HI35', 'W', 'W32H', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('KC34', 'W', 'W32K', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit)
	VALUES ('SA34', 'W', 'W32SA', 240, 320, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('HI34', NULL, 'PENCK', 240, 320, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('SN34', 'W', 'W41S', 240, 320, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('CA33', 'W', 'W41CA', 240, 320, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('HI36', 'W', 'W41H', 240, 320, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('TS34', 'W', 'W41T', 240, 320, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('SA36', 'W', 'W41SA', 240, 320, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('KC35', 'W', 'W41K', 240, 320, TRUE, TRUE, TRUE, TRUE);
INSERT INTO ezweb (device_type, series_name, product_name, screen_width, screen_height, gif, jpeg, png_8bit, bmp_1bit)
	VALUES ('TS35', NULL, 'neon', 240, 320, TRUE, TRUE, TRUE, TRUE);

--------------------------------------------------------------------------------

-- ʐ^t[

-- A1000V[Y
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC15', 120, 160);	-- A1013K
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST14', 120, 160);	-- A1014ST

-- A1400/A1300/A1100V[Y
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN23', 120, 160);	-- A1301S
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA24', 132, 176);	-- A1302SA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA25', 132, 176);	-- A1303SA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS25', 144, 176);	-- A1304T/A1304TU
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA28', 132, 176);	-- A1305SA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC23', 120, 160);	-- A1401K
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN26', 240, 320);	-- A1402S
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN26', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN27', 240, 320);	-- A1402SU
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN27', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC26', 240, 320);	-- A1403K
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC26', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN29', 240, 320);	-- A1404S/A1404SU
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN29', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('PT21', 240, 320);	-- A1405PT
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('PT21', 100, 100);

-- A3000V[Y
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA21', 120, 160);	-- A3012CA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA22', 132, 176);	-- A3015SA

-- Sweets/talby/INFOBAR/A5000V[Y
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS23',  80,  60);	-- A5301T
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS23', 144, 176);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA22', 120, 160);	-- A5302CA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('HI23', 120, 160);	-- A5303H
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('HI24', 120, 160);	-- A5303HU
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS24', 144, 176);	-- A5304T
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC22', 120, 160);	-- A5305K
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST21', 132, 176);	-- A5306ST
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA23', 132, 176);	-- A5401CA/A5401CAU
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN24', 240, 320);	-- A5402S
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN24', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA24', 240, 320);	-- A5403CA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA24', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN25', 240, 320);	-- A5404S
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN25', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST23', 132, 176);	-- A5405SA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA25', 240, 320);	-- A5406CA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA25', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA26', 240, 320);	-- A5407CA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA26', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS26', 240, 320);	-- A5501T
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC24', 240, 320);	-- A5502K
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC24', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC25', 240, 320);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC25', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA26', 240, 320);	-- A5503SA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA26', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS27', 240, 320);	-- A5504T
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS27', 144, 176);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA27', 240, 320);	-- A5505SA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA27', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS28', 240, 320);	-- A5506T
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS28', 144, 176);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST24', 240, 320);	-- A5507SA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST24', 640, 480);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST24', 132, 176);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS29', 240, 320);	-- A5509T
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS29', 144, 176);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS2A', 240, 320);	-- A5511T
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS2A',  94,  94);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA27', 240, 320);	-- A5512CA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA27', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST27', 240, 320);	-- A5514SA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST27', 100, 100);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS2B', 240, 320);	-- A5516T
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS2B',  94,  94);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS2C', 240, 320);	-- A5517T
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS2C',  94,  94);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST22', 132, 176);	-- INFOBAR
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST25', 240, 320);	-- talby
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST25', 640, 480);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST25', 132, 176);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST26', 240, 320);	-- Sweets
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST26', 640, 480);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('ST26', 132, 176);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA28', 240, 320);	-- G'zOne TYPE-R
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA28', 120, 160);

-- PENCK/WV[Y
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('HI31', 240, 320);	-- W11H
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('HI31', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC31', 240, 320);	-- W11K
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC31', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('HI32', 132, 176);	-- W21H
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC32', 240, 320);	-- W21K
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC32', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN31', 240, 320);	-- W21S
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN31', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA31',  240,  320);	-- W21SA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA31', 1600, 1200);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA31',  120,  160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA31', 1280,  960);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS31',  240,  320);	-- W21T
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS31',  144,  176);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS31',   94,   94);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA31',  240,  400);	-- W21CA/CAU
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA31',  240,  320);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA31',  120,  160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('HI33', 240, 320);	-- W22H
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('HI33', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA32', 240, 320);	-- W22SA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA32', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA33', 240, 320);	-- W31SA/SAU
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA33', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC33', 240, 320);	-- W31K/KU
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC33', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN32', 240, 320);	-- W31S
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN32', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS32', 240, 320);	-- W31T
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS32', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA32', 240, 320);	-- W31CA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA32', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN33', 240, 320);	-- W32S
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN33', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('HI35', 240, 320);	-- W32H
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('HI35', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC34', 240, 320);	-- W32K
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC34', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA34', 240, 320);	-- W32SA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA34',  34,  34);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('HI34', 240, 320);	-- PENCK
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('HI34', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN34', 240, 230);	-- W41S
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SN34', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA33', 240, 230);	-- W41CA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('CA33', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('HI36', 240, 230);	-- W41H
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('HI36', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS34', 240, 230);	-- W41T
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS34',  94,  94);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA36', 240, 230);	-- W41SA
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('SA36',  34,  34);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC35', 240, 230);	-- W41K
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('KC35', 120, 160);
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS35', 240, 230);	-- neon
INSERT INTO ezweb_frame (device_type, width, height) VALUES ('TS35',  94,  94);

--------------------------------------------------------------------------------

-- ʐ^X^v

-- A1000V[Y
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('ST14', 120, 160);	-- A1014ST

-- A1400/A1300/A1100V[Y
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SN23', 120, 160);	-- A1301S
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SA24',  64,  64);	-- A1302SA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SA25',  64,  64);	-- A1303SA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('TS25', 100, 100);	-- A1304T/A1304TU
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SA28',  64,  64);	-- A1305SA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('KC23', 120, 160);	-- A1401K
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SN26', 240, 320);	-- A1402S
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SN27', 240, 320);	-- A1402SU
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('KC26', 240, 320);	-- A1403K
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SN29', 240, 320);	-- A1404S/A1404SU
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('PT21', 200, 200);	-- A1405PT

-- A3000V[Y
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('CA21', 120, 160);	-- A3012CA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SA22',  64,  64);	-- A3015SA

-- Sweets/talby/INFOBAR/A5000V[Y
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('TS23',  32,  32);	-- A5301T
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('CA22', 120, 160);	-- A5302CA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('HI23', 120, 160);	-- A5303H
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('HI24', 120, 160);	-- A5303HU
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('TS24', 100, 100);	-- A5304T
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('KC22', 120, 160);	-- A5305K
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('ST21', 132, 176);	-- A5306ST
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('CA23', 132, 176);	-- A5401CA/A5401CAU
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SN24', 120, 160);	-- A5402S
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('CA24', 240, 320);	-- A5403CA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SN25', 240, 320);	-- A5404S
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('ST23', 132, 176);	-- A5405SA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('CA25', 240, 320);	-- A5406CA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('CA26', 240, 320);	-- A5407CA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('TS26', 200, 200);	-- A5501T
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('KC24', 240, 320);	-- A5502K
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SA26', 200, 200);	-- A5503SA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('TS27', 200, 200);	-- A5504T
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SA27', 200, 200);	-- A5505SA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('TS28', 200, 200);	-- A5506T
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('ST24', 240, 320);	-- A5507SA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('TS29', 200, 200);	-- A5509T
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('TS2A', 240, 268);	-- A5511T
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('CA27', 240, 320);	-- A5512CA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('ST27', 240, 320);	-- A5514SA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('TS2B', 240, 268);	-- A5516T
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('TS2C', 240, 268);	-- A5517T
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('ST22', 132, 176);	-- INFOBAR
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('ST25', 240, 320);	-- talby
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('ST26', 240, 320);	-- Sweets
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('CA28', 240, 320);	-- G'zOne TYPE-R

-- PENCK/WV[Y
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('HI31', 240, 320);	-- W11H
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('KC31', 240, 320);	-- W11K
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('HI32',  32,  32);	-- W21H
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('KC32', 240, 320);	-- W21K
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SN31', 240, 240);	-- W21S
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SA31', 200, 200);	-- W21SA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('TS31', 240, 268);	-- W21T
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('CA31', 240, 400);	-- W21CA/CAU
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('HI33', 240, 320);	-- W22H
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SA32', 200, 200);	-- W22SA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SA33', 200, 200);	-- W31SA/SAU
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('KC33', 240, 320);	-- W31K/KU
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SN32', 240, 240);	-- W31S
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('TS32', 240, 268);	-- W31T
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('CA32', 240, 400);	-- W31CA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SN33', 240, 240);	-- W32S
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('HI35', 240, 400);	-- W32H
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('KC34', 240, 320);	-- W32K
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SA34', 200, 200);	-- W32SA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('HI34', 240, 320);	-- PENCK
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SN34', 240, 240);	-- W41S
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('CA33', 240, 400);	-- W41CA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('HI36', 240, 400);	-- W41H
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('TS34', 240, 268);	-- W41T
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('SA36', 200, 200);	-- W41SA
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('KC35', 240, 320);	-- W41K
INSERT INTO ezweb_stamp (device_type, width, height) VALUES ('TS35', 240, 268);	-- neon
