/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.springframework.jms.connection.JmsTransactionManager;

public class JmsTransactionManager102
extends JmsTransactionManager {
    private boolean pubSubDomain = false;

    public JmsTransactionManager102() {
    }

    public JmsTransactionManager102(ConnectionFactory connectionFactory, boolean pubSubDomain) {
        this.setConnectionFactory(connectionFactory);
        this.pubSubDomain = pubSubDomain;
        this.afterPropertiesSet();
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.isPubSubDomain()) {
            if (!(this.getConnectionFactory() instanceof TopicConnectionFactory)) {
                throw new IllegalArgumentException("Specified a Spring JMS 1.0.2 transaction manager for topics but did not supply an instance of TopicConnectionFactory");
            }
        } else if (!(this.getConnectionFactory() instanceof QueueConnectionFactory)) {
            throw new IllegalArgumentException("Specified a Spring JMS 1.0.2 transaction manager for queues but did not supply an instance of QueueConnectionFactory");
        }
    }

    protected Connection createConnection() throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicConnectionFactory)this.getConnectionFactory()).createTopicConnection();
        }
        return ((QueueConnectionFactory)this.getConnectionFactory()).createQueueConnection();
    }

    protected Session createSession(Connection con) throws JMSException {
        if (this.isPubSubDomain()) {
            return ((TopicConnection)con).createTopicSession(true, 1);
        }
        return ((QueueConnection)con).createQueueSession(true, 1);
    }
}

