/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.datasource.SimpleConnectionHandle;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.util.Assert;

public class ConnectionHolder
extends ResourceHolderSupport {
    private ConnectionHandle connectionHandle;
    private Connection currentConnection;
    private boolean transactionActive = false;

    public ConnectionHolder(ConnectionHandle connectionHandle) {
        Assert.notNull(connectionHandle, "ConnectionHandle must not be null");
        this.connectionHandle = connectionHandle;
    }

    public ConnectionHolder(Connection connection) {
        this.connectionHandle = new SimpleConnectionHandle(connection);
    }

    public ConnectionHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    protected boolean hasConnection() {
        return this.connectionHandle != null;
    }

    protected void setTransactionActive(boolean transactionActive) {
        this.transactionActive = transactionActive;
    }

    protected boolean isTransactionActive() {
        return this.transactionActive;
    }

    protected void setConnection(Connection connection) {
        if (this.currentConnection != null) {
            this.connectionHandle.releaseConnection(this.currentConnection);
            this.currentConnection = null;
        }
        this.connectionHandle = connection != null ? new SimpleConnectionHandle(connection) : null;
    }

    public Connection getConnection() {
        Assert.notNull(this.connectionHandle, "Active Connection is required");
        if (this.currentConnection == null) {
            this.currentConnection = this.connectionHandle.getConnection();
        }
        return this.currentConnection;
    }

    public void released() {
        super.released();
        if (this.currentConnection != null) {
            this.connectionHandle.releaseConnection(this.currentConnection);
            this.currentConnection = null;
        }
    }

    public void clear() {
        super.clear();
        this.transactionActive = false;
    }
}

