/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.vodafone;

import jp.sourceforge.livez.vodafone.VodafoneBrowser;
import jp.sourceforge.livez.vodafone.VodafoneRequest;
import jp.sourceforge.livez.vodafone.VodafoneType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

final class VodafoneBrowserImpl
implements VodafoneBrowser {
    private static final long serialVersionUID = 1L;
    private int width = 0;
    private int height = 0;
    private int cacheSize = 0;
    private Float mmlVersion = null;
    private Float htmlVersion = null;
    private Float xhtmlVersion = null;

    public VodafoneBrowserImpl(VodafoneRequest r) {
        this.width = r.getDisplayWidth();
        this.height = r.getDisplayHeight();
        switch (r.getType().getCategoryType()) {
            case C: {
                this.cacheSize = 6144;
                if (r.getType() == VodafoneType.C2) {
                    this.mmlVersion = new Float("2.0");
                    this.htmlVersion = new Float("2.0");
                    break;
                }
                this.mmlVersion = new Float("3.0");
                this.htmlVersion = new Float("3.0");
                break;
            }
            case P: {
                switch (r.getType()) {
                    case P4_1: 
                    case P4_2: {
                        this.cacheSize = 12288;
                        break;
                    }
                    default: {
                        this.cacheSize = 30720;
                    }
                }
                this.mmlVersion = new Float("3.0");
                this.htmlVersion = new Float("4.0");
                break;
            }
            case W: {
                this.htmlVersion = new Float("4.0");
                this.xhtmlVersion = new Float("1.0");
                this.cacheSize = 204800;
                break;
            }
            case THREE_GC: {
                this.xhtmlVersion = new Float("1.0");
                this.cacheSize = 307200;
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getColumn() {
        return 0;
    }

    public int getRow() {
        return 0;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public Float getMmlVersion() {
        return this.mmlVersion;
    }

    public Float getHtmlVersion() {
        return this.htmlVersion;
    }

    public Float getXhtmlVersion() {
        return this.xhtmlVersion;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

