/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.mail;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;
import jp.sourceforge.livez.lang.JaStringUtils;
import jp.sourceforge.livez.mail.MailMessage;
import jp.sourceforge.livez.mail.MailMessageImpl;
import jp.sourceforge.livez.mail.MailProfile;
import org.apache.commons.lang.StringUtils;

public final class MailRetriever {
    protected MailProfile profile = null;
    protected Session session = null;
    private Store store;
    private Folder currentFolder = null;

    public MailRetriever(MailProfile profile, boolean debug) throws NoSuchProviderException {
        this.profile = profile;
        Properties prop = profile.getProperties();
        if (debug) {
            prop.put("mail.debug", "true");
        }
        this.session = Session.getInstance((Properties)prop, null);
        this.store = this.session.getStore(profile.receive.protocol);
    }

    public MailRetriever(MailProfile profile) throws NoSuchProviderException {
        this(profile, false);
    }

    public void connect() throws MessagingException {
        this.connect(this.profile.receive.account, this.profile.receive.password);
    }

    private void connect(String account, String password) throws MessagingException {
        this.disconnect();
        this.store.connect(this.profile.receive.hostname, this.profile.receive.port, account, password);
        try {
            this.setCurrentFolder("INBOX");
        }
        catch (MessagingException e) {
            this.disconnect();
            throw e;
        }
    }

    public void setCurrentFolder(boolean expunge, String name, boolean readOnly) throws MessagingException {
        this.closeCurrentFolder(expunge);
        this.currentFolder = StringUtils.isEmpty((String)name) ? this.store.getFolder("INBOX") : this.store.getFolder(JaStringUtils.microsoftUnicodeToUnicode(name));
        if (this.currentFolder == null) {
            throw new FolderNotFoundException();
        }
        if (readOnly) {
            this.currentFolder.open(1);
        } else {
            this.currentFolder.open(2);
        }
    }

    public void setCurrentFolder(boolean expunge, String name) throws MessagingException {
        this.setCurrentFolder(expunge, name, true);
    }

    public void setCurrentFolder(String path, boolean readOnly) throws MessagingException {
        this.setCurrentFolder(false, path, readOnly);
    }

    public void setCurrentFolder(String path) throws MessagingException {
        this.setCurrentFolder(false, path);
    }

    private void closeCurrentFolder(boolean expunge) {
        if (this.currentFolder != null && this.currentFolder.isOpen()) {
            try {
                this.currentFolder.close(expunge);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            this.currentFolder = null;
        }
    }

    public void disconnect() {
        this.disconnect(false);
    }

    public void disconnect(boolean expunge) {
        this.closeCurrentFolder(expunge);
        try {
            this.store.close();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.store != null && this.store.isConnected();
    }

    public boolean isOpen() {
        return this.currentFolder != null && this.currentFolder.isOpen();
    }

    public String[] getFolderNames() throws MessagingException {
        Folder[] folders = this.currentFolder.listSubscribed();
        String[] results = new String[folders.length];
        int index = 0;
        while (index < folders.length) {
            results[index] = JaStringUtils.unicodeToMicrosoftUnicode(folders[index].getFullName());
            ++index;
        }
        return results;
    }

    public String[] getAllFolderNames() throws MessagingException {
        Folder[] folders = this.store.getDefaultFolder().list("%");
        String[] results = new String[folders.length];
        int index = 0;
        while (index < folders.length) {
            results[index] = JaStringUtils.unicodeToMicrosoftUnicode(folders[index].getFullName());
            ++index;
        }
        return results;
    }

    public int getNewMessageCount() throws MessagingException {
        return this.currentFolder.getNewMessageCount();
    }

    public int getUnreadMessageCount() throws MessagingException {
        return this.currentFolder.getUnreadMessageCount();
    }

    public int getMessageCount() throws MessagingException {
        return this.currentFolder.getMessageCount();
    }

    public boolean isExistsFolder(String path) throws MessagingException {
        Folder folder = this.getFolder(path);
        return folder.exists();
    }

    public boolean createFolder(String path) throws MessagingException {
        Folder folder = this.getFolder(path);
        if (!folder.exists() && folder.create(3)) {
            folder.setSubscribed(true);
            return true;
        }
        return false;
    }

    public boolean renameFolder(String path1, String path2) throws MessagingException {
        Folder folder1 = this.getFolder(path1);
        Folder folder2 = this.getFolder(path2);
        if (folder1.exists() && !folder2.exists()) {
            if (folder1.isOpen()) {
                folder1.close(false);
            }
            return folder1.renameTo(folder2);
        }
        return false;
    }

    public boolean deleteFolder(String path) throws MessagingException {
        Folder folder = this.getFolder(path);
        if (folder.exists()) {
            return folder.delete(true);
        }
        return false;
    }

    private Folder getFolder(String path) throws MessagingException {
        String separator = String.valueOf(this.currentFolder.getSeparator());
        Folder folder = path.startsWith(separator) ? this.store.getFolder(String.valueOf(this.currentFolder.getFullName()) + separator + path) : this.store.getFolder(path);
        return folder;
    }

    public Message[] getMessages() throws MessagingException {
        return this.currentFolder.getMessages();
    }

    public MimeMessage[] getMimeMessages() throws MessagingException {
        Message[] messages = this.currentFolder.getMessages();
        MimeMessage[] mails = new MimeMessage[messages.length];
        int index = 0;
        while (index < messages.length) {
            mails[index] = (MimeMessage)messages[index];
            ++index;
        }
        return mails;
    }

    public MailMessage[] getMailMessages() throws MessagingException {
        Message[] messages = this.currentFolder.getMessages();
        MailMessage[] mails = new MailMessage[messages.length];
        int index = 0;
        while (index < messages.length) {
            mails[index] = new MailMessageImpl((MimeMessage)messages[index]);
            ++index;
        }
        return mails;
    }

    public MailMessage[] getMailMessages(Flags.Flag flag, boolean match) throws MessagingException {
        Message[] messages = this.currentFolder.getMessages();
        ArrayList<MailMessageImpl> list = new ArrayList<MailMessageImpl>(messages.length);
        int index = 0;
        while (index < messages.length) {
            Flags.Flag[] sf = messages[index].getFlags().getSystemFlags();
            boolean proccess = !match;
            int i = 0;
            while (i < sf.length) {
                if (sf[i] == flag) {
                    proccess = match;
                    break;
                }
                ++i;
            }
            if (match && proccess || !match && proccess) {
                list.add(new MailMessageImpl((MimeMessage)messages[index]));
            }
            ++index;
        }
        MailMessage[] mails = new MailMessage[list.size()];
        int index2 = 0;
        while (index2 < list.size()) {
            mails[index2] = (MailMessage)list.get(index2);
            ++index2;
        }
        return mails;
    }

    public void appendMessages(MailMessage message) throws MessagingException {
        this.appendMessages(((MailMessageImpl)message).message);
    }

    public void appendMessages(MimeMessage message) throws MessagingException {
        message.setFrom(null);
        InternetAddress[] address = new InternetAddress[1];
        try {
            address[0] = new InternetAddress(this.profile.address, this.profile.username, "ISO-2022-JP");
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException();
        }
        message.addFrom((Address[])address);
        message.setSentDate(new Date());
        message.setHeader("Content-Transfer-Encoding", "7bit");
        message.saveChanges();
        this.currentFolder.appendMessages(new Message[]{message});
    }

    public void copyMessage(MailMessage mail, String folder) throws MessagingException {
        this.copyMessage(((MailMessageImpl)mail).message, folder);
    }

    protected void copyMessage(MimeMessage message, String folder) throws MessagingException {
        this.currentFolder.copyMessages(new Message[]{message}, this.getFolder(folder));
    }

    public Message[] search(SearchTerm term) throws MessagingException {
        return this.currentFolder.search(term);
    }

    public MimeMessage[] searchMimeMessages(SearchTerm term) throws MessagingException {
        Message[] messages = this.currentFolder.search(term);
        MimeMessage[] results = new MimeMessage[messages.length];
        int i = 0;
        while (i < messages.length) {
            results[i] = (MimeMessage)messages[i];
            ++i;
        }
        return results;
    }

    public MailMessage[] searchMailMessages(SearchTerm term) throws MessagingException {
        Message[] messages = this.currentFolder.search(term);
        MailMessage[] results = new MailMessage[messages.length];
        int i = 0;
        while (i < messages.length) {
            results[i] = new MailMessageImpl((MimeMessage)messages[i]);
            ++i;
        }
        return results;
    }
}

