/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.lang;

public final class ImodeEmojiUtils {
    private ImodeEmojiUtils() {
    }

    public static boolean isStandardEmoji(char c) {
        return c >= '\ue63e' && c <= '\ue70b';
    }

    public static boolean isExtendedEmoji(char c) {
        return c >= '\ue70c' && c <= '\ue757';
    }

    public static boolean isEmoji(char c) {
        return ImodeEmojiUtils.isStandardEmoji(c) || ImodeEmojiUtils.isExtendedEmoji(c);
    }

    public static boolean isStandardEmoji(String s) {
        if (s == null) {
            return false;
        }
        int i = 0;
        while (i < s.length()) {
            if (ImodeEmojiUtils.isStandardEmoji(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isExtendedEmoji(String s) {
        if (s == null) {
            return false;
        }
        int i = 0;
        while (i < s.length()) {
            if (ImodeEmojiUtils.isExtendedEmoji(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEmoji(String s) {
        if (s == null) {
            return false;
        }
        int i = 0;
        while (i < s.length()) {
            if (ImodeEmojiUtils.isEmoji(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String removeStandardEmoji(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!ImodeEmojiUtils.isStandardEmoji(c)) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String removeExtendedEmoji(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!ImodeEmojiUtils.isExtendedEmoji(c)) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String removeEmoji(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!ImodeEmojiUtils.isEmoji(c)) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String renderAccesskeyEmoji(char c) {
        switch (c) {
            case '1': {
                return "\ue6e2";
            }
            case '2': {
                return "\ue6e3";
            }
            case '3': {
                return "\ue6e4";
            }
            case '4': {
                return "\ue6e5";
            }
            case '5': {
                return "\ue6e6";
            }
            case '6': {
                return "\ue6e7";
            }
            case '7': {
                return "\ue6e8";
            }
            case '8': {
                return "\ue6e9";
            }
            case '9': {
                return "\ue6ea";
            }
            case '0': {
                return "\ue6eb";
            }
            case '#': {
                return "\ue6e0";
            }
            case '*': {
                return "\uff0a";
            }
        }
        return null;
    }
}

