/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import jp.sourceforge.livez.filter.BufferedTextResponseWrapper;

public final class EncodeUrlFilter
implements Filter {
    private static final Pattern A_HREF = Pattern.compile("(<a(\\s+\\w+(=\"[^\"]*\")*)*(\\s+href=\"))([^\"]+)(\"(\\s+\\w+(=\"[^\"]*\")*)*\\s*/?\\s*>)", 2);
    private static final Pattern FORM_ACTION = Pattern.compile("(<form(\\s+\\w+(=\"[^\"]*\")*)*?(\\s+action=\"))([^\"]+)(\"(\\s+\\w+(=\"[^\"]*\")*)*\\s*>)", 2);

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        BufferedTextResponseWrapper r = new BufferedTextResponseWrapper(response);
        chain.doFilter(request, (ServletResponse)r);
        if (response.isCommitted()) {
            return;
        }
        if (response.getContentType() != null && response.getContentType().startsWith("text/")) {
            String page = EncodeUrlFilter.encodeAllURL((HttpServletResponse)r, r.getBuffer());
            PrintWriter out = response.getWriter();
            out.print(page);
        }
    }

    public void destroy() {
    }

    private static String encodeAllURL(HttpServletResponse response, CharSequence cs) {
        StringBuffer sb = EncodeUrlFilter.encodeURL(A_HREF, cs, response);
        sb = EncodeUrlFilter.encodeURL(FORM_ACTION, sb, response);
        return sb.toString();
    }

    private static StringBuffer encodeURL(Pattern pattern, CharSequence s, HttpServletResponse response) {
        Matcher matcher = pattern.matcher(s);
        StringBuffer results = new StringBuffer();
        while (matcher.find()) {
            String url = matcher.group(5);
            if (url.indexOf(58) == -1 && url.toLowerCase().indexOf(";jsessionid=") == -1) {
                url = response.encodeURL(url);
            }
            matcher.appendReplacement(results, String.valueOf(matcher.group(1)) + url + matcher.group(6));
        }
        matcher.appendTail(results);
        return results;
    }
}

