/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.mail.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;

public final class ByteArrayDataSource
implements DataSource {
    private byte[] data;
    private String contentType;

    public ByteArrayDataSource(byte[] data, String contentType) {
        this.data = data;
        this.contentType = contentType;
    }

    public ByteArrayDataSource(InputStream in, String contentType) throws IOException {
        int len;
        this.contentType = contentType;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        this.data = out.toByteArray();
    }

    public ByteArrayDataSource(Reader in, String contentType) throws IOException {
        String line;
        this.contentType = contentType;
        String charset = null;
        try {
            ContentType ct = new ContentType(contentType);
            charset = ct.getParameter("charset");
        }
        catch (ParseException ct) {
            // empty catch block
        }
        if (charset == null) {
            charset = "us-ascii";
        }
        BufferedReader reader = new BufferedReader(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((line = reader.readLine()) != null) {
            out.write(line.getBytes(charset));
            out.write(13);
            out.write(10);
        }
        this.data = out.toByteArray();
    }

    public ByteArrayDataSource(String text, String contentType) {
        this.contentType = contentType;
        String charset = null;
        try {
            ContentType ct = new ContentType(contentType);
            charset = ct.getParameter("charset");
        }
        catch (ParseException ct) {
            // empty catch block
        }
        if (charset == null) {
            charset = "us-ascii";
        }
        try {
            this.data = text.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            try {
                this.data = text.getBytes("us-ascii");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.data);
    }

    public String getName() {
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("cannot do this");
    }
}

