/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.smtp;

import com.sun.mail.smtp.DigestMD5;
import com.sun.mail.smtp.SMTPAddressFailedException;
import com.sun.mail.smtp.SMTPAddressSucceededException;
import com.sun.mail.smtp.SMTPMessage;
import com.sun.mail.smtp.SMTPOutputStream;
import com.sun.mail.smtp.SMTPSendFailedException;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.SocketFetcher;
import com.sun.mail.util.TraceInputStream;
import com.sun.mail.util.TraceOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.ParseException;

public class SMTPTransport
extends Transport {
    private String name = "smtp";
    private int defaultPort = 25;
    private boolean isSSL = false;
    private MimeMessage message;
    private Address[] addresses;
    private Address[] validSentAddr;
    private Address[] validUnsentAddr;
    private Address[] invalidAddr;
    boolean sendPartiallyFailed = false;
    MessagingException exception;
    private Hashtable extMap;
    private boolean quitWait = false;
    private String saslRealm = "UNKNOWN";
    private boolean reportSuccess;
    private boolean useStartTLS;
    private PrintStream out;
    private String localHostName;
    private String lastServerResponse;
    private int lastReturnCode;
    private static final String[] ignoreList = new String[]{"Bcc", "Content-Length"};
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final String UNKNOWN = "UNKNOWN";
    private DigestMD5 md5support;
    private BufferedInputStream serverInput;
    private LineInputStream lineInputStream;
    private OutputStream serverOutput;
    private Socket serverSocket;
    private static final char[] hexchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public SMTPTransport(Session session, URLName urlname) {
        this(session, urlname, "smtp", 25, false);
    }

    public SMTPTransport(Session session, URLName urlname, String name, int defaultPort, boolean isSSL) {
        super(session, urlname);
        if (urlname != null) {
            name = urlname.getProtocol();
        }
        this.name = name;
        this.defaultPort = defaultPort;
        this.isSSL = isSSL;
        this.out = session.getDebugOut();
        String s = session.getProperty("mail." + name + ".quitwait");
        this.quitWait = s != null && s.equalsIgnoreCase("true");
        s = session.getProperty("mail." + s + ".reportsuccess");
        this.reportSuccess = s != null && s.equalsIgnoreCase("true");
        s = session.getProperty("mail." + s + ".starttls.enable");
        this.useStartTLS = s != null && s.equalsIgnoreCase("true");
    }

    private String getLocalHost() {
        try {
            if (this.localHostName == null || this.localHostName.length() <= 0) {
                this.localHostName = this.session.getProperty("mail." + this.name + ".localhost");
            }
            if (this.localHostName == null || this.localHostName.length() <= 0) {
                this.localHostName = this.session.getProperty("mail." + this.name + ".localaddress");
            }
            if (this.localHostName == null || this.localHostName.length() <= 0) {
                InetAddress inetaddress = InetAddress.getLocalHost();
                this.localHostName = inetaddress.getHostName();
                if (this.localHostName == null) {
                    this.localHostName = "[" + inetaddress.getHostAddress() + "]";
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return this.localHostName;
    }

    public final void setLocalHost(String localHostName) {
        this.localHostName = localHostName;
    }

    public final synchronized void connect(Socket socket) throws MessagingException {
        this.serverSocket = socket;
        super.connect();
    }

    public final String getSASLRealm() {
        if (this.saslRealm == UNKNOWN) {
            this.saslRealm = this.session.getProperty("mail." + this.name + ".sasl.realm");
            if (this.saslRealm == null) {
                this.saslRealm = this.session.getProperty("mail." + this.name + ".saslrealm");
            }
        }
        return this.saslRealm;
    }

    public final void setSASLRealm(String saslRealm) {
        this.saslRealm = saslRealm;
    }

    public final boolean getReportSuccess() {
        return this.reportSuccess;
    }

    public final void setReportSuccess(boolean reportSuccess) {
        this.reportSuccess = reportSuccess;
    }

    public final boolean getStartTLS() {
        return this.useStartTLS;
    }

    public final void setStartTLS(boolean useStartTLS) {
        this.useStartTLS = useStartTLS;
    }

    public final String getLastServerResponse() {
        return this.lastServerResponse;
    }

    private synchronized DigestMD5 getMD5() {
        if (this.md5support == null) {
            this.md5support = new DigestMD5(this.debug ? this.out : null);
        }
        return this.md5support;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean protocolConnect(String host, int port, String user, String passwd) throws MessagingException {
        DigestMD5 md5;
        boolean useAuth;
        String ehloStr = this.session.getProperty("mail." + this.name + ".ehlo");
        boolean useEhlo = ehloStr == null || !ehloStr.equalsIgnoreCase("false");
        String authStr = this.session.getProperty("mail." + this.name + ".auth");
        boolean bl = useAuth = authStr != null && authStr.equalsIgnoreCase("true");
        if (this.debug) {
            this.out.println("DEBUG SMTP: useEhlo " + useEhlo + ", useAuth " + useAuth);
        }
        if (useAuth && (user == null || passwd == null)) {
            return false;
        }
        if (port == -1) {
            String portstring = this.session.getProperty("mail." + this.name + ".port");
            port = portstring != null ? Integer.parseInt(portstring) : this.defaultPort;
        }
        if (host == null || host.length() == 0) {
            host = "localhost";
        }
        boolean succeed = false;
        if (this.serverSocket != null) {
            this.openServer();
        } else {
            this.openServer(host, port);
        }
        if (useEhlo) {
            succeed = this.ehlo(this.getLocalHost());
        }
        if (!succeed) {
            this.helo(this.getLocalHost());
        }
        if (this.useStartTLS && this.supportsExtension("STARTTLS")) {
            this.startTLS();
            this.ehlo(this.getLocalHost());
        }
        if (!useAuth || !this.supportsExtension("AUTH") && !this.supportsExtension("AUTH=LOGIN")) return true;
        if (this.debug) {
            this.out.println("DEBUG SMTP: Attempt to authenticate");
            if (!this.supportsAuthentication("LOGIN") && this.supportsExtension("AUTH=LOGIN")) {
                this.out.println("DEBUG SMTP: use AUTH=LOGIN hack");
            }
        }
        if (this.supportsAuthentication("LOGIN") || this.supportsExtension("AUTH=LOGIN")) {
            int resp = this.simpleCommand("AUTH LOGIN");
            if (resp == 530) {
                this.startTLS();
                resp = this.simpleCommand("AUTH LOGIN");
            }
            try {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    BASE64EncoderStream b64os = new BASE64EncoderStream(bos, Integer.MAX_VALUE);
                    if (resp == 334) {
                        ((OutputStream)b64os).write(ASCIIUtility.getBytes(user));
                        ((OutputStream)b64os).flush();
                        resp = this.simpleCommand(bos.toByteArray());
                        bos.reset();
                    }
                    if (resp != 334) return true;
                    ((OutputStream)b64os).write(ASCIIUtility.getBytes(passwd));
                    ((OutputStream)b64os).flush();
                    resp = this.simpleCommand(bos.toByteArray());
                    bos.reset();
                    return true;
                }
                catch (IOException bos) {}
                return true;
            }
            finally {
                if (resp != 235) {
                    this.closeConnection();
                    return false;
                }
            }
        }
        if (this.supportsAuthentication("PLAIN")) {
            int resp = this.simpleCommand("AUTH PLAIN");
            try {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    BASE64EncoderStream b64os = new BASE64EncoderStream(bos, Integer.MAX_VALUE);
                    if (resp != 334) return true;
                    ((OutputStream)b64os).write(0);
                    ((OutputStream)b64os).write(ASCIIUtility.getBytes(user));
                    ((OutputStream)b64os).write(0);
                    ((OutputStream)b64os).write(ASCIIUtility.getBytes(passwd));
                    ((OutputStream)b64os).flush();
                    resp = this.simpleCommand(bos.toByteArray());
                    return true;
                }
                catch (IOException bos) {}
                return true;
            }
            finally {
                if (resp != 235) {
                    this.closeConnection();
                    return false;
                }
            }
        }
        if (!this.supportsAuthentication("DIGEST-MD5") || (md5 = this.getMD5()) == null) return true;
        int resp = this.simpleCommand("AUTH DIGEST-MD5");
        try {
            try {
                byte[] b;
                if (resp != 334 || (resp = this.simpleCommand(b = md5.authClient(host, user, passwd, this.getSASLRealm(), this.lastServerResponse))) != 334) return true;
                if (!md5.authServer(this.lastServerResponse)) {
                    resp = -1;
                    return true;
                }
                resp = this.simpleCommand(new byte[0]);
                return true;
            }
            catch (Exception ex) {
                if (!this.debug) return true;
                this.out.println("DEBUG SMTP: DIGEST-MD5: " + ex);
            }
            return true;
        }
        finally {
            if (resp != 235) {
                this.closeConnection();
                return false;
            }
        }
    }

    public final synchronized void sendMessage(Message message, Address[] addresses) throws MessagingException, SendFailedException {
        this.checkConnected();
        if (!(message instanceof MimeMessage)) {
            if (this.debug) {
                this.out.println("DEBUG SMTP: Can only send RFC822 msgs");
            }
            throw new MessagingException("SMTP can only send RFC822 messages");
        }
        int i = 0;
        while (i < addresses.length) {
            if (!(addresses[i] instanceof InternetAddress)) {
                throw new MessagingException(addresses[i] + " is not an InternetAddress");
            }
            ++i;
        }
        this.message = (MimeMessage)message;
        this.addresses = addresses;
        this.validUnsentAddr = addresses;
        this.expandGroups();
        boolean use8bit = false;
        if (message instanceof SMTPMessage) {
            use8bit = ((SMTPMessage)message).getAllow8bitMIME();
        }
        if (!use8bit) {
            String ebStr = this.session.getProperty("mail." + this.name + ".allow8bitmime");
            boolean bl = use8bit = ebStr != null && ebStr.equalsIgnoreCase("true");
        }
        if (this.debug) {
            this.out.println("DEBUG SMTP: use8bit " + use8bit);
        }
        if (use8bit && this.supportsExtension("8BITMIME")) {
            this.convertTo8Bit(this.message);
        }
        try {
            try {
                this.mailFrom();
                this.rcptTo();
                this.message.writeTo(this.data(), ignoreList);
                this.finishData();
                if (this.sendPartiallyFailed) {
                    if (this.debug) {
                        this.out.println("DEBUG SMTP: Sending partially failed because of invalid destination addresses");
                    }
                    this.notifyTransportListeners(3, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
                    throw new SMTPSendFailedException(".", this.lastReturnCode, this.lastServerResponse, this.exception, this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
                }
                this.notifyTransportListeners(1, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
            }
            catch (MessagingException mex) {
                if (this.debug) {
                    mex.printStackTrace(this.out);
                }
                this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
                throw mex;
            }
            catch (IOException ex) {
                if (this.debug) {
                    ex.printStackTrace(this.out);
                }
                try {
                    this.closeConnection();
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
                throw new MessagingException("IOException while sending message", ex);
            }
        }
        finally {
            this.invalidAddr = null;
            this.validUnsentAddr = null;
            this.validSentAddr = null;
            this.addresses = null;
            this.message = null;
            this.exception = null;
            this.sendPartiallyFailed = false;
        }
    }

    public final synchronized void close() throws MessagingException {
        if (!super.isConnected()) {
            return;
        }
        try {
            if (this.serverSocket != null) {
                int resp;
                this.sendCommand("QUIT");
                if (this.quitWait && (resp = this.readServerResponse()) != 221 && resp != -1) {
                    this.out.println("DEBUG SMTP: QUIT failed with " + resp);
                }
            }
        }
        finally {
            this.closeConnection();
        }
    }

    private void closeConnection() throws MessagingException {
        try {
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException ioex) {
                throw new MessagingException("Server Close Failed", ioex);
            }
        }
        finally {
            this.serverSocket = null;
            this.serverOutput = null;
            this.serverInput = null;
            this.lineInputStream = null;
            if (super.isConnected()) {
                super.close();
            }
        }
    }

    public final synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        try {
            this.sendCommand("NOOP");
            int resp = this.readServerResponse();
            if (resp >= 0 && resp != 421) {
                return true;
            }
            try {
                this.closeConnection();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            return false;
        }
        catch (Exception ex) {
            try {
                this.closeConnection();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            return false;
        }
    }

    private void expandGroups() {
        Vector<InternetAddress> groups = null;
        int i = 0;
        while (i < this.addresses.length) {
            InternetAddress a = (InternetAddress)this.addresses[i];
            if (a.isGroup()) {
                if (groups == null) {
                    groups = new Vector<InternetAddress>();
                    int k = 0;
                    while (k < i) {
                        groups.addElement((InternetAddress)this.addresses[k]);
                        ++k;
                    }
                }
                try {
                    InternetAddress[] ia = a.getGroup(true);
                    if (ia != null) {
                        int j = 0;
                        while (j < ia.length) {
                            groups.addElement(ia[j]);
                            ++j;
                        }
                    } else {
                        groups.addElement(a);
                    }
                }
                catch (ParseException pex) {
                    groups.addElement(a);
                }
            } else if (groups != null) {
                groups.addElement(a);
            }
            ++i;
        }
        if (groups != null) {
            Object[] newa = new InternetAddress[groups.size()];
            groups.copyInto(newa);
            this.addresses = newa;
        }
    }

    private void convertTo8Bit(MimePart part) {
        try {
            if (part.isMimeType("text/*")) {
                InputStream is;
                String enc = part.getEncoding();
                if ((enc.equalsIgnoreCase("quoted-printable") || enc.equalsIgnoreCase("base64")) && this.is8Bit(is = part.getInputStream())) {
                    part.setHeader("Content-Transfer-Encoding", "8bit");
                }
            } else if (part.isMimeType("multipart/*")) {
                MimeMultipart mp = (MimeMultipart)part.getContent();
                int count = mp.getCount();
                int i = 0;
                while (i < count) {
                    this.convertTo8Bit((MimePart)((Object)mp.getBodyPart(i)));
                    ++i;
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    private boolean is8Bit(InputStream is) {
        int linelen = 0;
        boolean need8bit = false;
        try {
            int b;
            while ((b = is.read()) >= 0) {
                if ((b &= 0xFF) == 13 || b == 10) {
                    linelen = 0;
                } else {
                    if (b == 0) {
                        return false;
                    }
                    if (++linelen > 998) {
                        return false;
                    }
                }
                if (b <= 127) continue;
                need8bit = true;
            }
        }
        catch (IOException ex) {
            return false;
        }
        if (this.debug && need8bit) {
            this.out.println("DEBUG SMTP: found an 8bit part");
        }
        return need8bit;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.closeConnection();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    private void helo(String domain) throws MessagingException {
        if (domain != null) {
            this.issueCommand("HELO " + domain, 250);
        } else {
            this.issueCommand("HELO", 250);
        }
    }

    private boolean ehlo(String domain) throws MessagingException {
        String cmd = domain != null ? "EHLO " + domain : "EHLO";
        this.sendCommand(cmd);
        int resp = this.readServerResponse();
        if (resp == 250) {
            BufferedReader rd = new BufferedReader(new StringReader(this.lastServerResponse));
            this.extMap = new Hashtable();
            try {
                String line;
                boolean first = true;
                while ((line = rd.readLine()) != null) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    if (line.length() < 5) continue;
                    line = line.substring(4);
                    int i = line.indexOf(32);
                    String arg = "";
                    if (i > 0) {
                        arg = line.substring(i + 1);
                        line = line.substring(0, i);
                    }
                    if (this.debug) {
                        this.out.println("DEBUG SMTP: Found extension \"" + line + "\", arg \"" + arg + "\"");
                    }
                    this.extMap.put(line.toUpperCase(), arg);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return resp == 250;
    }

    private void mailFrom() throws MessagingException {
        String cmd;
        block18: {
            String ret;
            String from = null;
            if (this.message instanceof SMTPMessage) {
                from = ((SMTPMessage)this.message).getEnvelopeFrom();
            }
            if (from == null || from.length() <= 0) {
                from = this.session.getProperty("mail." + this.name + ".from");
            }
            if (from == null || from.length() <= 0) {
                Address[] fa;
                Address me = this.message != null && (fa = this.message.getFrom()) != null && fa.length > 0 ? fa[0] : InternetAddress.getLocalAddress(this.session);
                if (me != null) {
                    from = me.getAddress();
                } else {
                    throw new MessagingException("can't determine local email address");
                }
            }
            cmd = "MAIL FROM:" + this.normalizeAddress(from);
            if (this.supportsExtension("DSN")) {
                ret = null;
                if (this.message instanceof SMTPMessage) {
                    ret = ((SMTPMessage)this.message).getDSNRet();
                }
                if (ret == null) {
                    ret = this.session.getProperty("mail." + this.name + ".dsn.ret");
                }
                if (ret != null) {
                    cmd = String.valueOf(cmd) + " RET=" + ret;
                }
            }
            if (this.supportsExtension("AUTH")) {
                ret = null;
                if (this.message instanceof SMTPMessage) {
                    ret = ((SMTPMessage)this.message).getSubmitter();
                }
                if (ret == null) {
                    ret = this.session.getProperty("mail." + this.name + ".submitter");
                }
                if (ret != null) {
                    try {
                        String s = this.xtext(ret);
                        cmd = String.valueOf(cmd) + " AUTH=" + s;
                    }
                    catch (IllegalArgumentException illegalargumentexception) {
                        if (!this.debug) break block18;
                        this.out.println("DEBUG SMTP: ignoring invalid submitter: " + ret + ", Exception: " + illegalargumentexception);
                    }
                }
            }
        }
        String ext = null;
        if (this.message instanceof SMTPMessage) {
            ext = ((SMTPMessage)this.message).getMailExtension();
        }
        if (ext == null) {
            ext = this.session.getProperty("mail." + this.name + ".mailextension");
        }
        if (ext != null && ext.length() > 0) {
            cmd = String.valueOf(cmd) + ' ' + ext;
        }
        this.issueSendCommand(cmd, 250);
    }

    private void rcptTo() throws MessagingException {
        Vector<Address> valid = new Vector<Address>();
        Vector<InternetAddress> validUnsent = new Vector<InternetAddress>();
        Vector<InternetAddress> invalid = new Vector<InternetAddress>();
        int retCode = -1;
        SMTPAddressFailedException mex = null;
        boolean sendFailed = false;
        MessagingException sfex = null;
        this.invalidAddr = null;
        this.validUnsentAddr = null;
        this.validSentAddr = null;
        boolean sendPartial = false;
        if (this.message instanceof SMTPMessage) {
            sendPartial = ((SMTPMessage)this.message).getSendPartial();
        }
        if (!sendPartial) {
            String sp = this.session.getProperty("mail." + this.name + ".sendpartial");
            sendPartial = sp != null && sp.equalsIgnoreCase("true");
        }
        boolean dsn = false;
        String notify = null;
        if (this.supportsExtension("DSN")) {
            if (this.message instanceof SMTPMessage) {
                notify = ((SMTPMessage)this.message).getDSNNotify();
            }
            if (notify == null) {
                notify = this.session.getProperty("mail." + this.name + ".dsn.notify");
            }
            if (notify != null) {
                dsn = true;
            }
        }
        int i = 0;
        while (i < this.addresses.length) {
            sfex = null;
            InternetAddress ia = (InternetAddress)this.addresses[i];
            String cmd = "RCPT TO:" + this.normalizeAddress(ia.getAddress());
            if (dsn) {
                cmd = String.valueOf(cmd) + " NOTIFY=" + notify;
            }
            this.sendCommand(cmd);
            retCode = this.readServerResponse();
            switch (retCode) {
                case 250: 
                case 251: {
                    valid.addElement(this.addresses[i]);
                    if (!this.reportSuccess) break;
                    sfex = new SMTPAddressSucceededException(ia, cmd, retCode, this.lastServerResponse);
                    if (mex == null) {
                        mex = sfex;
                        break;
                    }
                    mex.setNextException(sfex);
                    break;
                }
                case 501: 
                case 503: 
                case 550: 
                case 551: 
                case 553: {
                    if (!sendPartial) {
                        sendFailed = true;
                    }
                    invalid.addElement(ia);
                    sfex = new SMTPAddressFailedException(ia, cmd, retCode, this.lastServerResponse);
                    if (mex == null) {
                        mex = sfex;
                        break;
                    }
                    mex.setNextException(sfex);
                    break;
                }
                case 450: 
                case 451: 
                case 452: 
                case 552: {
                    if (!sendPartial) {
                        sendFailed = true;
                    }
                    validUnsent.addElement(ia);
                    sfex = new SMTPAddressFailedException(ia, cmd, retCode, this.lastServerResponse);
                    if (mex == null) {
                        mex = sfex;
                        break;
                    }
                    mex.setNextException(sfex);
                    break;
                }
                default: {
                    if (retCode >= 400 && retCode <= 499) {
                        validUnsent.addElement(ia);
                    } else if (retCode >= 500 && retCode <= 599) {
                        invalid.addElement(ia);
                    } else {
                        if (this.debug) {
                            this.out.println("DEBUG SMTP: got response code " + retCode + ", with response: " + this.lastServerResponse);
                        }
                        String _lsr = this.lastServerResponse;
                        int _lrc = this.lastReturnCode;
                        if (this.serverSocket != null) {
                            this.issueCommand("RSET", 250);
                        }
                        this.lastServerResponse = _lsr;
                        this.lastReturnCode = _lrc;
                        throw new SMTPAddressFailedException(ia, cmd, retCode, _lsr);
                    }
                    if (!sendPartial) {
                        sendFailed = true;
                    }
                    sfex = new SMTPAddressFailedException(ia, cmd, retCode, this.lastServerResponse);
                    if (mex == null) {
                        mex = sfex;
                        break;
                    }
                    mex.setNextException(sfex);
                }
            }
            ++i;
        }
        if (sendPartial && valid.size() == 0) {
            sendFailed = true;
        }
        if (sendFailed) {
            this.invalidAddr = new Address[invalid.size()];
            invalid.copyInto(this.invalidAddr);
            this.validUnsentAddr = new Address[valid.size() + validUnsent.size()];
            i = 0;
            int j = 0;
            while (j < valid.size()) {
                this.validUnsentAddr[i++] = (Address)valid.elementAt(j);
                ++j;
            }
            j = 0;
            while (j < validUnsent.size()) {
                this.validUnsentAddr[i++] = (Address)validUnsent.elementAt(j);
                ++j;
            }
        } else if (this.reportSuccess || sendPartial && (invalid.size() > 0 || validUnsent.size() > 0)) {
            this.sendPartiallyFailed = true;
            this.exception = mex;
            this.invalidAddr = new Address[invalid.size()];
            invalid.copyInto(this.invalidAddr);
            this.validUnsentAddr = new Address[validUnsent.size()];
            validUnsent.copyInto(this.validUnsentAddr);
            this.validSentAddr = new Address[valid.size()];
            valid.copyInto(this.validSentAddr);
        } else {
            this.validSentAddr = this.addresses;
        }
        if (this.debug) {
            if (this.validSentAddr != null && this.validSentAddr.length > 0) {
                this.out.println("DEBUG SMTP: Verified Addresses");
                int l = 0;
                while (l < this.validSentAddr.length) {
                    this.out.println("DEBUG SMTP:   " + this.validSentAddr[l]);
                    ++l;
                }
            }
            if (this.validUnsentAddr != null && this.validUnsentAddr.length > 0) {
                this.out.println("DEBUG SMTP: Valid Unsent Addresses");
                int j = 0;
                while (j < this.validUnsentAddr.length) {
                    this.out.println("DEBUG SMTP:   " + this.validUnsentAddr[j]);
                    ++j;
                }
            }
            if (this.invalidAddr != null && this.invalidAddr.length > 0) {
                this.out.println("DEBUG SMTP: Invalid Addresses");
                int k = 0;
                while (k < this.invalidAddr.length) {
                    this.out.println("DEBUG SMTP:   " + this.invalidAddr[k]);
                    ++k;
                }
            }
        }
        if (sendFailed) {
            if (this.debug) {
                this.out.println("DEBUG SMTP: Sending failed because of invalid destination addresses");
            }
            this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
            String lsr = this.lastServerResponse;
            int lrc = this.lastReturnCode;
            try {
                try {
                    if (this.serverSocket != null) {
                        this.issueCommand("RSET", 250);
                    }
                }
                catch (MessagingException ex) {
                    try {
                        this.close();
                    }
                    catch (MessagingException ex2) {
                        if (this.debug) {
                            ex2.printStackTrace(this.out);
                        }
                    }
                }
            }
            finally {
                this.lastServerResponse = lsr;
                this.lastReturnCode = lrc;
            }
            throw new SendFailedException("Invalid Addresses", mex, this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
        }
    }

    private OutputStream data() throws MessagingException {
        this.issueSendCommand("DATA", 354);
        return new SMTPOutputStream(this.serverOutput);
    }

    private void finishData() throws MessagingException {
        this.issueSendCommand("\r\n.", 250);
    }

    private void startTLS() throws MessagingException {
        this.issueCommand("STARTTLS", 220);
        try {
            this.serverSocket = SocketFetcher.startTLS(this.serverSocket);
            this.initStreams();
        }
        catch (IOException ioex) {
            this.closeConnection();
            throw new MessagingException("Could not convert socket to TLS", ioex);
        }
    }

    private void openServer(String server, int port) throws MessagingException {
        if (this.debug) {
            this.out.println("DEBUG SMTP: trying to connect to host \"" + server + "\", port " + port + ", isSSL " + this.isSSL);
        }
        try {
            Properties props = this.session.getProperties();
            this.serverSocket = SocketFetcher.getSocket(server, port, props, "mail." + this.name, this.isSSL);
            port = this.serverSocket.getPort();
            this.initStreams();
            int r = -1;
            r = this.readServerResponse();
            if (r != 220) {
                this.serverSocket.close();
                this.serverSocket = null;
                this.serverOutput = null;
                this.serverInput = null;
                this.lineInputStream = null;
                if (this.debug) {
                    this.out.println("DEBUG SMTP: could not connect to host \"" + server + "\", port: " + port + ", response: " + r + "\n");
                }
                throw new MessagingException("Could not connect to SMTP host: " + server + ", port: " + port + ", response: " + r);
            }
            if (this.debug) {
                this.out.println("DEBUG SMTP: connected to host \"" + server + "\", port: " + port + "\n");
            }
        }
        catch (UnknownHostException uhex) {
            throw new MessagingException("Unknown SMTP host: " + server, uhex);
        }
        catch (IOException ioe) {
            throw new MessagingException("Could not connect to SMTP host: " + server + ", port: " + port, ioe);
        }
    }

    private void openServer() throws MessagingException {
        int i = -1;
        String s = UNKNOWN;
        try {
            i = this.serverSocket.getPort();
            s = this.serverSocket.getInetAddress().getHostName();
            if (this.debug) {
                this.out.println("DEBUG SMTP: starting protocol to host \"" + s + "\", port " + i);
            }
            this.initStreams();
            int j = -1;
            j = this.readServerResponse();
            if (j != 220) {
                this.serverSocket.close();
                this.serverSocket = null;
                this.serverOutput = null;
                this.serverInput = null;
                this.lineInputStream = null;
                if (this.debug) {
                    this.out.println("DEBUG SMTP: got bad greeting from host \"" + s + "\", port: " + i + ", response: " + j + "\n");
                }
                throw new MessagingException("Got bad greeting from SMTP host: " + s + ", port: " + i + ", response: " + j);
            }
            if (this.debug) {
                this.out.println("DEBUG SMTP: protocol started to host \"" + s + "\", port: " + i + "\n");
                return;
            }
        }
        catch (IOException ioexception) {
            throw new MessagingException("Could not start protocol to SMTP host: " + s + ", port: " + i, ioexception);
        }
    }

    private void initStreams() throws IOException {
        Properties props = this.session.getProperties();
        PrintStream out = this.session.getDebugOut();
        boolean debug = this.session.getDebug();
        String s = props.getProperty("mail.debug.quote");
        boolean quote = s != null && s.equalsIgnoreCase("true");
        TraceInputStream traceInput = new TraceInputStream(this.serverSocket.getInputStream(), out);
        traceInput.setTrace(debug);
        traceInput.setQuote(quote);
        TraceOutputStream traceOutput = new TraceOutputStream(this.serverSocket.getOutputStream(), out);
        traceOutput.setTrace(debug);
        traceOutput.setQuote(quote);
        this.serverOutput = new BufferedOutputStream(traceOutput);
        this.serverInput = new BufferedInputStream(traceInput);
        this.lineInputStream = new LineInputStream(this.serverInput);
    }

    private void issueCommand(String cmd, int expect) throws MessagingException {
        this.sendCommand(cmd);
        if (this.readServerResponse() != expect) {
            throw new MessagingException(this.lastServerResponse);
        }
    }

    private void issueSendCommand(String cmd, int expect) throws MessagingException {
        this.sendCommand(cmd);
        int ret = this.readServerResponse();
        if (ret != expect) {
            int vsl = this.validSentAddr == null ? 0 : this.validSentAddr.length;
            int vul = this.validUnsentAddr == null ? 0 : this.validUnsentAddr.length;
            Address[] valid = new Address[vsl + vul];
            if (vsl > 0) {
                System.arraycopy(this.validSentAddr, 0, valid, 0, vsl);
            }
            if (vul > 0) {
                System.arraycopy(this.validUnsentAddr, 0, valid, vsl, vul);
            }
            this.validSentAddr = null;
            this.validUnsentAddr = valid;
            throw new SMTPSendFailedException(cmd, ret, this.lastServerResponse, this.exception, this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
        }
    }

    private int simpleCommand(String cmd) throws MessagingException {
        this.sendCommand(cmd);
        return this.readServerResponse();
    }

    private int simpleCommand(byte[] cmd) throws MessagingException {
        this.sendCommand(cmd);
        return this.readServerResponse();
    }

    private void sendCommand(String cmd) throws MessagingException {
        this.sendCommand(ASCIIUtility.getBytes(cmd));
    }

    private void sendCommand(byte[] cmdBytes) throws MessagingException {
        try {
            this.serverOutput.write(cmdBytes);
            this.serverOutput.write(CRLF);
            this.serverOutput.flush();
        }
        catch (IOException ex) {
            throw new MessagingException("Can't send command to SMTP host", ex);
        }
    }

    private int readServerResponse() throws MessagingException {
        String serverResponse = "";
        int returnCode = 0;
        StringBuffer buf = new StringBuffer(100);
        try {
            String line = null;
            do {
                if ((line = this.lineInputStream.readLine()) == null) {
                    serverResponse = buf.toString();
                    if (serverResponse.length() == 0) {
                        serverResponse = "[EOF]";
                    }
                    this.lastServerResponse = serverResponse;
                    this.lastReturnCode = -1;
                    if (this.debug) {
                        this.out.println("DEBUG SMTP: EOF: " + serverResponse);
                    }
                    return -1;
                }
                buf.append(line);
                buf.append("\n");
            } while (this.isNotLastLine(line));
            serverResponse = buf.toString();
        }
        catch (IOException ioex) {
            if (this.debug) {
                this.out.println("DEBUG SMTP: exception reading response: " + ioex);
            }
            this.lastServerResponse = "";
            this.lastReturnCode = 0;
            throw new MessagingException("Exception reading response", ioex);
        }
        if (serverResponse != null && serverResponse.length() >= 3) {
            try {
                returnCode = Integer.parseInt(serverResponse.substring(0, 3));
            }
            catch (NumberFormatException nfe) {
                block17: {
                    try {
                        this.close();
                    }
                    catch (MessagingException mex) {
                        if (!this.debug) break block17;
                        mex.printStackTrace(this.out);
                    }
                }
                returnCode = -1;
            }
            catch (StringIndexOutOfBoundsException ex) {
                block18: {
                    try {
                        this.close();
                    }
                    catch (MessagingException mex) {
                        if (!this.debug) break block18;
                        mex.printStackTrace(this.out);
                    }
                }
                returnCode = -1;
            }
        } else {
            returnCode = -1;
        }
        if (returnCode == -1 && this.debug) {
            this.out.println("DEBUG SMTP: bad server response: " + serverResponse);
        }
        this.lastServerResponse = serverResponse;
        this.lastReturnCode = returnCode;
        return returnCode;
    }

    private void checkConnected() {
        if (!super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    private boolean isNotLastLine(String line) {
        return line != null && line.length() >= 4 && line.charAt(3) == '-';
    }

    private String normalizeAddress(String addr) {
        if (!addr.startsWith("<") && !addr.endsWith(">")) {
            return String.valueOf('<') + addr + '>';
        }
        return addr;
    }

    public boolean supportsExtension(String ext) {
        return this.extMap != null && this.extMap.get(ext.toUpperCase()) != null;
    }

    public final String getExtensionParameter(String ext) {
        if (this.extMap == null) {
            return null;
        }
        return (String)this.extMap.get(ext.toUpperCase());
    }

    private boolean supportsAuthentication(String auth) {
        if (this.extMap == null) {
            return false;
        }
        String a = (String)this.extMap.get("AUTH");
        if (a == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(a);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (!tok.equalsIgnoreCase(auth)) continue;
            return true;
        }
        return false;
    }

    private String xtext(String s) {
        StringBuffer sb = null;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c >= '\u0080') {
                throw new IllegalArgumentException("Non-ASCII character in SMTP submitter: " + s);
            }
            if (c < '!' || c > '~' || c == '+' || c == '=') {
                if (sb == null) {
                    sb = new StringBuffer(s.length() + 4);
                    sb.append(s.substring(0, i));
                }
                sb.append('+');
                sb.append(hexchar[(c & 0xF0) >> 4]);
                sb.append(hexchar[c & 0xF]);
            } else if (sb != null) {
                sb.append(c);
            }
            ++i;
        }
        return sb != null ? sb.toString() : s;
    }
}

