/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.Argument;
import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.Literal;
import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Protocol;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.ACL;
import com.sun.mail.imap.Quota;
import com.sun.mail.imap.Rights;
import com.sun.mail.imap.protocol.BASE64MailboxEncoder;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.BODYSTRUCTURE;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.INTERNALDATE;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.MailboxInfo;
import com.sun.mail.imap.protocol.MessageSet;
import com.sun.mail.imap.protocol.Namespaces;
import com.sun.mail.imap.protocol.RFC822DATA;
import com.sun.mail.imap.protocol.SaslAuthenticator;
import com.sun.mail.imap.protocol.SearchSequence;
import com.sun.mail.imap.protocol.Status;
import com.sun.mail.imap.protocol.UID;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Flags;
import javax.mail.internet.MimeUtility;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;

public final class IMAPProtocol
extends Protocol {
    private boolean rev1 = false;
    private boolean authenticated;
    private Hashtable capabilities = null;
    private Vector authmechs;
    private String[] searchCharsets;
    private String name;
    private Properties props;
    private SaslAuthenticator saslAuthenticator;
    private String charset = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public IMAPProtocol(String name, String host, int port, boolean debug, PrintStream out, Properties props, boolean isSSL) throws IOException, ProtocolException {
        super(host, port, debug, out, props, "mail." + name, isSSL);
        this.name = name;
        this.props = props;
        if (this.capabilities == null) {
            this.capability();
        }
        if (this.hasCapability("IMAP4rev1")) {
            this.rev1 = true;
        }
        this.searchCharsets = new String[2];
        this.searchCharsets[0] = "UTF-8";
        this.searchCharsets[1] = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
    }

    public void capability() throws ProtocolException {
        Response[] r = this.command("CAPABILITY", null);
        if (!r[r.length - 1].isOK()) {
            throw new ProtocolException(r[r.length - 1].toString());
        }
        this.capabilities = new Hashtable(10);
        this.authmechs = new Vector(5);
        int i = 0;
        int len = r.length;
        while (i < len) {
            IMAPResponse ir;
            if (r[i] instanceof IMAPResponse && (ir = (IMAPResponse)r[i]).keyEquals("CAPABILITY")) {
                this.parseCapabilities(ir);
            }
            ++i;
        }
    }

    protected void setCapabilities(Response r) {
        byte b;
        while ((b = r.readByte()) > 0 && b != 91) {
        }
        if (b == 0) {
            return;
        }
        String s = r.readAtom();
        if (!s.equalsIgnoreCase("CAPABILITY")) {
            return;
        }
        this.capabilities = new Hashtable(10);
        this.authmechs = new Vector(5);
        this.parseCapabilities(r);
    }

    protected void parseCapabilities(Response r) {
        String s;
        while ((s = r.readAtom(']')) != null) {
            if (s.length() == 0) {
                if (r.peekByte() == 93) break;
                r.skipToken();
                continue;
            }
            this.capabilities.put(s.toUpperCase(), s);
            if (!s.regionMatches(true, 0, "AUTH=", 0, 5)) continue;
            this.authmechs.addElement(s.substring(5));
            if (!this.debug) continue;
            this.out.println("IMAP DEBUG: AUTH: " + s.substring(5));
        }
    }

    protected void processGreeting(Response r) throws ProtocolException {
        super.processGreeting(r);
        if (r.isOK()) {
            this.setCapabilities(r);
            return;
        }
        IMAPResponse ir = (IMAPResponse)r;
        if (!ir.keyEquals("PREAUTH")) {
            throw new ConnectionException(this, r);
        }
        this.authenticated = true;
        this.setCapabilities(r);
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isREV1() {
        return this.rev1;
    }

    protected boolean supportsNonSyncLiterals() {
        return this.hasCapability("LITERAL+");
    }

    public Response readResponse() throws IOException, ProtocolException {
        return IMAPResponse.readResponse(this);
    }

    public boolean hasCapability(String c) {
        return this.capabilities.containsKey(c.toUpperCase());
    }

    public void disconnect() {
        super.disconnect();
        this.authenticated = false;
    }

    public void noop() throws ProtocolException {
        this.simpleCommand("NOOP", null);
    }

    public void logout() throws ProtocolException {
        Response[] r = this.command("LOGOUT", null);
        this.authenticated = false;
        this.notifyResponseHandlers(r);
        this.disconnect();
    }

    public void login(String u, String p) throws ProtocolException {
        Argument args = new Argument();
        args.writeASCII(u);
        args.writeASCII(p);
        this.simpleCommand("LOGIN", args);
        this.authenticated = true;
    }

    public void authlogin(String u, String p) throws ProtocolException {
        Vector<Response> v = new Vector<Response>();
        String tag = null;
        Response r = null;
        boolean done = false;
        try {
            tag = this.writeCommand("AUTHENTICATE LOGIN", null);
        }
        catch (Exception ex) {
            r = Response.byeResponse(ex);
            done = true;
        }
        OutputStream os = this.getOutputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BASE64EncoderStream b64os = new BASE64EncoderStream(bos, Integer.MAX_VALUE);
        byte[] CRLF = new byte[]{13, 10};
        boolean first = true;
        while (!done) {
            try {
                r = this.readResponse();
                if (r.isContinuation()) {
                    String s;
                    if (first) {
                        s = u;
                        first = false;
                    } else {
                        s = p;
                    }
                    ((OutputStream)b64os).write(ASCIIUtility.getBytes(s));
                    ((OutputStream)b64os).flush();
                    bos.write(CRLF);
                    os.write(bos.toByteArray());
                    os.flush();
                    bos.reset();
                    continue;
                }
                if (r.isTagged() && r.getTag().equals(tag)) {
                    done = true;
                    continue;
                }
                if (r.isBYE()) {
                    done = true;
                    continue;
                }
                v.addElement(r);
            }
            catch (Exception ioex) {
                r = Response.byeResponse(ioex);
                done = true;
            }
        }
        Object[] responses = new Response[v.size()];
        v.copyInto(responses);
        this.notifyResponseHandlers((Response[])responses);
        this.handleResult(r);
        if (r.isOK()) {
            this.setCapabilities(r);
        }
        this.authenticated = true;
    }

    public void authplain(String authzid, String u, String p) throws ProtocolException {
        Vector<Response> v = new Vector<Response>();
        String tag = null;
        Response r = null;
        boolean done = false;
        try {
            tag = this.writeCommand("AUTHENTICATE PLAIN", null);
        }
        catch (Exception ex) {
            r = Response.byeResponse(ex);
            done = true;
        }
        OutputStream os = this.getOutputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BASE64EncoderStream b64os = new BASE64EncoderStream(bos, Integer.MAX_VALUE);
        while (!done) {
            try {
                r = this.readResponse();
                if (r.isContinuation()) {
                    String nullByte = "\u0000";
                    String s = String.valueOf(authzid) + "\u0000" + u + "\u0000" + p;
                    b64os.write(ASCIIUtility.getBytes(s));
                    b64os.flush();
                    bos.write(CRLF);
                    os.write(bos.toByteArray());
                    os.flush();
                    bos.reset();
                    continue;
                }
                if (r.isTagged() && r.getTag().equals(tag)) {
                    done = true;
                    continue;
                }
                if (r.isBYE()) {
                    done = true;
                    continue;
                }
                v.addElement(r);
            }
            catch (Exception ioex) {
                r = Response.byeResponse(ioex);
                done = true;
            }
        }
        Object[] aresponse = new Response[v.size()];
        v.copyInto(aresponse);
        this.notifyResponseHandlers((Response[])aresponse);
        this.handleResult(r);
        if (r.isOK()) {
            this.setCapabilities(r);
        }
        this.authenticated = true;
    }

    public void sasllogin(String[] allowed, String realm, String authzid, String u, String p) throws ProtocolException {
        Vector<String> v;
        if (this.saslAuthenticator == null) {
            try {
                Class<?> sac = Class.forName("com.sun.mail.imap.protocol.IMAPSaslAuthenticator");
                Class[] classArray = new Class[6];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sun.mail.imap.protocol.IMAPProtocol");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.util.Properties");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz3;
                classArray[3] = Boolean.TYPE;
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$3 = Class.forName("java.io.PrintStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[4] = clazz4;
                Class<?> clazz5 = class$1;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[5] = clazz5;
                Constructor<?> c = sac.getConstructor(classArray);
                this.saslAuthenticator = (SaslAuthenticator)c.newInstance(this, this.name, this.props, this.debug ? Boolean.TRUE : Boolean.FALSE, this.out, this.host);
            }
            catch (Exception ex) {
                if (this.debug) {
                    this.out.println("IMAP DEBUG: Can't load SASL authenticator: " + ex);
                }
                return;
            }
        }
        if (allowed != null && allowed.length > 0) {
            v = new Vector<String>(allowed.length);
            int i = 0;
            while (i < allowed.length) {
                if (this.authmechs.contains(allowed[i])) {
                    v.addElement(allowed[i]);
                }
                ++i;
            }
        } else {
            v = this.authmechs;
        }
        Object[] mechs = new String[v.size()];
        v.copyInto(mechs);
        if (this.saslAuthenticator.authenticate((String[])mechs, realm, authzid, u, p)) {
            this.authenticated = true;
        }
    }

    OutputStream getIMAPOutputStream() {
        return this.getOutputStream();
    }

    public void proxyauth(String u) throws ProtocolException {
        Argument args = new Argument();
        args.writeASCII(u);
        this.simpleCommand("PROXYAUTH", args);
    }

    public void startTLS() throws ProtocolException {
        try {
            this.startTLS("STARTTLS");
        }
        catch (ProtocolException pex) {
            throw pex;
        }
        catch (Exception ex) {
            Response[] r = new Response[]{Response.byeResponse(ex)};
            this.notifyResponseHandlers(r);
            this.disconnect();
        }
    }

    public MailboxInfo select(String mbox) throws ProtocolException {
        if (this.charset == null) {
            mbox = BASE64MailboxEncoder.encode(mbox);
        }
        if (mbox.indexOf(32) > -1) {
            mbox = String.valueOf('\"') + mbox + '\"';
        }
        Argument args = new Argument();
        if (this.charset == null) {
            args.writeASCII(mbox);
        } else {
            try {
                args.writeRawString(mbox, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                args.writeASCII(mbox);
            }
        }
        Response[] r = this.command("SELECT", args);
        MailboxInfo minfo = new MailboxInfo(r);
        this.notifyResponseHandlers(r);
        Response response = r[r.length - 1];
        if (response.isOK()) {
            minfo.mode = response.toString().indexOf("READ-ONLY") != -1 ? 1 : 2;
        }
        this.handleResult(response);
        return minfo;
    }

    public MailboxInfo examine(String mbox) throws ProtocolException {
        if (this.charset == null) {
            mbox = BASE64MailboxEncoder.encode(mbox);
        }
        if (mbox.indexOf(32) > -1) {
            mbox = String.valueOf('\"') + mbox + '\"';
        }
        Argument args = new Argument();
        if (this.charset == null) {
            args.writeASCII(mbox);
        } else {
            try {
                args.writeRawString(mbox, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                args.writeASCII(mbox);
            }
        }
        Response[] r = this.command("EXAMINE", args);
        MailboxInfo minfo = new MailboxInfo(r);
        minfo.mode = 1;
        this.notifyResponseHandlers(r);
        this.handleResult(r[r.length - 1]);
        return minfo;
    }

    public Status status(String mbox, String[] items) throws ProtocolException {
        if (!this.isREV1() && !this.hasCapability("IMAP4SUNVERSION")) {
            throw new BadCommandException("STATUS not supported");
        }
        if (this.charset == null) {
            mbox = BASE64MailboxEncoder.encode(mbox);
        }
        if (mbox.indexOf(32) > -1) {
            mbox = String.valueOf('\"') + mbox + '\"';
        }
        Argument args = new Argument();
        if (this.charset == null) {
            args.writeASCII(mbox);
        } else {
            try {
                args.writeRawString(mbox, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                args.writeASCII(mbox);
            }
        }
        Argument itemArgs = new Argument();
        if (items == null) {
            items = Status.standardItems;
        }
        int i = 0;
        int len = items.length;
        while (i < len) {
            itemArgs.writeAtom(items[i]);
            ++i;
        }
        args.writeArgument(itemArgs);
        Response[] r = this.command("STATUS", args);
        Status status = null;
        Response response = r[r.length - 1];
        if (response.isOK()) {
            int i2 = 0;
            int len2 = r.length;
            while (i2 < len2) {
                IMAPResponse ir;
                if (r[i2] instanceof IMAPResponse && (ir = (IMAPResponse)r[i2]).keyEquals("STATUS")) {
                    if (status == null) {
                        status = new Status(ir, this.charset);
                    } else {
                        Status.add(status, new Status(ir, this.charset));
                    }
                    r[i2] = null;
                }
                ++i2;
            }
        }
        this.notifyResponseHandlers(r);
        this.handleResult(response);
        return status;
    }

    public void create(String mbox) throws ProtocolException {
        if (this.charset == null) {
            mbox = BASE64MailboxEncoder.encode(mbox);
        }
        if (mbox.indexOf(32) > -1) {
            mbox = String.valueOf('\"') + mbox + '\"';
        }
        Argument args = new Argument();
        if (this.charset == null) {
            args.writeASCII(mbox);
        } else {
            try {
                args.writeRawString(mbox, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                args.writeASCII(mbox);
            }
        }
        this.simpleCommand("CREATE", args);
    }

    public void delete(String mbox) throws ProtocolException {
        if (this.charset == null) {
            mbox = BASE64MailboxEncoder.encode(mbox);
        }
        if (mbox.indexOf(32) > -1) {
            mbox = String.valueOf('\"') + mbox + '\"';
        }
        Argument args = new Argument();
        if (this.charset == null) {
            args.writeASCII(mbox);
        } else {
            try {
                args.writeRawString(mbox, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                args.writeASCII(mbox);
            }
        }
        this.simpleCommand("DELETE", args);
    }

    public void rename(String o, String n) throws ProtocolException {
        if (this.charset == null) {
            o = BASE64MailboxEncoder.encode(o);
            n = BASE64MailboxEncoder.encode(n);
        }
        if (o.indexOf(32) > -1) {
            o = String.valueOf('\"') + o + '\"';
        }
        if (n.indexOf(32) > -1) {
            n = String.valueOf('\"') + n + '\"';
        }
        Argument args = new Argument();
        if (this.charset == null) {
            args.writeASCII(o);
            args.writeASCII(n);
        } else {
            try {
                args.writeRawString(o, this.charset);
                args.writeRawString(n, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                args.writeASCII(o);
                args.writeASCII(n);
            }
        }
        this.simpleCommand("RENAME", args);
    }

    public void subscribe(String mbox) throws ProtocolException {
        Argument args = new Argument();
        if (this.charset == null) {
            mbox = BASE64MailboxEncoder.encode(mbox);
        }
        if (mbox.indexOf(32) > -1) {
            mbox = String.valueOf('\"') + mbox + '\"';
        }
        if (this.charset == null) {
            args.writeASCII(mbox);
        } else {
            try {
                args.writeRawString(mbox, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                args.writeASCII(mbox);
            }
        }
        this.simpleCommand("SUBSCRIBE", args);
    }

    public void unsubscribe(String mbox) throws ProtocolException {
        Argument args = new Argument();
        if (this.charset == null) {
            mbox = BASE64MailboxEncoder.encode(mbox);
        }
        if (mbox.indexOf(32) > -1) {
            mbox = String.valueOf('\"') + mbox + '\"';
        }
        if (this.charset == null) {
            args.writeASCII(mbox);
        } else {
            try {
                args.writeRawString(mbox, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                args.writeASCII(mbox);
            }
        }
        this.simpleCommand("UNSUBSCRIBE", args);
    }

    public ListInfo[] list(String ref, String pattern) throws ProtocolException {
        return this.doList("LIST", ref, pattern);
    }

    public ListInfo[] list(String ref, String pattern, String charset) throws ProtocolException {
        this.charset = charset;
        return this.list(ref, pattern);
    }

    public ListInfo[] lsub(String ref, String pattern) throws ProtocolException {
        return this.doList("LSUB", ref, pattern);
    }

    public ListInfo[] lsub(String ref, String pattern, String charset) throws ProtocolException {
        this.charset = charset;
        return this.lsub(ref, pattern);
    }

    private ListInfo[] doList(String cmd, String ref, String pat) throws ProtocolException {
        ref = BASE64MailboxEncoder.encode(ref);
        if (this.charset == null) {
            pat = BASE64MailboxEncoder.encode(pat);
        }
        if (pat.indexOf(32) > -1) {
            pat = String.valueOf('\"') + pat + '\"';
        }
        Argument args = new Argument();
        args.writeASCII(ref);
        if (this.charset == null) {
            args.writeASCII(pat);
        } else {
            try {
                args.writeRawString(pat, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                args.writeASCII(pat);
            }
        }
        Response[] r = this.command(cmd, args);
        Object[] linfo = null;
        Response response = r[r.length - 1];
        if (response.isOK()) {
            Vector<ListInfo> v = new Vector<ListInfo>(1);
            int i = 0;
            int len = r.length;
            while (i < len) {
                IMAPResponse ir;
                if (r[i] instanceof IMAPResponse && (ir = (IMAPResponse)r[i]).keyEquals(cmd)) {
                    if (this.charset == null) {
                        v.addElement(new ListInfo(ir));
                    } else {
                        v.addElement(new ListInfo(ir, this.charset));
                    }
                    r[i] = null;
                }
                ++i;
            }
            if (v.size() > 0) {
                linfo = new ListInfo[v.size()];
                v.copyInto(linfo);
            }
        }
        this.notifyResponseHandlers(r);
        this.handleResult(response);
        return linfo;
    }

    public void append(String mbox, Flags f, Date d, Literal data) throws ProtocolException {
        if (this.charset == null) {
            mbox = BASE64MailboxEncoder.encode(mbox);
        }
        if (mbox.indexOf(32) > -1) {
            mbox = String.valueOf('\"') + mbox + '\"';
        }
        Argument args = new Argument();
        if (this.charset == null) {
            args.writeASCII(mbox);
        } else {
            try {
                args.writeRawString(mbox, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                args.writeASCII(mbox);
            }
        }
        if (f != null) {
            f.remove(Flags.Flag.RECENT);
        }
        args.writeAtom(this.createFlagList(f));
        if (d != null) {
            args.writeASCII(INTERNALDATE.format(d));
        }
        args.writeBytes(data);
        this.simpleCommand("APPEND", args);
    }

    public void check() throws ProtocolException {
        this.simpleCommand("CHECK", null);
    }

    public void close() throws ProtocolException {
        this.simpleCommand("CLOSE", null);
    }

    public void expunge() throws ProtocolException {
        this.simpleCommand("EXPUNGE", null);
    }

    public BODYSTRUCTURE fetchBodyStructure(int msgno) throws ProtocolException {
        Response[] r = this.fetch(msgno, "BODYSTRUCTURE");
        this.notifyResponseHandlers(r);
        Response response = r[r.length - 1];
        if (response.isOK()) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("com.sun.mail.imap.protocol.BODYSTRUCTURE");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (BODYSTRUCTURE)FetchResponse.getItem(r, msgno, clazz);
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public BODY peekBody(int msgno, String section) throws ProtocolException {
        return this.fetchBody(msgno, section, true);
    }

    public BODY fetchBody(int msgno, String section) throws ProtocolException {
        return this.fetchBody(msgno, section, false);
    }

    private BODY fetchBody(int msgno, String section, boolean peek) throws ProtocolException {
        Response[] r = peek ? this.fetch(msgno, "BODY.PEEK[" + (section == null ? "]" : String.valueOf(section) + "]")) : this.fetch(msgno, "BODY[" + (section == null ? "]" : String.valueOf(section) + "]"));
        this.notifyResponseHandlers(r);
        Response response = r[r.length - 1];
        if (response.isOK()) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("com.sun.mail.imap.protocol.BODY");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (BODY)FetchResponse.getItem(r, msgno, clazz);
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public BODY peekBody(int msgno, String section, int start, int size) throws ProtocolException {
        return this.fetchBody(msgno, section, start, size, true);
    }

    public BODY fetchBody(int msgno, String section, int start, int size) throws ProtocolException {
        return this.fetchBody(msgno, section, start, size, false);
    }

    private BODY fetchBody(int msgno, String section, int start, int size, boolean peek) throws ProtocolException {
        Response[] r = this.fetch(msgno, String.valueOf(peek ? "BODY.PEEK[" : "BODY[") + (section == null ? "]<" : String.valueOf(section) + "]<") + String.valueOf(start) + '.' + String.valueOf(size) + '>');
        this.notifyResponseHandlers(r);
        Response response = r[r.length - 1];
        if (response.isOK()) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("com.sun.mail.imap.protocol.BODY");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (BODY)FetchResponse.getItem(r, msgno, clazz);
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public RFC822DATA fetchRFC822(int msgno, String what) throws ProtocolException {
        Response[] r = this.fetch(msgno, what == null ? "RFC822" : "RFC822." + what);
        this.notifyResponseHandlers(r);
        Response response = r[r.length - 1];
        if (response.isOK()) {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("com.sun.mail.imap.protocol.RFC822DATA");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (RFC822DATA)FetchResponse.getItem(r, msgno, clazz);
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public Flags fetchFlags(int msgno) throws ProtocolException {
        Flags flags = null;
        Response[] r = this.fetch(msgno, "FLAGS");
        int i = 0;
        int len = r.length;
        while (i < len) {
            if (r[i] != null && r[i] instanceof FetchResponse && ((FetchResponse)r[i]).getNumber() == msgno) {
                FetchResponse fr = (FetchResponse)r[i];
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("javax.mail.Flags");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((flags = (Flags)((Object)fr.getItem(clazz))) != null) {
                    r[i] = null;
                    break;
                }
            }
            ++i;
        }
        this.notifyResponseHandlers(r);
        this.handleResult(r[r.length - 1]);
        return flags;
    }

    public UID fetchUID(int msgno) throws ProtocolException {
        Response[] r = this.fetch(msgno, "UID");
        this.notifyResponseHandlers(r);
        Response response = r[r.length - 1];
        if (response.isOK()) {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("com.sun.mail.imap.protocol.UID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (UID)FetchResponse.getItem(r, msgno, clazz);
        }
        if (response.isNO()) {
            return null;
        }
        this.handleResult(response);
        return null;
    }

    public UID fetchSequenceNumber(long uid) throws ProtocolException {
        UID u = null;
        Response[] r = this.fetch(String.valueOf(uid), "UID", true);
        int i = 0;
        int len = r.length;
        while (i < len) {
            if (r[i] != null && r[i] instanceof FetchResponse) {
                FetchResponse fr = (FetchResponse)r[i];
                Class<?> clazz = class$8;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("com.sun.mail.imap.protocol.UID");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((u = (UID)fr.getItem(clazz)) != null) {
                    if (u.uid == uid) break;
                    u = null;
                }
            }
            ++i;
        }
        this.notifyResponseHandlers(r);
        this.handleResult(r[r.length - 1]);
        return u;
    }

    public UID[] fetchSequenceNumbers(long start, long end) throws ProtocolException {
        Response[] r = this.fetch(String.valueOf(String.valueOf(start)) + ':' + (end == -1L ? "*" : String.valueOf(end)), "UID", true);
        Vector<UID> v = new Vector<UID>();
        int i = 0;
        int len = r.length;
        while (i < len) {
            if (r[i] != null && r[i] instanceof FetchResponse) {
                UID u;
                FetchResponse fr = (FetchResponse)r[i];
                Class<?> clazz = class$8;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("com.sun.mail.imap.protocol.UID");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((u = (UID)fr.getItem(clazz)) != null) {
                    v.addElement(u);
                }
            }
            ++i;
        }
        this.notifyResponseHandlers(r);
        this.handleResult(r[r.length - 1]);
        Object[] ua = new UID[v.size()];
        v.copyInto(ua);
        return ua;
    }

    public UID[] fetchSequenceNumbers(long[] uids) throws ProtocolException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < uids.length) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(String.valueOf(uids[i]));
            ++i;
        }
        Response[] r = this.fetch(sb.toString(), "UID", true);
        Vector<UID> v = new Vector<UID>();
        int i2 = 0;
        int len = r.length;
        while (i2 < len) {
            if (r[i2] != null && r[i2] instanceof FetchResponse) {
                UID u;
                FetchResponse fr = (FetchResponse)r[i2];
                Class<?> clazz = class$8;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("com.sun.mail.imap.protocol.UID");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((u = (UID)fr.getItem(clazz)) != null) {
                    v.addElement(u);
                }
            }
            ++i2;
        }
        this.notifyResponseHandlers(r);
        this.handleResult(r[r.length - 1]);
        Object[] ua = new UID[v.size()];
        v.copyInto(ua);
        return ua;
    }

    public Response[] fetch(MessageSet[] msgsets, String what) throws ProtocolException {
        return this.fetch(MessageSet.toString(msgsets), what, false);
    }

    public Response[] fetch(int start, int end, String what) throws ProtocolException {
        return this.fetch(String.valueOf(String.valueOf(start)) + ':' + String.valueOf(end), what, false);
    }

    public Response[] fetch(int msg, String what) throws ProtocolException {
        return this.fetch(String.valueOf(msg), what, false);
    }

    private Response[] fetch(String msgSequence, String what, boolean uid) throws ProtocolException {
        if (uid) {
            return this.command("UID FETCH " + msgSequence + " (" + what + ')', null);
        }
        return this.command("FETCH " + msgSequence + " (" + what + ')', null);
    }

    public void copy(MessageSet[] msgsets, String mbox) throws ProtocolException {
        this.copy(MessageSet.toString(msgsets), mbox);
    }

    public void copy(int start, int end, String mbox) throws ProtocolException {
        this.copy(String.valueOf(String.valueOf(start)) + ':' + String.valueOf(end), mbox);
    }

    private void copy(String msgSequence, String mbox) throws ProtocolException {
        if (this.charset == null) {
            mbox = BASE64MailboxEncoder.encode(mbox);
        }
        if (mbox.indexOf(32) > -1) {
            mbox = String.valueOf('\"') + mbox + '\"';
        }
        Argument args = new Argument();
        args.writeAtom(msgSequence);
        if (this.charset == null) {
            args.writeASCII(mbox);
        } else {
            try {
                args.writeRawString(mbox, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                args.writeASCII(mbox);
            }
        }
        this.simpleCommand("COPY", args);
    }

    public void storeFlags(MessageSet[] msgsets, Flags flags, boolean set) throws ProtocolException {
        this.storeFlags(MessageSet.toString(msgsets), flags, set);
    }

    public void storeFlags(int start, int end, Flags flags, boolean set) throws ProtocolException {
        this.storeFlags(String.valueOf(String.valueOf(start)) + ':' + String.valueOf(end), flags, set);
    }

    public void storeFlags(int msg, Flags flags, boolean set) throws ProtocolException {
        this.storeFlags(String.valueOf(msg), flags, set);
    }

    private void storeFlags(String msgset, Flags flags, boolean set) throws ProtocolException {
        Response[] r = set ? this.command("STORE " + msgset + " +FLAGS " + this.createFlagList(flags), null) : this.command("STORE " + msgset + " -FLAGS " + this.createFlagList(flags), null);
        this.notifyResponseHandlers(r);
        this.handleResult(r[r.length - 1]);
    }

    private String createFlagList(Flags flags) {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        Flags.Flag[] sf = flags.getSystemFlags();
        boolean first = true;
        int i = 0;
        while (i < sf.length) {
            block15: {
                String s;
                block10: {
                    Flags.Flag f;
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block9: {
                                        f = sf[i];
                                        if (f != Flags.Flag.ANSWERED) break block9;
                                        s = "\\Answered";
                                        break block10;
                                    }
                                    if (f != Flags.Flag.DELETED) break block11;
                                    s = "\\Deleted";
                                    break block10;
                                }
                                if (f != Flags.Flag.DRAFT) break block12;
                                s = "\\Draft";
                                break block10;
                            }
                            if (f != Flags.Flag.FLAGGED) break block13;
                            s = "\\Flagged";
                            break block10;
                        }
                        if (f != Flags.Flag.RECENT) break block14;
                        s = "\\Recent";
                        break block10;
                    }
                    if (f != Flags.Flag.SEEN) break block15;
                    s = "\\Seen";
                }
                if (first) {
                    first = false;
                } else {
                    sb.append(' ');
                }
                sb.append(s);
            }
            ++i;
        }
        String[] uf = flags.getUserFlags();
        int i2 = 0;
        while (i2 < uf.length) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(uf[i2]);
            ++i2;
        }
        sb.append(')');
        return sb.toString();
    }

    public int[] search(MessageSet[] msgsets, SearchTerm term) throws ProtocolException, SearchException {
        return this.search(MessageSet.toString(msgsets), term);
    }

    public int[] search(SearchTerm term) throws ProtocolException, SearchException {
        return this.search("ALL", term);
    }

    private int[] search(String msgSequence, SearchTerm term) throws ProtocolException, SearchException {
        if (SearchSequence.isAscii(term)) {
            try {
                return this.issueSearch(msgSequence, term, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int i = 0;
        while (i < this.searchCharsets.length) {
            if (this.searchCharsets[i] != null) {
                try {
                    return this.issueSearch(msgSequence, term, this.searchCharsets[i]);
                }
                catch (CommandFailedException cfx) {
                    this.searchCharsets[i] = null;
                }
                catch (IOException cfx) {
                }
                catch (ProtocolException pex) {
                    throw pex;
                }
                catch (SearchException sex) {
                    throw sex;
                }
            }
            ++i;
        }
        throw new SearchException("Search failed");
    }

    private int[] issueSearch(String msgSequence, SearchTerm term, String charset) throws ProtocolException, SearchException, IOException {
        Argument args = SearchSequence.generateSequence(term, charset == null ? null : MimeUtility.javaCharset(charset));
        args.writeAtom(msgSequence);
        Response[] r = charset == null ? this.command("SEARCH", args) : this.command("SEARCH CHARSET " + charset, args);
        Response response = r[r.length - 1];
        int[] matches = null;
        if (response.isOK()) {
            Vector<Integer> v = new Vector<Integer>();
            int i = 0;
            int len = r.length;
            while (i < len) {
                IMAPResponse ir;
                if (r[i] instanceof IMAPResponse && (ir = (IMAPResponse)r[i]).keyEquals("SEARCH")) {
                    int num;
                    while ((num = ir.readNumber()) != -1) {
                        v.addElement(new Integer(num));
                    }
                    r[i] = null;
                }
                ++i;
            }
            int vsize = v.size();
            matches = new int[vsize];
            int i2 = 0;
            while (i2 < vsize) {
                matches[i2] = (Integer)v.elementAt(i2);
                ++i2;
            }
        }
        this.notifyResponseHandlers(r);
        this.handleResult(response);
        return matches;
    }

    public Namespaces namespace() throws ProtocolException {
        if (!this.hasCapability("NAMESPACE")) {
            throw new BadCommandException("NAMESPACE not supported");
        }
        Response[] r = this.command("NAMESPACE", null);
        Namespaces namespace = null;
        Response response = r[r.length - 1];
        if (response.isOK()) {
            int i = 0;
            int len = r.length;
            while (i < len) {
                IMAPResponse ir;
                if (r[i] instanceof IMAPResponse && (ir = (IMAPResponse)r[i]).keyEquals("NAMESPACE")) {
                    if (namespace == null) {
                        namespace = new Namespaces(ir);
                    }
                    r[i] = null;
                }
                ++i;
            }
        }
        this.notifyResponseHandlers(r);
        this.handleResult(response);
        return namespace;
    }

    public Quota[] getQuotaRoot(String mbox) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("GETQUOTAROOT not supported");
        }
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeASCII(mbox);
        Response[] r = this.command("GETQUOTAROOT", args);
        Response response = r[r.length - 1];
        Hashtable<String, Quota> tab = new Hashtable<String, Quota>();
        if (response.isOK()) {
            int i = 0;
            int len = r.length;
            while (i < len) {
                if (r[i] instanceof IMAPResponse) {
                    IMAPResponse ir = (IMAPResponse)r[i];
                    if (ir.keyEquals("QUOTAROOT")) {
                        ir.readAtomString();
                        String root = null;
                        while ((root = ir.readAtomString()) != null) {
                            tab.put(root, new Quota(root));
                        }
                        r[i] = null;
                    } else if (ir.keyEquals("QUOTA")) {
                        Quota quota = this.parseQuota(ir);
                        Quota q = (Quota)tab.get(quota.quotaRoot);
                        if (q != null) {
                            Quota.Resource[] cfr_ignored_0 = q.resources;
                        }
                        tab.put(quota.quotaRoot, quota);
                        r[i] = null;
                    }
                }
                ++i;
            }
        }
        this.notifyResponseHandlers(r);
        this.handleResult(response);
        Quota[] qa = new Quota[tab.size()];
        Enumeration e = tab.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            qa[i] = (Quota)e.nextElement();
            ++i;
        }
        return qa;
    }

    public Quota[] getQuota(String root) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("QUOTA not supported");
        }
        Argument args = new Argument();
        args.writeASCII(root);
        Response[] r = this.command("GETQUOTA", args);
        Quota quota = null;
        Vector<Quota> v = new Vector<Quota>();
        Response response = r[r.length - 1];
        if (response.isOK()) {
            int i = 0;
            int len = r.length;
            while (i < len) {
                IMAPResponse ir;
                if (r[i] instanceof IMAPResponse && (ir = (IMAPResponse)r[i]).keyEquals("QUOTA")) {
                    quota = this.parseQuota(ir);
                    v.addElement(quota);
                    r[i] = null;
                }
                ++i;
            }
        }
        this.notifyResponseHandlers(r);
        this.handleResult(response);
        Object[] qa = new Quota[v.size()];
        v.copyInto(qa);
        return qa;
    }

    public void setQuota(Quota quota) throws ProtocolException {
        if (!this.hasCapability("QUOTA")) {
            throw new BadCommandException("QUOTA not supported");
        }
        Argument args = new Argument();
        args.writeASCII(quota.quotaRoot);
        Argument qargs = new Argument();
        if (quota.resources != null) {
            int i = 0;
            while (i < quota.resources.length) {
                qargs.writeAtom(quota.resources[i].name);
                qargs.writeNumber(quota.resources[i].limit);
                ++i;
            }
        }
        args.writeArgument(qargs);
        Response[] r = this.command("SETQUOTA", args);
        Response response = r[r.length - 1];
        this.notifyResponseHandlers(r);
        this.handleResult(response);
    }

    private Quota parseQuota(Response r) throws ParsingException {
        String quotaRoot = r.readAtomString();
        Quota q = new Quota(quotaRoot);
        r.skipSpaces();
        if (r.readByte() != 40) {
            throw new ParsingException("parse error in QUOTA");
        }
        Vector<Quota.Resource> v = new Vector<Quota.Resource>();
        while (r.peekByte() != 41) {
            String name = r.readAtom();
            if (name == null) continue;
            long usage = r.readLong();
            long limit = r.readLong();
            Quota.Resource res = new Quota.Resource(name, usage, limit);
            v.addElement(res);
        }
        r.readByte();
        q.resources = new Quota.Resource[v.size()];
        v.copyInto(q.resources);
        return q;
    }

    public void setACL(String mbox, char modifier, ACL acl) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeASCII(mbox);
        args.writeASCII(acl.getName());
        String rights = acl.getRights().toString();
        if (modifier == '+' || modifier == '-') {
            rights = String.valueOf(modifier) + rights;
        }
        args.writeASCII(rights);
        Response[] r = this.command("SETACL", args);
        Response response = r[r.length - 1];
        this.notifyResponseHandlers(r);
        this.handleResult(response);
    }

    public void deleteACL(String mbox, String user) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeASCII(mbox);
        args.writeASCII(user);
        Response[] r = this.command("DELETEACL", args);
        Response response = r[r.length - 1];
        this.notifyResponseHandlers(r);
        this.handleResult(response);
    }

    public ACL[] getACL(String mbox) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeASCII(mbox);
        Response[] r = this.command("GETACL", args);
        Response response = r[r.length - 1];
        Vector<ACL> v = new Vector<ACL>();
        if (response.isOK()) {
            int i = 0;
            int len = r.length;
            while (i < len) {
                IMAPResponse ir;
                if (r[i] instanceof IMAPResponse && (ir = (IMAPResponse)r[i]).keyEquals("ACL")) {
                    ir.readAtomString();
                    String name = null;
                    while ((name = ir.readAtom()) != null) {
                        String rights = ir.readAtomString();
                        if (rights == null) break;
                        ACL acl = new ACL(name, new Rights(rights));
                        v.addElement(acl);
                    }
                    r[i] = null;
                }
                ++i;
            }
        }
        this.notifyResponseHandlers(r);
        this.handleResult(response);
        Object[] aa = new ACL[v.size()];
        v.copyInto(aa);
        return aa;
    }

    public Rights[] listRights(String mbox, String user) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeASCII(mbox);
        args.writeASCII(user);
        Response[] r = this.command("LISTRIGHTS", args);
        Response response = r[r.length - 1];
        Vector<Rights> v = new Vector<Rights>();
        if (response.isOK()) {
            int i = 0;
            int len = r.length;
            while (i < len) {
                IMAPResponse ir;
                if (r[i] instanceof IMAPResponse && (ir = (IMAPResponse)r[i]).keyEquals("LISTRIGHTS")) {
                    String rights;
                    ir.readAtomString();
                    ir.readAtomString();
                    while ((rights = ir.readAtomString()) != null) {
                        v.addElement(new Rights(rights));
                    }
                    r[i] = null;
                }
                ++i;
            }
        }
        this.notifyResponseHandlers(r);
        this.handleResult(response);
        Object[] ra = new Rights[v.size()];
        v.copyInto(ra);
        return ra;
    }

    public Rights myRights(String mbox) throws ProtocolException {
        if (!this.hasCapability("ACL")) {
            throw new BadCommandException("ACL not supported");
        }
        mbox = BASE64MailboxEncoder.encode(mbox);
        Argument args = new Argument();
        args.writeASCII(mbox);
        Response[] r = this.command("MYRIGHTS", args);
        Response response = r[r.length - 1];
        Rights rights = null;
        if (response.isOK()) {
            int i = 0;
            int len = r.length;
            while (i < len) {
                IMAPResponse ir;
                if (r[i] instanceof IMAPResponse && (ir = (IMAPResponse)r[i]).keyEquals("MYRIGHTS")) {
                    ir.readAtomString();
                    String rs = ir.readAtomString();
                    if (rights == null) {
                        rights = new Rights(rs);
                    }
                    r[i] = null;
                }
                ++i;
            }
        }
        this.notifyResponseHandlers(r);
        this.handleResult(response);
        return rights;
    }
}

