/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;

final class IMAPAddress
extends InternetAddress {
    private static final long serialVersionUID = 1L;
    private boolean group = false;
    private InternetAddress[] grouplist;
    private String groupname;

    IMAPAddress(Response r) throws ParsingException {
        r.skipSpaces();
        if (r.readByte() != 40) {
            throw new ParsingException("ADDRESS parse error");
        }
        this.encodedPersonal = r.readString();
        r.readString();
        String mb = r.readString();
        try {
            mb = MimeUtility.decodeText(mb);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String host = r.readString();
        try {
            host = MimeUtility.decodeText(host);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (r.readByte() != 41) {
            throw new ParsingException("ADDRESS parse error");
        }
        if (host == null) {
            this.group = true;
            this.groupname = mb;
            if (this.groupname == null) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(this.groupname).append(':');
            Vector<IMAPAddress> v = new Vector<IMAPAddress>();
            while (true) {
                IMAPAddress a = new IMAPAddress(r);
                if (a.group && a.groupname == null) break;
                if (v.size() != 0) {
                    sb.append(',');
                }
                sb.append(a.toString());
                v.addElement(a);
            }
            sb.append(';');
            this.address = sb.toString();
            this.grouplist = new IMAPAddress[v.size()];
            v.copyInto(this.grouplist);
        } else {
            if (mb == null || mb.length() == 0) {
                this.address = host;
            }
            this.address = host == null || host.length() == 0 ? mb : String.valueOf(mb) + '@' + host;
        }
    }

    public boolean isGroup() {
        return this.group;
    }

    public InternetAddress[] getGroup(boolean strict) throws AddressException {
        if (this.grouplist == null) {
            return null;
        }
        return (InternetAddress[])this.grouplist.clone();
    }
}

