/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.handlers;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import jp.sourceforge.livez.mail.util.JISAutoDetect;
import jp.sourceforge.livez.mail.util.UTF7;
import jp.sourceforge.livez.mail.util.WindowsEUCJP;
import jp.sourceforge.livez.mail.util.WindowsJIS;

public class text_plain
implements DataContentHandler {
    private static ActivationDataFlavor myDF;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        myDF = new ActivationDataFlavor((Class)clazz, "text/plain", "Text String");
    }

    protected ActivationDataFlavor getDF() {
        return myDF;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.getDF()};
    }

    public Object getTransferData(DataFlavor df, DataSource ds) throws IOException {
        if (this.getDF().equals(df)) {
            return this.getContent(ds);
        }
        return null;
    }

    public Object getContent(DataSource ds) throws IOException {
        int count;
        String enc = null;
        InputStreamReader is = null;
        try {
            enc = this.getCharset(ds.getContentType());
            is = "ISO-2022-JP".equalsIgnoreCase(enc) ? new InputStreamReader(ds.getInputStream(), "ISO-8859-1") : ("Shift_JIS".equalsIgnoreCase(enc) ? new InputStreamReader(ds.getInputStream(), "Windows-31J") : ("euc-jp".equalsIgnoreCase(enc) ? new InputStreamReader(ds.getInputStream(), "ISO-8859-1") : ("utf7".equalsIgnoreCase(enc) ? new InputStreamReader(ds.getInputStream(), "ISO-8859-1") : new InputStreamReader(ds.getInputStream(), enc))));
        }
        catch (IllegalArgumentException iex) {
            throw new UnsupportedEncodingException(enc);
        }
        int pos = 0;
        char[] buf = new char[1024];
        while ((count = is.read(buf, pos, buf.length - pos)) != -1) {
            if ((pos += count) < buf.length) continue;
            int size = buf.length;
            size = size < 262144 ? (size += size) : (size += 262144);
            char[] tbuf = new char[size];
            System.arraycopy(buf, 0, tbuf, 0, pos);
            buf = tbuf;
        }
        if ("ISO-2022-JP".equalsIgnoreCase(enc)) {
            return JISAutoDetect.decode(new String(buf, 0, pos));
        }
        if ("euc-jp".equalsIgnoreCase(enc)) {
            String s = new String(buf, 0, pos);
            try {
                return WindowsEUCJP.decode(s.getBytes("ISO-8859-1"));
            }
            catch (Exception e) {
                return s;
            }
        }
        if ("utf7".equalsIgnoreCase(enc)) {
            String s = new String(buf, 0, pos);
            try {
                byte[] bytes = s.getBytes("ISO-8859-1");
                return UTF7.decode(bytes);
            }
            catch (Exception e) {
                return s;
            }
        }
        return new String(buf, 0, pos);
    }

    public void writeTo(Object obj, String type, OutputStream os) throws IOException {
        if (!(obj instanceof String)) {
            throw new IOException(String.valueOf('\"') + this.getDF().getMimeType() + "\" DataContentHandler requires String object, was given object of type " + obj.getClass().toString());
        }
        String enc = null;
        OutputStreamWriter osw = null;
        try {
            enc = this.getCharset(type);
            osw = "ISO-2022-JP".equalsIgnoreCase(enc) ? new OutputStreamWriter(os, "ISO-8859-1") : ("Shift_JIS".equalsIgnoreCase(enc) ? new OutputStreamWriter(os, "Windows-31J") : ("euc-jp".equalsIgnoreCase(enc) ? new OutputStreamWriter(os, "ISO-8859-1") : new OutputStreamWriter(os, enc)));
        }
        catch (IllegalArgumentException iex) {
            throw new UnsupportedEncodingException(enc);
        }
        String s = (String)obj;
        if ("ISO-2022-JP".equalsIgnoreCase(enc)) {
            s = new String(WindowsJIS.encode(s), "ISO-8859-1");
        } else if ("euc-jp".equalsIgnoreCase(enc)) {
            s = new String(WindowsEUCJP.encode(s), "ISO-8859-1");
        }
        osw.write(s, 0, s.length());
        osw.flush();
    }

    private String getCharset(String type) {
        String charset = null;
        try {
            ContentType ct = new ContentType(type);
            charset = ct.getParameter("charset");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (charset == null || "us-ascii".equalsIgnoreCase(charset)) {
            charset = System.getProperty("mail.mime.charset");
        }
        if (charset == null || "us-ascii".equalsIgnoreCase(charset)) {
            charset = "ja".equalsIgnoreCase(Locale.getDefault().getLanguage()) ? "ISO-2022-JP" : "us-ascii";
        }
        return MimeUtility.javaCharset(charset);
    }
}

