/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.freehep.swing.graphics.AbstractRegionSelectionPanel;
import org.freehep.swing.graphics.GraphicalSelectionPanel;
import org.freehep.swing.images.FreeHepImage;

public class XSliceSelectionPanel
extends AbstractRegionSelectionPanel {
    public int getNumberOfControlPoints() {
        return 6;
    }

    public Cursor getControlPointCursor(int index) {
        int k;
        switch (index) {
            case 0: 
            case 3: 
            case 4: {
                k = 5;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                k = 4;
                break;
            }
            default: {
                return FreeHepImage.getCursor("XSliceCursor");
            }
        }
        int dx = this.xCtrlPts[index] - this.xCtrlPts[k];
        if (dx == 0) {
            return FreeHepImage.getCursor("XSliceCursor");
        }
        return AbstractRegionSelectionPanel.compassCursor("Resize", dx, 1, 4, false);
    }

    public void initializeControlPoints(int x, int y) {
        this.activeCtrlPt = 5;
        Arrays.fill(this.xCtrlPts, x);
        int ymax = this.getHeight();
        int ymid = ymax / 2;
        this.yCtrlPts[0] = 0;
        this.yCtrlPts[1] = 0;
        this.yCtrlPts[2] = ymax;
        this.yCtrlPts[3] = ymax;
        this.yCtrlPts[4] = ymid;
        this.yCtrlPts[5] = ymid;
    }

    public void updateActiveControlPoint(int x, int y) {
        x = this.forceXCoordinateWithinBounds(x);
        if (this.activeCtrlPt == 0 || this.activeCtrlPt == 3 || this.activeCtrlPt == 4) {
            this.xCtrlPts[0] = x;
            this.xCtrlPts[3] = x;
            this.xCtrlPts[4] = x;
        } else if (this.activeCtrlPt == 1 || this.activeCtrlPt == 2 || this.activeCtrlPt == 5) {
            this.xCtrlPts[1] = x;
            this.xCtrlPts[2] = x;
            this.xCtrlPts[5] = x;
        }
        this.repaintPanel();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(GraphicalSelectionPanel.thickStroke);
            g.setColor(Color.black);
            g.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g.drawLine(this.xCtrlPts[4], this.yCtrlPts[4], this.xCtrlPts[5], this.yCtrlPts[5]);
            }
            g2d.setStroke(GraphicalSelectionPanel.thinStroke);
            g.setColor(Color.white);
            g.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g.drawLine(this.xCtrlPts[4], this.yCtrlPts[4], this.xCtrlPts[5], this.yCtrlPts[5]);
            }
            if (this.activeCtrlPt >= 0) {
                g.setColor(Color.black);
                g.fillRect(this.xCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize - 1, this.yCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize - 1, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 3, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 3);
                g.setColor(Color.white);
                g.fillRect(this.xCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize, this.yCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 1, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 1);
            }
        }
    }

    public AffineTransform makeAffineTransform() {
        int first = 0;
        int second = 1;
        int third = 2;
        if (this.xCtrlPts[1] < this.xCtrlPts[0]) {
            first = 1;
            second = 0;
            third = 3;
        }
        return this.makeTransform(this.xCtrlPts[first], this.yCtrlPts[first], this.xCtrlPts[second], this.yCtrlPts[second], this.xCtrlPts[third], this.yCtrlPts[third]);
    }

    public boolean isValidSelection() {
        return this.visible && this.xCtrlPts[4] != this.xCtrlPts[5] && this.yCtrlPts[0] != this.yCtrlPts[3];
    }
}

