/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.swing.graphics.AbstractPanelArtist;
import org.freehep.swing.graphics.BackedPanel;
import org.freehep.swing.graphics.GraphicalSelectionPanel;
import org.freehep.swing.layout.StackedLayout;

public class StackedPanel
extends JLayeredPane
implements Serializable,
PropertyChangeListener {
    private Component componentToPrint = null;
    VectorGraphics printGraphics = null;
    private boolean inhibitRepaint = false;
    public static final String NEED_GRAPHICAL_SELECTION_PANEL = "Class must be a type of GraphicalSelectionPanel";
    private AbstractPanelArtist panelArtist = null;
    private UpdateTask updateTask;
    private Timer timer;
    public static final Integer INTERACTION_LAYER = new Integer(JLayeredPane.PALETTE_LAYER - 1);
    public static final Integer MINIMUM_LAYER = JLayeredPane.DEFAULT_LAYER;
    public static final Integer MAXIMUM_LAYER = INTERACTION_LAYER;
    private LinkedList panelList = new LinkedList();
    private HashMap panelHash = new HashMap(15);
    private boolean redrawNeeded;
    static /* synthetic */ Class class$org$freehep$swing$graphics$GraphicalSelectionPanel;

    public StackedPanel() {
        this(null);
    }

    public StackedPanel(AbstractPanelArtist panelArtist) {
        this.updateTask = new UpdateTask();
        this.timer = new Timer(300, this.updateTask);
        this.setRedrawNeeded(true);
        this.setLayout(new StackedLayout());
        this.setPanelArtist(panelArtist);
    }

    public void addLayer(String layerName, int sublayers, boolean opaque) {
        if (sublayers <= 0) {
            throw new IllegalArgumentException();
        }
        JComponent[] panels = new JComponent[sublayers];
        int i = 0;
        while (i < sublayers) {
            panels[i] = new BackedPanel(opaque && i == sublayers - 1);
            ++i;
        }
        this.addLayer(layerName, panels);
    }

    public void addLayer(String layerName, JComponent panel) {
        this.addLayer(layerName, new JComponent[]{panel});
    }

    public void addLayer(String layerName, JComponent[] panels) {
        PanelArray panelArray = new PanelArray(panels);
        if (this.panelList.contains(layerName)) {
            this.removeLayer(layerName);
        }
        int i = 0;
        while (i < panels.length) {
            this.add(panels[i]);
            ++i;
        }
        this.panelList.add(layerName);
        this.panelHash.put(layerName, panelArray);
        this.reorderLayers();
    }

    public void removeLayer(String layerName) {
        PanelArray panelArray = (PanelArray)this.panelHash.get(layerName);
        if (panelArray != null) {
            Component[] comps = panelArray.getComponents();
            int i = 0;
            while (i < comps.length) {
                this.remove(comps[i]);
                ++i;
            }
            panelArray.clear();
            this.panelList.remove(layerName);
            this.panelHash.remove(layerName);
            this.reorderLayers();
        }
    }

    public void reorderLayers() {
        int layer = MINIMUM_LAYER;
        Iterator i = this.panelList.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            PanelArray panelArray = (PanelArray)this.panelHash.get(key);
            if (panelArray == null) continue;
            Component[] comps = panelArray.getComponents();
            int j = comps.length - 1;
            while (j >= 0) {
                this.setLayer(comps[j], layer++);
                --j;
            }
        }
    }

    public void addGraphicalSelectionPanel(GraphicalSelectionPanel panel) {
        panel.setVisible(false);
        this.add((Component)panel, INTERACTION_LAYER);
    }

    public void removeGraphicalSelectionPanel(GraphicalSelectionPanel panel) {
        this.remove(panel);
    }

    public void activateGraphicalSelectionPanelOfClass(Class c) throws InstantiationException, IllegalAccessException {
        if (!(class$org$freehep$swing$graphics$GraphicalSelectionPanel == null ? (class$org$freehep$swing$graphics$GraphicalSelectionPanel = StackedPanel.class$("org.freehep.swing.graphics.GraphicalSelectionPanel")) : class$org$freehep$swing$graphics$GraphicalSelectionPanel).isAssignableFrom(c)) {
            throw new IllegalArgumentException(NEED_GRAPHICAL_SELECTION_PANEL);
        }
        Component[] components = this.getComponentsInLayer(INTERACTION_LAYER);
        boolean create = true;
        int i = 0;
        while (i < components.length) {
            boolean test = c == components[i].getClass();
            components[i].setVisible(test);
            if (test) {
                create = false;
            }
            ++i;
        }
        if (create) {
            GraphicalSelectionPanel newSelector = (GraphicalSelectionPanel)c.newInstance();
            this.addGraphicalSelectionPanel(newSelector);
            newSelector.setVisible(true);
            if (this.panelArtist != null) {
                newSelector.addGraphicalSelectionListener(this.panelArtist);
            }
        }
    }

    public void activateGraphicalSelectionPanel(GraphicalSelectionPanel panel) {
        Component[] components = this.getComponentsInLayer(INTERACTION_LAYER);
        int i = 0;
        while (i < components.length) {
            components[i].setVisible(components[i] == panel);
            ++i;
        }
    }

    public void deactivateGraphicalSelectionPanels() {
        Component[] components = this.getComponentsInLayer(INTERACTION_LAYER);
        int i = 0;
        while (i < components.length) {
            components[i].setVisible(false);
            ++i;
        }
    }

    public void setVisible(String layerName, boolean[] visible) {
        PanelArray panelArray = (PanelArray)this.panelHash.get(layerName);
        if (panelArray != null) {
            Component[] comps = panelArray.getComponents();
            if (visible.length < comps.length) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < comps.length) {
                comps[i].setVisible(visible[i]);
                ++i;
            }
        }
    }

    public void setPanelArtist(AbstractPanelArtist panelArtist) {
        Component[] components = this.getComponentsInLayer(INTERACTION_LAYER);
        int i = 0;
        while (i < components.length) {
            GraphicalSelectionPanel selector = (GraphicalSelectionPanel)components[i];
            if (this.panelArtist != null) {
                selector.removeGraphicalSelectionListener(this.panelArtist);
            }
            if (panelArtist != null) {
                selector.addGraphicalSelectionListener(panelArtist);
            }
            ++i;
        }
        if (this.panelArtist != null) {
            this.panelArtist.setStackedPanel(null);
        }
        this.panelArtist = panelArtist;
        if (panelArtist != null) {
            panelArtist.setStackedPanel(this);
            if (panelArtist instanceof MouseListener) {
                this.addMouseListener((MouseListener)((Object)panelArtist));
            }
        }
    }

    public AbstractPanelArtist getPanelArtist() {
        return this.panelArtist;
    }

    public boolean isRedrawNeeded() {
        return this.redrawNeeded;
    }

    public void setRedrawNeeded(boolean redrawNeeded) {
        this.redrawNeeded = redrawNeeded;
    }

    public void getGraphics(String layerName, Graphics[] g) {
        PanelArray panelArray = (PanelArray)this.panelHash.get(layerName);
        if (panelArray != null) {
            Component[] comps = panelArray.getComponents();
            if (g.length < comps.length) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < comps.length) {
                if (this.componentToPrint != null && comps[i] == this.componentToPrint) {
                    g[i] = this.printGraphics;
                } else if (this.componentToPrint != null) {
                    g[i] = null;
                } else if (comps[i] != null) {
                    g[i] = comps[i].getGraphics();
                }
                ++i;
            }
        }
    }

    public void clearAllLayers() {
        Iterator iterator = this.panelHash.keySet().iterator();
        while (iterator.hasNext()) {
            this.clearLayer((String)iterator.next());
        }
    }

    public void clearLayer(String layerName) {
        if (this.componentToPrint == null) {
            Graphics[] g = new Graphics2D[2];
            this.getGraphics(layerName, g);
            Insets insets = this.getInsets();
            int w = this.getWidth() - (insets.left + insets.right);
            int h = this.getHeight() - (insets.top + insets.bottom);
            int i = 0;
            while (i < 2) {
                Graphics g2d = g[i];
                if (g2d != null) {
                    ((Graphics2D)g2d).setComposite(AlphaComposite.Clear);
                    g2d.fillRect(0, 0, w, h);
                    ((Graphics2D)g2d).setComposite(AlphaComposite.Src);
                }
                ++i;
            }
        }
    }

    public void setAntialias(String layerName, boolean antialias) {
        if (this.componentToPrint == null) {
            Graphics[] g = new Graphics[2];
            this.getGraphics(layerName, g);
            int i = 0;
            while (i < 2) {
                Graphics2D g2d = (Graphics2D)g[i];
                if (g2d != null) {
                    if (antialias) {
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    } else {
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                    }
                }
                ++i;
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        System.out.println("Done");
    }

    public void paintChildren(Graphics g) {
        System.out.println("Children...");
        long t0 = System.currentTimeMillis();
        super.paintChildren(g);
        long t1 = System.currentTimeMillis();
        System.out.println("Children took: " + (t1 - t0) + " ms.");
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.redrawNeeded && !this.inhibitRepaint) {
            this.setRedrawNeeded(false);
            this.stopPeriodicUpdate();
            if (this.panelArtist != null && !this.panelArtist.drawPanel()) {
                this.startPeriodicUpdate();
            }
        }
    }

    public void printComponent(Graphics g) {
        if (this.panelArtist != null) {
            VectorGraphics tempGraphics = VectorGraphics.create((Graphics)g);
            Insets insets = this.getInsets();
            int w = this.getWidth();
            int h = this.getHeight();
            this.printGraphics = (VectorGraphics)tempGraphics.create(insets.left, insets.top, w - (insets.left + insets.right), h - (insets.top + insets.bottom));
            this.printGraphics.printComment("StackedPanel: START ");
            Component[] clist = this.getComponents();
            Object[] indexed = new ComponentIndex[clist.length];
            int i = 0;
            while (i < clist.length) {
                Component c = clist[i];
                indexed[i] = new ComponentIndex(c, this.getLayer(c), this.getPosition(c));
                ++i;
            }
            Arrays.sort(indexed);
            int i2 = 0;
            while (i2 < indexed.length) {
                this.componentToPrint = ((ComponentIndex)indexed[i2]).getComponent();
                if (this.componentToPrint.isVisible()) {
                    if (this.componentToPrint instanceof BackedPanel) {
                        this.printGraphics.printComment("StackedPanel: " + i2 + " " + this.panelArtist.getDescription());
                        this.panelArtist.drawPanel();
                    } else if (this.componentToPrint instanceof JComponent) {
                        this.printGraphics.printComment("StackedPanel: " + i2 + " JComponent " + this.componentToPrint.getClass().getName());
                        this.componentToPrint.print(g);
                    } else {
                        this.printGraphics.printComment("StackedPanel: " + i2 + " Component " + this.componentToPrint.getClass().getName());
                        this.componentToPrint.paintAll(g);
                    }
                }
                ++i2;
            }
            this.printGraphics.printComment("StackedPanel: END ");
            this.componentToPrint = null;
            this.printGraphics.dispose();
            this.printGraphics = null;
        }
    }

    public void drawComplete() {
        this.stopPeriodicUpdate();
        this.updateTask.actionPerformed(new ActionEvent(this, 1001, "timer.stop"));
    }

    public void setUpdatePeriod(int period) {
        this.timer.setDelay(Math.max(0, period));
    }

    public long getUpdatePeriod() {
        return this.timer.getDelay();
    }

    protected void startPeriodicUpdate() {
        this.timer.restart();
    }

    protected void stopPeriodicUpdate() {
        this.timer.stop();
    }

    public void setBorder(Border border) {
        Insets insets = this.getInsets();
        Insets borderInsets = null;
        borderInsets = border != null ? border.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        if (insets.left != borderInsets.left || insets.top != borderInsets.top || insets.right != borderInsets.right || insets.bottom != borderInsets.bottom) {
            this.setRedrawNeeded(true);
        }
        super.setBorder(border);
    }

    public void setBounds(int x, int y, int w, int h) {
        if (!this.inhibitRepaint) {
            super.setBounds(x, y, w, h);
            if (this.panelArtist != null) {
                this.panelArtist.panelResized();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("InhibitRepaint")) {
            if (evt.getNewValue() == null) {
                this.inhibitRepaint = false;
                this.invalidate();
                this.validate();
                this.repaint();
            } else {
                this.inhibitRepaint = true;
            }
        }
    }

    public void printBorder(Graphics g) {
        VectorGraphics vg = null;
        if (g instanceof VectorGraphics) {
            vg = (VectorGraphics)g;
        }
        if (vg != null) {
            vg.printComment("StackedPanel: (border) START ");
        }
        super.printBorder(g);
        if (vg != null) {
            vg.printComment("StackedPanel: (border) END ");
        }
    }

    public void printChildren(Graphics g) {
        VectorGraphics vg = null;
        if (g instanceof VectorGraphics) {
            vg = (VectorGraphics)g;
        }
        if (vg != null) {
            vg.printComment("StackedPanel: (children) START ");
        }
        super.printChildren(g);
        if (vg != null) {
            vg.printComment("StackedPanel: (children) END ");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ComponentIndex
    implements Comparable {
        private Component component;
        private int layer;
        private int position;

        public ComponentIndex(Component component, int layer, int position) {
            this.component = component;
            this.layer = layer;
            this.position = position;
        }

        public Component getComponent() {
            return this.component;
        }

        public int hashcode() {
            return this.layer ^ this.position;
        }

        public boolean equals(Object o) {
            ComponentIndex other = (ComponentIndex)o;
            return this.layer == other.layer && this.position == other.position;
        }

        public int compareTo(Object o) {
            ComponentIndex other = (ComponentIndex)o;
            if (this.layer < other.layer) {
                return -1;
            }
            if (this.layer > other.layer) {
                return 1;
            }
            if (this.position > other.position) {
                return -1;
            }
            if (this.position < other.position) {
                return 1;
            }
            return 0;
        }
    }

    protected class PanelArray {
        private JComponent[] panels;

        public PanelArray(JComponent[] panels) {
            this.panels = panels;
        }

        public Component[] getComponents() {
            return this.panels;
        }

        public JComponent getComponent(int index) {
            return this.panels[index];
        }

        public void clear() {
            int i = 0;
            while (i < this.panels.length) {
                this.panels[i] = null;
                ++i;
            }
            this.panels = null;
        }
    }

    class UpdateTask
    implements ActionListener {
        UpdateTask() {
        }

        public void actionPerformed(ActionEvent event) {
            StackedPanel.this.repaint();
        }
    }
}

