/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.SwingUtilities;
import org.freehep.application.ApplicationEvent;
import org.freehep.application.mdi.MDIApplication;
import org.freehep.application.studio.EventSender;
import org.freehep.application.studio.ExtensionClassLoader;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.PluginInfo;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commandline.CommandLine;
import org.freehep.xml.util.ClassPathEntityResolver;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;

public class Studio
extends MDIApplication {
    private FreeHEPLookup lookup;
    private List loadedPlugins = new ArrayList();
    private EventSender sender = new EventSender();
    private boolean debugExtensions = System.getProperty("debugExtensions") != null;
    private SAXBuilder builder = new SAXBuilder(true);
    private ExtensionClassLoader extensionLoader;
    static /* synthetic */ Class class$org$freehep$application$studio$Studio;

    protected Studio(String name) {
        super(name);
        this.builder.setEntityResolver((EntityResolver)new ClassPathEntityResolver("plugin.dtd", class$org$freehep$application$studio$Studio == null ? (class$org$freehep$application$studio$Studio = Studio.class$("org.freehep.application.studio.Studio")) : class$org$freehep$application$studio$Studio));
    }

    private Studio() {
        this("Studio");
    }

    protected FreeHEPLookup createLookup() {
        return FreeHEPLookup.instance();
    }

    public EventSender getEventSender() {
        return this.sender;
    }

    public FreeHEPLookup getLookup() {
        if (this.lookup == null) {
            this.lookup = this.createLookup();
        }
        return this.lookup;
    }

    public List getPlugins() {
        return this.loadedPlugins;
    }

    public static void main(String[] args) {
        new Studio().createFrame(args).show();
    }

    protected CommandLine createCommandLine() {
        CommandLine cl = super.createCommandLine();
        cl.addOption("extdir", null, "directory", "Sets the directory to scan for plugins");
        return cl;
    }

    protected void init() {
        super.init();
        this.setStatusMessage("Loading extensions...");
        this.loadExtensions();
    }

    private void loadExtensions() {
        TreeMap extensionClasspath = new TreeMap();
        LinkedHashSet plugins = new LinkedHashSet();
        String[] extDirs = new String[]{this.getSystemExtensionsDir(), this.getGroupExtensionsDir(), this.getUserExtensionsDir()};
        this.scanExtensionDirectories(extDirs, extensionClasspath, plugins);
        URL[] urls = new URL[extensionClasspath.size()];
        extensionClasspath.values().toArray(urls);
        this.extensionLoader = new ExtensionClassLoader(urls);
        this.createLookup().setClassLoader(this.extensionLoader);
        Runnable lola = new Runnable(){

            public void run() {
                Thread.currentThread().setContextClassLoader(Studio.this.extensionLoader);
            }
        };
        lola.run();
        SwingUtilities.invokeLater(lola);
        this.loadPlugins(new ArrayList(plugins), this.extensionLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List buildPluginList(InputStream in) throws IOException {
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        try {
            try {
                Document doc = this.builder.build(in);
                Element root = doc.getRootElement();
                Iterator iter = root.getChildren().iterator();
                while (iter.hasNext()) {
                    Element node = (Element)iter.next();
                    PluginInfo plugin = new PluginInfo(node);
                    result.add(plugin);
                    if (!this.debugExtensions) continue;
                    System.out.println("\t\tPlugin: " + plugin.getName());
                }
            }
            catch (JDOMException x) {
                if (this.debugExtensions) {
                    x.printStackTrace();
                }
                Object var9_10 = null;
                in.close();
                return result;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return result;
    }

    public void loadPlugins(List plugins, ClassLoader loader) {
        Iterator iter = plugins.iterator();
        while (iter.hasNext()) {
            PluginInfo plugin = (PluginInfo)iter.next();
            if (!plugin.loadAtStart()) continue;
            try {
                if (this.debugExtensions) {
                    System.out.println("Loading plugin: " + plugin.getName());
                }
                this.getAppProperties().putAll((Map<?, ?>)plugin.getProperties());
                Class<?> c = loader.loadClass(plugin.getMainClass());
                Plugin plug = (Plugin)c.newInstance();
                plug.setContext(this);
                this.loadedPlugins.add(plugin);
            }
            catch (Throwable t) {
                System.err.println("Unable to load plugin " + plugin.getName());
                t.printStackTrace();
            }
        }
        this.revalidate();
    }

    private void scanExtensionDirectories(String[] dirs, Map extensionClasspath, Set plugins) {
        int i = 0;
        while (i < dirs.length) {
            if (dirs[i] != null) {
                File extdir = new File(dirs[i]);
                if (this.debugExtensions) {
                    System.out.println("Seaching for extensions in: " + extdir);
                }
                if (extdir.isDirectory()) {
                    this.scanExtensionDirectory(extdir, extensionClasspath, plugins);
                }
            }
            ++i;
        }
    }

    private void scanExtensionDirectory(File extdir, Map extensionClasspath, Set plugins) {
        String[] files = extdir.list();
        int i = 0;
        while (i < files.length) {
            if (files[i].endsWith(".jar")) {
                File f = new File(extdir, files[i]);
                if (f.length() > 0L) {
                    try {
                        JarFile jarFile;
                        JarEntry manifest;
                        if (this.debugExtensions) {
                            System.out.println("\tFound: " + files[i]);
                        }
                        if ((manifest = (jarFile = new JarFile(f)).getJarEntry("PLUGIN-inf/plugins.xml")) != null) {
                            InputStream in = jarFile.getInputStream(manifest);
                            plugins.addAll(this.buildPluginList(in));
                        }
                        jarFile.close();
                        extensionClasspath.put(f.getName(), f.toURI().toURL());
                    }
                    catch (IOException x) {
                        System.err.println("Extension jar file " + files[i] + " could not be loaded" + x);
                    }
                } else {
                    boolean removed = f.delete();
                }
            }
            ++i;
        }
    }

    public String getUserExtensionsDir() {
        String extdir = this.getCommandLine().getOption("extdir");
        if (extdir != null) {
            return extdir;
        }
        return this.getAppProperties().getProperty("org.freehep.application.studio.user.extensions", "{user.home}/.FreeHEPPlugins");
    }

    public String getGroupExtensionsDir() {
        return this.getAppProperties().getProperty("org.freehep.application.studio.group.extensions");
    }

    public String getSystemExtensionsDir() {
        return this.getAppProperties().getProperty("org.freehep.application.studio.system.extensions", "{java.home}/FreeHEPPlugins");
    }

    public ExtensionClassLoader getExtensionLoader() {
        return this.extensionLoader;
    }

    protected void fireInitializationComplete(ApplicationEvent event) {
        super.fireInitializationComplete(event);
        this.getEventSender().broadcast(event);
    }

    protected void fireAboutToExit(ApplicationEvent event) {
        super.fireAboutToExit(event);
        this.getEventSender().broadcast(event);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

