/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import org.freehep.application.Application;

public class LookAndFeelMenu
extends JMenu {
    public LookAndFeelMenu() {
        super("Look and Feel");
    }

    public void fireMenuSelected() {
        this.removeAll();
        LAFActionListener listener = new LAFActionListener();
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        String currentName = UIManager.getLookAndFeel().getName();
        int i = 0;
        while (i < info.length) {
            JRadioButtonMenuItem radio = new JRadioButtonMenuItem(info[i].getName());
            radio.setActionCommand(info[i].getClassName());
            radio.setSelected(info[i].getName().equals(currentName));
            radio.addActionListener(listener);
            this.add(radio);
            ++i;
        }
        super.fireMenuSelected();
    }

    private class LAFActionListener
    implements ActionListener {
        private LAFActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Application.getApplication().setLookAndFeel(e.getActionCommand());
        }
    }
}

