/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.freehep.graphicsio.font.truetype.TTFInput;
import org.freehep.graphicsio.font.truetype.TTFTable;

public abstract class TTFFont {
    private Map entry = new HashMap();

    public abstract int getFontVersion();

    void newTable(String tag, TTFInput input) throws IOException {
        this.entry.put(tag, this.initTable(tag, input));
    }

    private Object initTable(String name, TTFInput input) throws IOException {
        TTFTable table = null;
        int i = 0;
        while (i < TTFTable.TT_TAGS.length) {
            if (name.equals(TTFTable.TT_TAGS[i])) {
                try {
                    table = (TTFTable)TTFTable.TABLE_CLASSES[i].newInstance();
                    table.init(this, input);
                    return table;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            ++i;
        }
        System.err.println("Table '" + name + "' ignored.");
        return null;
    }

    public void show() {
        System.out.println("Tables:");
        Iterator i = this.entry.values().iterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }

    public TTFTable getTable(String tag) throws IOException {
        TTFTable table = (TTFTable)this.entry.get(tag);
        if (!table.isRead()) {
            table.read();
        }
        return table;
    }

    public void readAll() throws IOException {
        Iterator i = this.entry.values().iterator();
        while (i.hasNext()) {
            TTFTable table = (TTFTable)i.next();
            if (table == null || table.isRead()) continue;
            table.read();
        }
    }

    public void close() throws IOException {
    }
}

