/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.vodafone;

import jp.sourceforge.livez.vodafone.VodafoneSmaf;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.NumberUtils;

final class VodafoneSmafImpl
implements VodafoneSmaf {
    private static final long serialVersionUID = 1L;
    private int melody = 0;
    private boolean adpcm = false;
    private boolean pcm = false;
    private boolean karaoke = false;
    private boolean exKaraoke = false;

    protected VodafoneSmafImpl(String smaf) throws NullPointerException, IllegalArgumentException {
        if (smaf == null) {
            throw new NullPointerException();
        }
        if (!smaf.matches("^[0-9]+(/pcm(/grf(/rs){0,1}){0,1}){0,1}$")) {
            throw new IllegalArgumentException();
        }
        String[] s = smaf.split("/");
        this.melody = NumberUtils.toInt((String)s[0]);
        switch (s.length) {
            default: {
                this.exKaraoke = "rs".equals(s[3]);
            }
            case 3: {
                this.karaoke = "grf".equals(s[2]);
            }
            case 2: {
                if (!"pcm".equals(s[1])) break;
                this.adpcm = true;
                this.pcm = this.melody >= 40;
            }
            case 0: 
            case 1: 
        }
    }

    public int getMelody() {
        return this.melody;
    }

    public boolean isAdpcm() {
        return this.adpcm;
    }

    public boolean isPcm() {
        return this.pcm;
    }

    public boolean isKaraoke() {
        return this.karaoke;
    }

    public boolean isExKaraoke() {
        return this.exKaraoke;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

