/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.imode;

import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.livez.IllegalUserAgentException;
import jp.sourceforge.livez.UserAgentNotFoundException;
import jp.sourceforge.livez.imode.AccessType;
import jp.sourceforge.livez.imode.ImodeType;
import jp.sourceforge.livez.imode.ImodeUserAgent;
import jp.sourceforge.livez.imode.NetworkType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

final class ImodeUserAgentImpl
implements ImodeUserAgent {
    private static final String WLAN_PREFIX = "WLAN_";
    private static final String DOCOMO_PREFIX = "DoCoMo/";
    private static final String CACHE_SIZE_PATTERN = "c[0-9]{2,}";
    private static final String ACCESS_TYPE_PATTERN = "T[BCDJE]";
    private static final String CHAR_SIZE_PATTERN = "W[0-9]+H[0-9]+";
    private static final String SER_PREFIX = "ser";
    private static final String SER_PATTERN = "ser[0-9a-zA-Z]{11}";
    private static final String SER_FOMA_PATTERN = "ser[0-9a-zA-Z]{15}";
    private static final String ICC_PREFIX = "icc";
    private static final String ICC_PATTERN = "icc[0-9a-zA-Z]{20}";
    private static final String TRUSTED_PREFIX = "TdID";
    private static final String TRUSTED_APID_PATTERN = "TdID[0-9a-zA-Z]{11}";
    private static final String CAR_NAVI_ID = "ex_navi";
    private static final String UAERAGENT_PDC = "^DoCoMo/1\\.0/[^/]+(/c[0-9]{2,}){0,2}(/T[BCDJE]){0,1}(/W[0-9]+H[0-9]+){0,1}(/ser[0-9a-zA-Z]{11}){0,1}(/TdID[0-9a-zA-Z]{11}){0,1}$";
    private static final String USERAGENT_FOMA = "^(WLAN_){0,1}DoCoMo/2\\.0( |\u3000){1}[^/ (;)]+\\(c[0-9]{2,}((;T[BCDJE]){0,1}(;W[0-9]+H[0-9]+){0,1}(;ser[0-9a-zA-Z]{15};icc[0-9a-zA-Z]{20}){0,1}(;TdID[0-9a-zA-Z]{11}){0,1}){0,1}\\)$";
    private static final String USERAGENT_CARNAVI = "^DoCoMo/1\\.0/ex_navi_[0-9]\\.[0-9]_.+$";
    private static final String USERAGENT_PLAYSTATION = "^DoCoMo/1\\.0/ex_ps[0-9]+(/c[0-9]{2,}){0,1}$";
    private String value = null;
    private String id = null;
    private NetworkType networkType = NetworkType.IMODE;
    private ImodeType type = ImodeType.PDC;
    private String name = null;
    private String vendorId = null;
    private String seriesName = null;
    private int cacheSize = 0;
    private AccessType accessType = null;
    private int width = 0;
    private int height = 0;
    private String ser = null;
    private String icc = null;
    private String trustedId = null;
    private Float htmlVersion = null;
    private String browserName = null;

    public ImodeUserAgentImpl(HttpServletRequest request) throws UserAgentNotFoundException, IllegalUserAgentException {
        this(request.getHeader("User-Agent"));
    }

    public ImodeUserAgentImpl(String ua) throws UserAgentNotFoundException, IllegalUserAgentException {
        if (ua == null) {
            throw new UserAgentNotFoundException();
        }
        try {
            this.parse(ua);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalUserAgentException(e.getMessage(), e);
        }
    }

    private void parse(String ua) throws IllegalUserAgentException, IllegalArgumentException {
        this.value = ua;
        this.type = ImodeUserAgentImpl.getImodeType(ua);
        if (this.type == ImodeType.FOMA) {
            if (ua.startsWith(WLAN_PREFIX)) {
                this.networkType = NetworkType.WLAN;
            }
            String[] s = ua.split("[/ (;)]");
            this.id = s[2];
            this.name = "MST_v_SH2101V".equals(this.id) ? "SH2101V" : this.id;
            this.parseName(this.name);
            int i = 3;
            while (i < s.length) {
                if (s[i].matches(CACHE_SIZE_PATTERN)) {
                    this.cacheSize = Integer.parseInt(s[i].substring(1));
                } else if (s[i].matches(ACCESS_TYPE_PATTERN)) {
                    this.accessType = AccessType.getAccessType(s[i]);
                } else if (s[i].matches(CHAR_SIZE_PATTERN)) {
                    String[] numbers = s[i].split("(W|H)");
                    this.width = Integer.parseInt(numbers[1]);
                    this.height = Integer.parseInt(numbers[2]);
                } else if (s[i].matches(SER_FOMA_PATTERN)) {
                    this.ser = s[i].substring(SER_PREFIX.length());
                } else if (s[i].matches(ICC_PATTERN)) {
                    this.icc = s[i].substring(ICC_PREFIX.length());
                } else if (s[i].matches(TRUSTED_APID_PATTERN)) {
                    this.trustedId = s[i].substring(TRUSTED_PREFIX.length());
                }
                ++i;
            }
        } else if (this.type == ImodeType.CAR_NAVI) {
            this.id = CAR_NAVI_ID;
            this.name = CAR_NAVI_ID;
            int start = "DoCoMo/1.0/ex_navi".length() + 1;
            int i = ua.indexOf(95, start);
            this.htmlVersion = new Float(ua.substring(start, i));
            this.browserName = ua.substring(i + 1);
        } else {
            String[] s = ua.split("/");
            this.id = s[2];
            this.name = "P209is".equals(this.id) ? "P209iS" : this.id;
            this.parseName(this.name);
            int i = 3;
            while (i < s.length) {
                if (s[i].matches(CACHE_SIZE_PATTERN)) {
                    this.cacheSize = Integer.parseInt(s[i].substring(1));
                } else if (s[i].matches(ACCESS_TYPE_PATTERN)) {
                    this.accessType = AccessType.getAccessType(s[i]);
                } else if (s[i].matches(CHAR_SIZE_PATTERN)) {
                    String[] numbers = s[i].split("(W|H)");
                    this.width = Integer.parseInt(numbers[1]);
                    this.height = Integer.parseInt(numbers[2]);
                } else if (s[i].matches(SER_PATTERN)) {
                    this.ser = s[i].substring(SER_PREFIX.length());
                } else if (s[i].matches(TRUSTED_APID_PATTERN)) {
                    this.trustedId = s[i].substring(TRUSTED_PREFIX.length());
                }
                ++i;
            }
            if (this.type == ImodeType.PDC && this.cacheSize <= 0) {
                this.cacheSize = 5;
            }
            if (this.type == ImodeType.PLAYSTATION) {
                this.htmlVersion = new Float("2.0");
            }
        }
    }

    private static ImodeType getImodeType(String ua) throws IllegalUserAgentException {
        if (ua.matches(USERAGENT_FOMA)) {
            return ImodeType.FOMA;
        }
        if (ua.matches(USERAGENT_CARNAVI)) {
            return ImodeType.CAR_NAVI;
        }
        if (ua.matches(USERAGENT_PLAYSTATION)) {
            return ImodeType.PLAYSTATION;
        }
        if (ua.matches(UAERAGENT_PDC)) {
            return ImodeType.PDC;
        }
        throw new IllegalUserAgentException();
    }

    private void parseName(String name) {
        if (name == null || !name.matches("^[A-Z]+[0-9]{3,}.*$")) {
            return;
        }
        int start = -1;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9') {
                start = i;
                break;
            }
            ++i;
        }
        this.vendorId = name.substring(0, start);
        int end = -1;
        int i2 = start + 1;
        while (i2 < name.length()) {
            char c = name.charAt(i2);
            if (c < '0' || c > '9') {
                end = i2;
                if (c != 'i' && c != 'V') break;
                end = i2 + 1;
                break;
            }
            ++i2;
        }
        this.seriesName = end == -1 ? name.substring(start) : name.substring(start, end);
    }

    public String getValue() {
        return this.value;
    }

    public String getId() {
        return this.id;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public ImodeType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getVendorId() {
        return this.vendorId;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getSer() {
        return this.ser;
    }

    public String getIcc() {
        return this.icc;
    }

    public String getTrustedId() {
        return this.trustedId;
    }

    public Float getHtmlVersion() {
        return this.htmlVersion;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

