/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez.imode;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.livez.CarrierType;
import jp.sourceforge.livez.Screen;
import jp.sourceforge.livez.ServiceType;
import jp.sourceforge.livez.dao.ImodeFrame;
import jp.sourceforge.livez.images.ImageType;
import jp.sourceforge.livez.imode.AccessType;
import jp.sourceforge.livez.imode.Decomail;
import jp.sourceforge.livez.imode.DecomailImpl;
import jp.sourceforge.livez.imode.Flash;
import jp.sourceforge.livez.imode.FlashImpl;
import jp.sourceforge.livez.imode.Frame;
import jp.sourceforge.livez.imode.FrameImpl;
import jp.sourceforge.livez.imode.Iappli;
import jp.sourceforge.livez.imode.IappliImpl;
import jp.sourceforge.livez.imode.IemojiType;
import jp.sourceforge.livez.imode.Imode;
import jp.sourceforge.livez.imode.ImodeBrowser;
import jp.sourceforge.livez.imode.ImodeBrowserImpl;
import jp.sourceforge.livez.imode.ImodeRequest;
import jp.sourceforge.livez.imode.ImodeType;
import jp.sourceforge.livez.imode.ImodeUserAgent;
import jp.sourceforge.livez.imode.ImotionType;
import jp.sourceforge.livez.imode.NetworkType;
import jp.sourceforge.livez.imode.ScreenImpl;
import jp.sourceforge.livez.imode.SubScreen;
import jp.sourceforge.livez.imode.SubScreenImpl;
import jp.sourceforge.livez.imode.UID;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImodeImpl
implements Imode {
    private static final long serialVersionUID = 1L;
    private String id = null;
    private String name = null;
    private String productName = null;
    private String seriesName = null;
    private String vendorId = null;
    private ScreenImpl screen = null;
    private SubScreenImpl subScreen = null;
    private ImodeBrowserImpl browser = new ImodeBrowserImpl();
    private IappliImpl appli = null;
    private FlashImpl flash = null;
    private ImotionType imotionType = null;
    private boolean pdf = false;
    private boolean charaDen = false;
    private Decomail decomail = null;
    private boolean toruca = false;
    private boolean ichannel = false;
    private IemojiType iemojiType = IemojiType.STANDARD;
    private List<Frame> frames = null;
    private boolean menuIcon = false;
    private Float barcode = null;
    private Integer ssl = null;
    private List<ImageType> imageTypes = new ArrayList<ImageType>(4);
    private ImodeType type = null;
    private AccessType accessType = null;
    private NetworkType networkType = null;
    private int geoCode = -1;
    private String ser = null;
    private String icc = null;
    private UID userId = null;
    private String trustedId = null;

    void setup(jp.sourceforge.livez.dao.Imode imode) {
        this.name = imode.getName();
        this.productName = imode.getProductName();
        this.seriesName = imode.getSeriesName();
        this.screen = new ScreenImpl(imode);
        if (imode.getSubscreen() != null) {
            this.subScreen = new SubScreenImpl(imode.getSubscreen());
        }
        this.browser.setup(imode);
        if (imode.getIappli() != null) {
            this.appli = new IappliImpl(imode.getIappli());
        }
        if (imode.getFlash() != null) {
            this.flash = new FlashImpl(imode.getFlash(), imode.getScreenWidth());
        }
        if (imode.getImotion() != null) {
            this.imotionType = ImotionType.valueOf(imode.getImotion());
        }
        this.pdf = imode.isPdf();
        this.charaDen = imode.isCharaDen();
        if (imode.getDecomail() != null) {
            this.decomail = new DecomailImpl(imode.getDecomail());
        }
        this.toruca = imode.isToruca();
        this.ichannel = imode.isIchannel();
        if ((double)this.browser.getHtmlVersion() >= 4.0) {
            this.iemojiType = IemojiType.STANDARD_AND_EXTENSTION;
        }
        if (imode.getFrames() != null && imode.getFrames().size() > 0) {
            ArrayList<Frame> list = new ArrayList<Frame>(imode.getFrames().size());
            for (ImodeFrame frame : imode.getFrames()) {
                list.add(new FrameImpl(frame));
            }
            this.frames = list;
        }
        this.menuIcon = imode.isMenuIcon();
        if (imode.getBarcode() != null) {
            this.barcode = imode.getBarcode();
        }
        this.ssl = imode.getSsl();
        if (imode.getColor() > 256) {
            this.imageTypes.add(ImageType.GIF_8BIT);
        }
        if (imode.getColor() > 4) {
            this.imageTypes.add(ImageType.GIF_2BIT);
        }
        if (imode.isJpeg()) {
            this.imageTypes.add(ImageType.JPEG);
        }
    }

    void setup(ImodeRequest r) {
        ImodeUserAgent ua = r.getUserAgent();
        this.id = ua.getId();
        this.name = ua.getName();
        if (this.seriesName != null) {
            this.seriesName = ua.getSeriesName();
        }
        this.vendorId = ua.getVendorId();
        this.browser.setup(ua);
        this.type = ua.getType();
        this.accessType = ua.getAccessType();
        this.networkType = ua.getNetworkType();
        this.geoCode = r.getRoaming();
        this.ser = ua.getSer();
        this.icc = ua.getIcc();
        this.userId = r.getUID();
        this.trustedId = ua.getTrustedId();
        this.imageTypes.add(ImageType.GIF_1BIT);
    }

    @Override
    public ServiceType getServiceType() {
        return ServiceType.IMODE;
    }

    @Override
    public CarrierType getCarrierType() {
        return CarrierType.NTT_DOCOMO;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getSeriesName() {
        return this.seriesName;
    }

    @Override
    public String getVendorId() {
        return this.vendorId;
    }

    @Override
    public Screen getScreen() {
        return this.screen;
    }

    @Override
    public SubScreen getSubScreen() {
        return this.subScreen;
    }

    @Override
    public ImodeBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public Iappli getAppli() {
        return this.appli;
    }

    @Override
    public Flash getFlash() {
        return this.flash;
    }

    @Override
    public ImotionType getImotionType() {
        return this.imotionType;
    }

    @Override
    public boolean isPdf() {
        return this.pdf;
    }

    @Override
    public boolean isCharaDen() {
        return this.charaDen;
    }

    @Override
    public Decomail getDecomail() {
        return this.decomail;
    }

    @Override
    public boolean isToruca() {
        return this.toruca;
    }

    @Override
    public boolean isIchannel() {
        return this.ichannel;
    }

    @Override
    public IemojiType getIemojiType() {
        return this.iemojiType;
    }

    @Override
    public List<Frame> getFrames() {
        return this.frames;
    }

    @Override
    public boolean isMenuIcon() {
        return this.menuIcon;
    }

    @Override
    public Float getBarcode() {
        return this.barcode;
    }

    @Override
    public Integer getSsl() {
        return this.ssl;
    }

    @Override
    public List<ImageType> getEnableImageTypes() {
        return this.imageTypes;
    }

    @Override
    public ImodeType getType() {
        return this.type;
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public NetworkType getNetworkType() {
        return this.networkType;
    }

    @Override
    public int getGeoCode() {
        return this.geoCode;
    }

    @Override
    public String getSer() {
        return this.ser;
    }

    @Override
    public String getIcc() {
        return this.icc;
    }

    @Override
    public UID getUserId() {
        return this.userId;
    }

    @Override
    public String getTrustedId() {
        return this.trustedId;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

