/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.livez;

import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.livez.IllegalRequestException;
import jp.sourceforge.livez.MobilePhone;
import jp.sourceforge.livez.MobilePhoneGenerator;
import jp.sourceforge.livez.MobilePhoneRequest;
import jp.sourceforge.livez.Service;
import jp.sourceforge.livez.ServiceNotFoundException;
import jp.sourceforge.livez.brew.BrewService;
import jp.sourceforge.livez.ezweb.EZwebService;
import jp.sourceforge.livez.imode.ImodeService;
import jp.sourceforge.livez.vodafone.VodafoneService;
import org.springframework.web.context.WebApplicationContext;

public final class MobilePhoneFactory {
    private static final Service[] services = new Service[]{new ImodeService(), new EZwebService(), new VodafoneService(), new BrewService()};

    private MobilePhoneFactory() {
    }

    public static MobilePhone getMobilePhone(HttpServletRequest request, WebApplicationContext context) throws NullPointerException, ServiceNotFoundException {
        return MobilePhoneFactory.getMobilePhoneGenerator(request, context).create();
    }

    private static MobilePhoneGenerator getMobilePhoneGenerator(HttpServletRequest request, WebApplicationContext context) throws NullPointerException, ServiceNotFoundException {
        int i = 0;
        while (i < services.length) {
            Service service = services[i];
            try {
                Object r = service.getMobilePhoneRequest(request);
                Object g = service.getMobilePhoneGenerator(context);
                ((MobilePhoneGenerator)g).setMobilePhoneRequest(r);
                return g;
            }
            catch (IllegalRequestException illegalRequestException) {
                ++i;
            }
        }
        throw new ServiceNotFoundException();
    }

    public static MobilePhoneRequest getMobilePhoneRequest(HttpServletRequest request) throws NullPointerException, ServiceNotFoundException {
        int i = 0;
        while (i < services.length) {
            Service service = services[i];
            try {
                return service.getMobilePhoneRequest(request);
            }
            catch (IllegalRequestException illegalRequestException) {
                ++i;
            }
        }
        throw new ServiceNotFoundException();
    }
}

