/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.util.StringUtils;

public class ResourceBundleMessageSource
extends AbstractMessageSource {
    private String[] basenames = new String[0];
    private ClassLoader bundleClassLoader = Thread.currentThread().getContextClassLoader();
    private final Map cachedResourceBundles = new HashMap();
    private final Map cachedBundleMessageFormats = new HashMap();

    public void setBasename(String basename) {
        this.setBasenames(new String[]{basename});
    }

    public void setBasenames(String[] basenames) {
        this.basenames = basenames != null ? basenames : new String[]{};
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.bundleClassLoader = classLoader;
    }

    public void setBundleClassLoader(ClassLoader classLoader) {
        this.bundleClassLoader = classLoader;
    }

    protected ClassLoader getBundleClassLoader() {
        return this.bundleClassLoader;
    }

    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        String result = null;
        for (int i = 0; result == null && i < this.basenames.length; ++i) {
            ResourceBundle bundle = this.getResourceBundle(this.basenames[i], locale);
            if (bundle == null) continue;
            result = this.getStringOrNull(bundle, code);
        }
        return result;
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        MessageFormat messageFormat = null;
        for (int i = 0; messageFormat == null && i < this.basenames.length; ++i) {
            ResourceBundle bundle = this.getResourceBundle(this.basenames[i], locale);
            if (bundle == null) continue;
            messageFormat = this.getMessageFormat(bundle, code, locale);
        }
        return messageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceBundle getResourceBundle(String basename, Locale locale) {
        Map map = this.cachedResourceBundles;
        synchronized (map) {
            ResourceBundle bundle;
            HashMap<Locale, ResourceBundle> localeMap = (HashMap<Locale, ResourceBundle>)this.cachedResourceBundles.get(basename);
            if (localeMap != null && (bundle = (ResourceBundle)localeMap.get(locale)) != null) {
                return bundle;
            }
            try {
                bundle = this.doGetBundle(basename, locale);
                if (localeMap == null) {
                    localeMap = new HashMap<Locale, ResourceBundle>();
                    this.cachedResourceBundles.put(basename, localeMap);
                }
                localeMap.put(locale, bundle);
                return bundle;
            }
            catch (MissingResourceException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("ResourceBundle [" + basename + "] not found for MessageSource: " + ex.getMessage()));
                }
                return null;
            }
        }
    }

    protected ResourceBundle doGetBundle(String basename, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(basename, locale, this.getBundleClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageFormat getMessageFormat(ResourceBundle bundle, String code, Locale locale) throws MissingResourceException {
        Map map = this.cachedBundleMessageFormats;
        synchronized (map) {
            MessageFormat result;
            HashMap codeMap = (HashMap)this.cachedBundleMessageFormats.get(bundle);
            HashMap<Locale, MessageFormat> localeMap = null;
            if (codeMap != null && (localeMap = (HashMap<Locale, MessageFormat>)codeMap.get(code)) != null && (result = (MessageFormat)localeMap.get(locale)) != null) {
                return result;
            }
            String msg = this.getStringOrNull(bundle, code);
            if (msg != null) {
                if (codeMap == null) {
                    codeMap = new HashMap();
                    this.cachedBundleMessageFormats.put(bundle, codeMap);
                }
                if (localeMap == null) {
                    localeMap = new HashMap<Locale, MessageFormat>();
                    codeMap.put(code, localeMap);
                }
                MessageFormat result2 = this.createMessageFormat(msg, locale);
                localeMap.put(locale, result2);
                return result2;
            }
            return null;
        }
    }

    private String getStringOrNull(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public String toString() {
        return this.getClass().getName() + ": basenames=[" + StringUtils.arrayToCommaDelimitedString(this.basenames) + "]";
    }
}

