/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.wizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.EtchedBorder;
import org.freehep.swing.wizard.Finishable;
import org.freehep.swing.wizard.HasHelpPage;
import org.freehep.swing.wizard.HasNextPages;
import org.freehep.swing.wizard.WizardPage;

public class WizardDialog
extends JDialog
implements ActionListener {
    private CardLayout m_layout;
    private Container m_contentPane;
    private Cursor m_default = Cursor.getDefaultCursor();
    private Cursor m_wait = new Cursor(3);
    private WizardPage m_firstPage;
    private JPanel m_wizardPagePanel;
    private JRootPane m_rootPane;
    private WizardPage m_currentPage;
    private JButton m_cancel;
    private JButton m_finish;
    private JButton m_help;
    private JButton m_next;
    private JButton m_prev;
    private boolean m_currentPageHasAmbiguousDefault;

    public WizardDialog(String title, WizardPage firstPage) {
        this.setTitle(title);
        this.init(firstPage);
    }

    public WizardDialog(Frame owner, String title, WizardPage firstPage) {
        super(owner, title, true);
        this.init(firstPage);
    }

    public WizardDialog(Dialog owner, String title, WizardPage firstPage) {
        super(owner, title, true);
        this.init(firstPage);
    }

    private void init(WizardPage firstPage) {
        this.m_contentPane = this.getContentPane();
        this.m_contentPane.setLayout(new BorderLayout());
        this.m_rootPane = this.getRootPane();
        this.m_layout = new CardLayout();
        this.m_wizardPagePanel = new JPanel(this.m_layout);
        firstPage.addTo(this.m_wizardPagePanel, this, null);
        JPanel buttons = new JPanel(new FlowLayout());
        this.m_cancel = new JButton("Cancel");
        buttons.add(this.m_cancel);
        this.m_cancel.setMnemonic('C');
        this.m_help = new JButton("Help");
        buttons.add(this.m_help);
        this.m_help.setMnemonic('H');
        this.m_prev = new JButton("<< Previous");
        buttons.add(this.m_prev);
        this.m_prev.setMnemonic('P');
        this.m_next = new JButton("Next >>");
        buttons.add(this.m_next);
        this.m_next.setMnemonic('N');
        this.m_finish = new JButton("Finish");
        buttons.add(this.m_finish);
        this.m_finish.setMnemonic('F');
        this.m_wizardPagePanel.setBorder(new EtchedBorder());
        this.m_contentPane.add("Center", this.m_wizardPagePanel);
        this.m_contentPane.add("South", buttons);
        this.m_layout.first(this.m_wizardPagePanel);
        this.m_currentPage = this.m_firstPage = firstPage;
        this.m_firstPage.doEnable();
        this.m_cancel.addActionListener(this);
        this.m_help.addActionListener(this);
        this.m_prev.addActionListener(this);
        this.m_next.addActionListener(this);
        this.m_finish.addActionListener(this);
        this.m_currentPageHasAmbiguousDefault = this.m_currentPage.isFinishable() && this.m_currentPage.hasNextPages();
        this.m_help.setEnabled(firstPage instanceof HasHelpPage);
        this.setResizable(false);
        this.enableEvents(64L);
        firstPage.beforeShowing();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_cancel) {
            this.onCancel();
        } else if (source == this.m_help) {
            this.onHelp();
        } else if (source == this.m_prev) {
            this.onPrev();
        } else if (source == this.m_next) {
            this.onNext();
        } else if (source == this.m_finish) {
            this.onFinish();
        }
    }

    public void dispose() {
        this.m_firstPage.clear();
        WizardPage.pageNumber = 0;
        super.dispose();
    }

    public void processWindowEvent(WindowEvent e) {
        int id = e.getID();
        if (id == 201) {
            this.onCancel();
        } else if (id == 205) {
            this.setDefaultButton();
        }
    }

    protected void handleError(String message, Throwable t) {
        t.printStackTrace();
    }

    void setDefaultButton() {
        if (this.m_currentPageHasAmbiguousDefault && this.m_next.isEnabled()) {
            this.m_rootPane.setDefaultButton(this.m_next);
        } else if (this.m_currentPageHasAmbiguousDefault && this.m_finish.isEnabled()) {
            this.m_rootPane.setDefaultButton(this.m_finish);
        } else {
            this.m_rootPane.setDefaultButton(this.m_currentPage.hasNextPages() ? this.m_next : this.m_finish);
        }
    }

    void setFinishEnabled(boolean b) {
        this.m_finish.setEnabled(b && this.m_currentPage.isFinishable());
    }

    void setNextEnabled(boolean b) {
        this.m_next.setEnabled(b && this.m_currentPage.hasNextPages());
    }

    void setToDefaultCursor() {
        this.setCursor(this.m_default);
    }

    void setToWaitCursor() {
        this.setCursor(this.m_wait);
    }

    void doPrevEnabled() {
        this.m_prev.setEnabled(this.m_currentPage.getPrev() != null);
    }

    private void setToCurrentPage(WizardPage page) {
        this.m_currentPage = page;
        this.m_currentPageHasAmbiguousDefault = this.m_currentPage.isFinishable() && this.m_currentPage.hasNextPages();
        page.doEnable();
        if (!this.m_currentPageHasAmbiguousDefault) {
            this.setDefaultButton();
        }
        this.m_help.setEnabled(page instanceof HasHelpPage);
        page.beforeShowing();
        this.m_layout.show(this.m_wizardPagePanel, page.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCancel() {
        this.setToWaitCursor();
        try {
            try {
                this.m_firstPage.doCancel();
                this.dispose();
            }
            catch (Throwable t) {
                this.handleError("Error during wizard processing", t);
                Object var3_2 = null;
                this.setToDefaultCursor();
            }
            Object var3_1 = null;
            this.setToDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setToDefaultCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFinish() {
        this.setToWaitCursor();
        try {
            try {
                ((Finishable)((Object)this.m_currentPage)).onFinish();
                this.dispose();
            }
            catch (Throwable t) {
                this.handleError("Error during wizard processing", t);
                Object var3_2 = null;
                this.setToDefaultCursor();
            }
            Object var3_1 = null;
            this.setToDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setToDefaultCursor();
            throw throwable;
        }
    }

    private void onHelp() {
        this.setToWaitCursor();
        HasHelpPage h = (HasHelpPage)((Object)this.m_currentPage);
        this.setToDefaultCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNext() {
        this.setToWaitCursor();
        try {
            block5: {
                try {
                    WizardPage newPage = ((HasNextPages)((Object)this.m_currentPage)).getNext();
                    if (newPage == null) break block5;
                    if (!this.m_wizardPagePanel.isAncestorOf(newPage)) {
                        newPage.addTo(this.m_wizardPagePanel, this, this.m_currentPage);
                        newPage.invalidate();
                        this.validate();
                    }
                    this.setToCurrentPage(newPage);
                }
                catch (Throwable t) {
                    this.handleError("Error during wizard processing", t);
                    Object var3_4 = null;
                    this.setToDefaultCursor();
                }
            }
            Object var3_3 = null;
            this.setToDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.setToDefaultCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPrev() {
        this.setToWaitCursor();
        try {
            try {
                this.setToCurrentPage(this.m_currentPage.getPrev());
            }
            catch (Throwable t) {
                this.handleError("Error during wizard processing", t);
                Object var3_2 = null;
                this.setToDefaultCursor();
            }
            Object var3_1 = null;
            this.setToDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setToDefaultCursor();
            throw throwable;
        }
    }
}

