/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.freehep.swing.MachineGunButtonModel;

public class JSpinBox
extends JComponent {
    private int max = 100;
    private int min = 0;
    private int value = 0;
    private boolean valueChanging = false;
    private JTextField field;
    private JButton plus;
    private JButton minus;
    private Vector listener = new Vector();

    public JSpinBox(int init, int min, int max) {
        if (min < 0 || max < min || init < min || init > max) {
            throw new IllegalArgumentException("Invalid initial parameters for spin box");
        }
        this.value = init;
        this.min = min;
        this.max = max;
        this.plus = new JButton(new ImageIcon(this.getClass().getResource("images/plus.gif")));
        this.minus = new JButton(new ImageIcon(this.getClass().getResource("images/minus.gif")));
        this.valueChanging = true;
        this.field = new JTextField(new JSpinDocument(), String.valueOf(init), (int)(1.0 + Math.log(Math.abs(max)) / Math.log(10.0)));
        this.valueChanging = false;
        this.valueChanged();
        this.plus.setMargin(new Insets(0, 0, 0, 0));
        this.plus.setModel(new MachineGunButtonModel());
        this.minus.setMargin(new Insets(0, 0, 0, 0));
        this.minus.setModel(new MachineGunButtonModel());
        this.setLayout(new FlowLayout(1, 0, 0));
        JPanel p = new JPanel(new BorderLayout(0, 0));
        p.add("North", this.plus);
        p.add("South", this.minus);
        this.add(this.field);
        this.add(p);
        this.plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSpinBox.this.value++;
                JSpinBox.this.valueChanged();
            }
        });
        this.minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JSpinBox.this.value--;
                JSpinBox.this.valueChanged();
            }
        });
    }

    public void addActionListener(ActionListener l) {
        this.listener.addElement(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listener.removeElement(l);
    }

    private void fireActionListener() {
        ActionEvent event = new ActionEvent(this, 1001, "hi");
        Enumeration e = this.listener.elements();
        while (e.hasMoreElements()) {
            ((ActionListener)e.nextElement()).actionPerformed(event);
        }
    }

    private void valueChanged() {
        if (this.value > this.max) {
            this.value = this.max;
        }
        if (this.value < this.min) {
            this.value = this.min;
        }
        this.plus.setEnabled(this.value < this.max);
        this.minus.setEnabled(this.value > this.min);
        if (!this.valueChanging) {
            this.valueChanging = true;
            this.field.setText(String.valueOf(this.value));
            this.valueChanging = false;
        }
        this.fireActionListener();
    }

    public void setMin(int value) {
        this.min = value;
    }

    public void setMax(int value) {
        this.max = value;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.valueChanged();
    }

    public int getRepeatDelay() {
        MachineGunButtonModel model = (MachineGunButtonModel)this.plus.getModel();
        return model.getRepeatDelay();
    }

    public int getInitialDelay() {
        MachineGunButtonModel model = (MachineGunButtonModel)this.plus.getModel();
        return model.getInitialDelay();
    }

    public void setRepeatDelay(int delay) {
        MachineGunButtonModel model = (MachineGunButtonModel)this.plus.getModel();
        model.setRepeatDelay(delay);
        model = (MachineGunButtonModel)this.minus.getModel();
        model.setRepeatDelay(delay);
    }

    public void setInitialDelay(int delay) {
        MachineGunButtonModel model = (MachineGunButtonModel)this.plus.getModel();
        model.setInitialDelay(delay);
        model = (MachineGunButtonModel)this.minus.getModel();
        model.setInitialDelay(delay);
    }

    public void setEnabled(boolean enabled) {
        this.plus.setEnabled(enabled);
        this.minus.setEnabled(enabled);
        this.field.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    private class JSpinDocument
    extends PlainDocument
    implements Runnable {
        private JSpinDocument() {
        }

        public void insertString(int pos, String string, AttributeSet p3) throws BadLocationException {
            if (!JSpinBox.this.valueChanging) {
                int i = 0;
                while (i < string.length()) {
                    if (!Character.isDigit(string.charAt(i))) {
                        JSpinBox.this.getToolkit().beep();
                        return;
                    }
                    ++i;
                }
            }
            super.insertString(pos, string, p3);
            if (!JSpinBox.this.valueChanging) {
                int nValue = Integer.parseInt(JSpinBox.this.field.getText());
                if (nValue < JSpinBox.this.min || nValue > JSpinBox.this.max) {
                    super.remove(pos, string.length());
                    Thread.dumpStack();
                    JSpinBox.this.getToolkit().beep();
                    return;
                }
                JSpinBox.this.value = nValue;
                JSpinBox.this.valueChanging = true;
                JSpinBox.this.valueChanged();
                JSpinBox.this.valueChanging = false;
            }
        }

        public void remove(int pos, int len) throws BadLocationException {
            super.remove(pos, len);
            if (!JSpinBox.this.valueChanging) {
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            if (JSpinBox.this.field == null) {
                return;
            }
            String text = JSpinBox.this.field.getText();
            int nValue = text.length() == 0 ? Integer.MIN_VALUE : Integer.parseInt(JSpinBox.this.field.getText());
            if (nValue < JSpinBox.this.min) {
                nValue = JSpinBox.this.min;
                JSpinBox.this.getToolkit().beep();
                JSpinBox.this.field.setText(String.valueOf(nValue));
            }
            JSpinBox.this.value = nValue;
            JSpinBox.this.valueChanging = true;
            JSpinBox.this.valueChanged();
            JSpinBox.this.valueChanging = false;
        }
    }
}

