/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.application.PropertyUtilities;

public class AboutDialog
extends JDialog {
    private Application app;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public AboutDialog(Application app) {
        super((JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = AboutDialog.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, app));
        this.app = app;
        final Properties props = app.getUserProperties();
        final JPanel panel = new JPanel(new BorderLayout());
        URL image = PropertyUtilities.getURL(props, "aboutImage", null);
        if (image != null) {
            ImageIcon icon = new ImageIcon(image);
            JLabel l = new JLabel(icon);
            l.setBackground(Color.white);
            l.setOpaque(true);
            panel.add(l);
        } else {
            String text = props.getProperty("aboutLabel", "<html><h1>{title}</h1>");
            panel.add(new JLabel(text));
        }
        this.setTitle(app.getFullVersion());
        this.setModal(true);
        final JPanel info = this.createInfoPanel();
        if (info != null) {
            panel.add((Component)info, "East");
        }
        info.setVisible(PropertyUtilities.getBoolean(props, "aboutShowInfoPanel", true));
        AbstractAction toggleInfoPanel = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (info != null) {
                    PropertyUtilities.setBoolean(props, "aboutShowInfoPanel", !info.isVisible());
                    info.setVisible(!info.isVisible());
                    if (!info.isVisible()) {
                        panel.requestFocus();
                    }
                    AboutDialog.this.pack();
                }
            }
        };
        panel.getInputMap(0).put(KeyStroke.getKeyStroke(80, 2), "toggleInfoPanel");
        panel.getInputMap(2).put(KeyStroke.getKeyStroke(80, 2), "toggleInfoPanel");
        panel.getActionMap().put("toggleInfoPanel", toggleInfoPanel);
        this.setContentPane(panel);
        this.setResizable(false);
    }

    protected JPanel createInfoPanel() {
        return new InfoPanel();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class InfoPanel
    extends JPanel
    implements ActionListener {
        private JButton b1;
        private JButton b2;
        private JButton b3;

        public InfoPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Properties"));
            this.setLayout(new BorderLayout());
            JPanel p = new JPanel(new GridLayout(0, 1));
            this.b1 = new JButton("System...");
            this.b2 = new JButton("Application...");
            this.b3 = new JButton("User...");
            try {
                System.getProperties();
            }
            catch (SecurityException x) {
                this.b1.setEnabled(false);
            }
            this.b1.addActionListener(this);
            this.b2.addActionListener(this);
            this.b3.addActionListener(this);
            p.add(this.b1);
            p.add(this.b2);
            p.add(this.b3);
            this.add((Component)p, "North");
        }

        public void actionPerformed(ActionEvent e) {
            JButton source = (JButton)e.getSource();
            Properties prop = source == this.b1 ? System.getProperties() : (source == this.b2 ? AboutDialog.this.app.getAppProperties() : AboutDialog.this.app.getUserProperties());
            JTable table = new JTable(new PropertyUtilities.PropertyTable(prop));
            String title = source.getText();
            if (title.endsWith("...")) {
                title = title.substring(0, title.length() - 3);
            }
            title = title + " Properties";
            JDialog dlg = new JDialog((Dialog)AboutDialog.this, title);
            dlg.setContentPane(new JScrollPane(table));
            dlg.setModal(true);
            dlg.pack();
            dlg.setLocationRelativeTo(AboutDialog.this);
            dlg.show();
        }
    }
}

