<?php
/*---------------------------------------------------+
| LightNEasy Content Management System
| Copyright 2007 - 2010 Fernando Baptista
| http://www.lightneasy.org
+----------------------------------------------------+
| Common functions module common.php
| Version 3.2.1 SQLite/MySQL
+----------------------------------------------------+
| Released under the terms & conditions of v2 of the
| GNU General Public License. For details refer to
| the included gpl.txt file or visit http://gnu.org
+----------------------------------------------------*/
# This module contains the common functions

// LightNEasy version
$LNEversion="3.2.1";

function clean($string) {
	return trim(str_replace('&nbsp;',' ',$string));
}

function data_formatada($unix_time){
	global $set, $fuso_s;
		return strftime($set['dateformat'], $unix_time + $fuso_s);
}

function decode($string) {
	return html_entity_decode(utf8_decode(stripslashes($string)));
}

function encode($string) {
	return utf8_encode(htmlentities($string));
}

function expmenu($generat) {
	global $pagenum,$menu,$selected,$set;
	$count=0;
	$aa="\n";
	while($menu[$count][0] != "") {
		if(($menu[$count][1]=="0" && $menu[$count][2]=="0" || $menu[$count][0]==$selected['index']) &&	strpos($menu[$count][3], "_") === false) {
			$aa.='<li';
			if($menu[$count][2]!="0") $aa.=" class=\"LNE_menu_doubleintend\"";
			elseif($menu[$count][1]!="0") $aa.=" class=\"LNE_menu_intend\"";
			else $aa.=" class=\"LNE_menu\"";
			$aa.="><a ";
			if($menu[$count][4]==$selected['name']) $aa.='class="selected" ';
			if(strpos($menu[$count][3],"*")) $aa.='href="'.str_replace("*", "",$menu[$count][3]).'">';
			else
				if($generat) $aa.='href="'.$menu[$count][3].'.php">';
				else $aa.='href="'.$set['indexfile'].'?page='.$menu[$count][3].'">';
			$aa.=$menu[$count][4]."</a></li>\n";
		}
		$count++;
	}
	return $aa;
}

function filelist($pattern, $start_dir='.', $dir=0) {
$filenames=array();
if ($handle = opendir($start_dir)) {
	while (false !== ($file = readdir($handle))) {
		if (strcmp($file, '.')==0 || strcmp($file, '..')==0) continue;
		if($dir) {
			if(is_dir($start_dir."/".$file))
				array_push($filenames, $file);
		} else
			array_push($filenames, $file);
	}
	closedir($handle);
}
//$order=-1;
$filesort = create_function('$a,$b', "\$a1=\$a$sortby;\$b1=\$b$sortby; if (\$a1==\$b1) return 0; else return (\$a1<\$b1) ? -1 : 1;");
uasort($filenames, $filesort);
return $filenames;
}

function fullmenu($generat=0) {
       global $pagenum, $menu, $selected, $extension, $set;
       $count=0;
       $out="\n";
       while($menu[$count][0] != "") {
// Bugfix by Jochen Wendel
               if(strpos($menu[$count][3],"#") === false && $menu[$count][0] != "0") {
               $out.='<li';
               if($menu[$count][2]!="0")
                       $out.=" class=\"LNE_menu_doubleintend\"";
               elseif($menu[$count][1]!="0")
                       $out.=" class=\"LNE_menu_intend\"";
               else
                       $out.=" class=\"LNE_menu\"";
               $out.="><a ";
               if($menu[$count][4]==$selected['name'])
                       $out.= 'class="selected" ';
               if(strpos($menu[$count][3],"*"))
                       $out.='href="'.str_replace("*", "",$menu[$count][3]).'">';
               elseif($generat)
                       $out.='href="'.$menu[$count][3].'.php>"';
               else
                       $out.='href="'.$set['indexfile'].'?page='.$menu[$count][3].'">';
               $out.=$menu[$count][4]."</a></li>\n";
               }
               $count++;
       }
       return $out;
}

function is_intval($value) {
     return 1 === preg_match('/^[+-]?[0-9]+$/', $value);
}

function login() {
	global $message, $set, $langmessage, $prefix;
	if($_SESSION[$set['password']]!="1") {
	if($_GET['do']=="login" && $_POST['handle']!="") {
		$result=dbquery('SELECT * FROM '.$prefix.'users WHERE handle="'.$_POST['handle'].'"');
		if($row = fetch_array($result)) {
			if($row['password'] == sha1($_POST['password'])) {
				//inserts password in cookie
				setcookie('userpass', sha1(trim($_POST['password'])), time() + 60 * 60 * 24 * 30);
				setcookie('userhandle', $_POST['handle'], time() + 60 * 60 * 24 * 30);
				$_SESSION[$set['password']]="1";
				$_SESSION['user']=$row['handle'];
				$_SESSION['adminlevel']=$row['adminlevel'];
				$message=$langmessage[95];
				unset($_GET['do']);
				header("Location: ".$set['homepath']);
			} else
				$message=$langmessage[96];
		} else
			$message=$langmessage[96];
	} else {
		//Checks if there is a login cookie from past session
		if ($_COOKIE['userhandle'] != "") {
			$result=dbquery('SELECT * FROM '.$prefix.'users WHERE handle="'.$_COOKIE['userhandle'].'"');
			if($row = fetch_array($result)) {
				if($row['password'] == $_COOKIE['userpass']) {
					$_SESSION[$set['password']]="1";
					$_SESSION['user']=$_COOKIE['userhandle'];
					$_SESSION['adminlevel']=$row['adminlevel'];
					$message="Ah, pois!";
					header("Location: ".$set['homepath']);
				}
			}
		}
	}
	}
}

function loginform() {
//Called by $#loginform#$, prints a login form in the template. Alternative to $#login#$.
	global $langmessage, $LNEversion, $set;
    if ($_SESSION[$set['password']]=="1") {
		$out="\n<form style=\"margin-left: 12px;\" name=\"form1\" id=\"form1\" method=\"get\" action=\"".$set['homepath'].$set['indexfile']."\" />\n";
		$out.=$langmessage[31]." <a href=\"?do=profile\">".$_SESSION['user']."</a>\n";
		$out.="<input name=\"do\" value=\"logout\" type=\"hidden\" />\n";
		$out.="<input type=\"submit\" name=\"\" value=\"$langmessage[121]\" />\n";
		$out.="</form>\n";
	} else {
		$out='<div align="center"><h2>'.$langmessage[120].'</h2>';
		$out.='<form name="form1" id="form1" method="post" action="'.$set['homepath'].$set['indexfile'].'?do=login" />';
		$out.='<table><tr><td>'.$langmessage[155].'</td><td><input name="handle" type="text" size="8" maxlength="20" /></td></tr>';
		$out.='<tr><td>'.$langmessage[6].'</td><td><input name="password" type="password" size="8" maxlength="20" /></td></tr>';
		$out.='<tr><td><input type="hidden" name="do" value="login" /></td>';
		$out.="<td><input type=\"submit\" name=\"\" value=\"$langmessage[120]\" /></td></tr></table>\n";
		$out.="</form>\n</div>\n";
	}
	return $out;
}

function loginout() {
//prints the login/logout link
	global $set,$langmessage;
	if($_SESSION[$set['password']]=="1")
		return "<a href=\"?do=profile\">".$_SESSION['user']."</a> | <a href=\"".$set['homepath'].$set['indexfile']."?do=logout\">$langmessage[121]</a>";
	else
		return "<a href=\"".$set['homepath'].$set['indexfile']."?do=login\" rel=\"nofollow\">$langmessage[120]</a>";
}

function logout() {
	global $set, $message;
	unset($_SESSION['user']);
	unset($_SESSION[$set['password']]);
	unset($_SESSION['adminlevel']);
	session_destroy();
	setcookie('userhandle', "", time() - 600);
	setcookie('userpass', "", time() - 600);
	unset($_GET['do']);
	header("Location: ".$set['homepath']);
	$message="you were logged out";
}

function mainmenu($generat, $span=0) {
	global $pagenum,$menu,$selected,$set;
	$aa="\n";
	$count=0;
	$first=true;
	while($menu[$count][0] != "") {
		if($menu[$count][1]=="0" && $menu[$count][2]=="0" && strpos($menu[$count][3],"#") === false) {
			$aa.='<li';
			if($first) {
				$first=false;
				$aa.=' class="first"';
			}
			$aa.='>';
			if($span==3) $aa.="<span>";
			$aa.='<a ';
			if($menu[$count][0]==$selected['index'])
				$aa.='class="selected" ';
			if(strpos($menu[$count][3],"*"))
				$aa.='href="'.str_replace("*", "",$menu[$count][3]).'">';
			else
				if($generat)
					$aa.='href="'.$menu[$count][3].'.php">';
				else
					$aa.='href="'.$set['indexfile'].'?page='.$menu[$count][3].'">';
			if($span==2) $aa.="<span>";
			$aa.=$menu[$count][4];
			if($span==1) $aa.="<span>";
			if($span==2 || $span==1) $aa.="</span>";
			$aa.="</a>";
			if($span==3) $aa.="</span>";
			$aa.="</li>\n";
		}
		$count++;
	}
	return $aa;
}

function profile() {
	global $set, $langmessage, $prefix;
	$out = "<h2>$langmessage[165]</h2>\n";
	$result=dbquery('SELECT * FROM '.$prefix.'users WHERE handle="'.$_COOKIE['userhandle'].'"');
	if($row = fetch_array($result)) {
		$out.="<form name=\"form1\" id=\"form1\" method=\"post\" action=\"\" />\n<fieldset style=\"border: none;\">\n";
		$out.="<table style=\"border: none; padding: 4px;\">\n<tr><td>".$langmessage[155]."</td><td><input name=\"handle\" type=\"hidden\" value=\"".$row['handle']."\" /><b>".$row['handle']."</b></td></tr>\n";
		$out.='<tr><td>'.$langmessage[6]."</td><td><input name=\"password\" type=\"password\" size=\"20\" maxlength=\"20\" value=\"\" /></td></tr>\n";
		$out.='<tr><td>'.$langmessage[156]."</td><td><input name=\"repeatpassword\" type=\"password\" size=\"20\" maxlength=\"20\" value=\"\" /></td></tr>\n";
		$out.='<tr><td>'.$langmessage[158].'</td><td><input name="email" type="text" size="20" maxlength="50" value="'.$row['email']."\" /></td></tr>\n";
		$out.='<tr><td>'.$langmessage[166].'</td><td><input name="firstname" type="text" size="20" maxlength="50" value="'.$row['firstname']."\" /></td></tr>\n";
		$out.='<tr><td>'.$langmessage[167].'</td><td><input name="lastname" type="text" size="20" maxlength="50" value="'.$row['lastname']."\" /></td></tr>\n";
		$out.='<tr><td>'.$langmessage[168].'</td><td><input name="website" type="text" size="20" maxlength="50" value="'.$row['website']."\" /></td></tr>\n";
		$out.='<tr><td>'.$langmessage[169].'</td><td><input name="location" type="text" size="20" maxlength="50" value="'.$row['location']."\" /></td></tr>\n";
		$out.="<tr><td><input type=\"hidden\" name=\"submit\" value=\"saveprofile\" />\n";
		$out.="<input type=\"hidden\" name=\"userid\" value=\"".$row['id']."\" /></td>\n";
		$out.="<td><input type=\"submit\" name=\"aaa\" value=\"$langmessage[82]\" /></td></tr>\n</table>\n";
		$out.="</fieldset></form>\n";
	}
	return $out;
}

function readmenu() {
	global $menu,$pagenum,$selected, $prefix;
	unset($men);
	$menu=array();
	$result = dbquery("SELECT * FROM ".$prefix."menu ORDER BY m1 ASC, m2 ASC, m3 ASC");
	$count=0;
	while($men=fetch_array($result)) {
		$result1 = dbquery("SELECT * FROM ".$prefix."paginas WHERE page=\"".$men[3]."\"");
		$row1=fetch_array($result1);
		$men['nome']=decode($men['nome']);
		if(intval($_SESSION['adminlevel'])>=$row1['restricted']) {
			$menu[$count]=$men;
			if($menu[$count][3]==$pagenum) {
				$selected['index']=$men['m1'];
				$selected['m2']=$men['m2'];
				$selected['m3']=$men['m3'];
				$selected['link']=$men['page'];
				$selected['name']=$men['nome'];
				$selected['description']=decode($row1['description']);
				$selected['template']=$row1['template'];
			}
			$count++;
		}
	}
}

function readsetup() {
	global $set, $fuso_s, $prefix;
	$query="SELECT * FROM ".$prefix."settings";
	if(!$result=dbquery($query)) die ("Error - Could not read the settings");
	$set=fetch_array($result);
	$set['title']=decode($set['title']);
	$set['subtitle']=decode($set['subtitle']);
	$set['keywords']=decode($set['keywords']);
	$set['description']=decode($set['description']);
	$set['author']=decode($set['author']);
	$set['footer']=decode($set['footer']);
	$fuso_s = intval($set['timeoffset']) * 3600;
}

function restrictedpage ($level) {
	global $langmessage;
	$out = "<h2>$langmessage[146]</h2>\n";
	if($level<4)
		$out.= "<h4>$langmessage[147]</h4>\n";
	else
		$out.= "<h4>$langmessage[164]</h4>\n";
	return $out;
}

function sanitize($text) {
	// Convert problematic ascii characters to their true values
	$search = array("40","41","58","65","66","67","68","69","70",
		"71","72","73","74","75","76","77","78","79","80","81",
		"82","83","84","85","86","87","88","89","90","97","98",
		"99","100","101","102","103","104","105","106","107",
		"108","109","110","111","112","113","114","115","116",
		"117","118","119","120","121","122"
		);
	$replace = array("(",")",":","a","b","c","d","e","f","g","h",
		"i","j","k","l","m","n","o","p","q","r","s","t","u",
		"v","w","x","y","z","a","b","c","d","e","f","g","h",
		"i","j","k","l","m","n","o","p","q","r","s","t","u",
		"v","w","x","y","z"
		);
	$entities = count($search);
	for ($i=0;$i < $entities;$i++) $text = preg_replace("#(&\#)(0*".$search[$i]."+);*#si", $replace[$i], $text);
	// the following is based on code from bitflux (http://blog.bitflux.ch/wiki/)
	// Kill hexadecimal characters completely
	$text = preg_replace('#(&\#x)([0-9A-F]+);*#si', "", $text);
	// remove any attribute starting with "on" or xmlns
	$text = preg_replace('#(<[^>]+[\\"\'\s])(onmouseover|onmousedown|onmouseup|onmouseout|onmousemove|onclick|ondblclick|onload|xmlns)[^>]*>#iU', ">", $text);
	do {
		$oldtext = $text;
		preg_replace('#</*(applet|meta|xml|blink|link|style|script|embed|object|iframe|frame|frameset|ilayer|layer|bgsound|title|base)[^>]*>#i', "", $text);
	// remove javascript: and vbscript: protocol
	} while ($oldtext != $text);
	$text = preg_replace('#([a-z]*)=([\`\'\"]*)script:#iU', '$1=$2nojscript...', $text);
	$text = preg_replace('#([a-z]*)=([\`\'\"]*)javascript:#iU', '$1=$2nojavascript...', $text);
	$text = preg_replace('#([a-z]*)=([\'\"]*)vbscript:#iU', '$1=$2novbscript...', $text);
	$text = preg_replace('#(<[^>]+)style=([\`\'\"]*).*expression\([^>]*>#iU', "$1>", $text);
	$text = preg_replace('#(<[^>]+)style=([\`\'\"]*).*behaviour\([^>]*>#iU', "$1>", $text);
	return $text;
}

function saveprofile() {
	global $message, $prefix;
	if(!is_intval($_POST['userid'])) die ("aha! Naughty!");
	$handle=sanitize($_POST['handle']);
	$password=sanitize($_POST['password']);
	$repeatpassword=sanitize($_POST['repeatpassword']);
	$email=sanitize($_POST['email']);
	$firstname=sanitize($_POST['firstname']);
	$lastname=sanitize($_POST['lastname']);
	$website=sanitize($_POST['website']);
	$location=sanitize($_POST['location']);
	$query="UPDATE ".$prefix."users SET email=\"$email\", firstname=\"$firstname\", lastname=\"$lastname\", handle=\"$handle\", website=\"$website\", location=\"$location\"";
	if($_POST['password']!="") {
		if($_POST['password']==$_POST['repeatpassword'])
			$query.=", password=\"".sha1($_POST['password'])."\"";
		else
			$message="Passwords don't match";
	}
	$query.="  WHERE id=".$_POST['userid'];
	dbquery($query);
}

function showsitemap($langmessage,$gen) {
	$out="<h2>$langmessage[88]</h2>\n<br />\n";
	$out.="<ul>".fullmenu($gen)."</ul>\n";
	return $out;
}

function submenu($generat) {
	global $pagenum,$menu,$selected, $set;
	$count=0;
	while($menu[$count][0] != "") {
		if($menu[$count][3]==$pagenum) {
			$m1=$menu[$count][0];
			$m2=$menu[$count][1];
			$m3=$menu[$count][2];
			if($m3) $sub=3; else
			if($m2) $sub=2; else $sub=1;
			break;
		}
		$count++;
	}
	$count=0;
	$out="\n";
	while($menu[$count][0] != "") {
		if(strpos($menu[$count][3], "_") === false) {
		if($menu[$count][0]==$m1 && ($menu[$count][1]!="0" || $menu[$count][2]!="0")) {
			if (($sub==1 && $menu[$count][2]==0) || 
				($sub==2 && $menu[$count][0]==$m1 && ($menu[$count][1]==$m2 || $menu[$count][2]=="0")) || 
				($sub==3 && $menu[$count][1]==$m2 && $menu[$count][0]==$m1)) {
				$out.='<li><a ';
				if($menu[$count][4]==$selected['name'])
					$out.='class="selected" ';
				if(strpos($menu[$count][3],"*"))
					$out.='><a href="'.str_replace("*", "",$menu[$count][3]).'">'.$menu[$count][4]."</a></li>\n";
				else
					if($generat)
						$out.='href="'.$menu[$count][3].'.php">'.$menu[$count][4]."</a></li>\n";
					else
						$out.='href="'.$set['indexfile'].'?page='.$menu[$count][3].'">'.$menu[$count][4]."</a></li>\n";
			}
		}
		}
		$count++;
	}
	return $out;
}

//for compability with earlier php versions
function sv($s) {
	if (!isset($_SERVER)) {
		global $_SERVER;
		$_SERVER = $GLOBALS['HTTP_SERVER_VARS'];
	}
	if (isset($_SERVER[$s]))return $_SERVER[$s];
	else return'';
}

function treemenu($generat=0) {
    global $pagenum, $menu, $selected, $extension, $set;
    $replace_chars=array(" ", ",", ".", "/", "?", "!", "-", ";", "'");
//    $out='<ul class="menu2">'."\n";
    $intend=0;
    for($count=0;$menu[$count][0] != "";$count++) {
        #$out.='mira-intend'.$intend.'mira-changed'.$changed.'mira-count'.$count.'menudecountuno'.$menu[$count][1];
        $changed=false;
        if($menu[$count][1]!="0" && $intend<1) {
            $changed=true;
            $intend=1;
            $out.='<ul class="sub">'."\n";
        }
        if($menu[$count][2]!="0" && $intend<2) {
            $changed=true;
            $intend=2;
            $out.="<ul>"."\n";
        }
        if($menu[$count][2]=="0" && $intend==2) {
            $changed=true;
            $intend--;
            $out.="</ul></li>"."\n";
        }
        if($menu[$count][1]=="0" && $intend==1) {
            $changed=true;
            $intend--;
            $out.="</ul></li>"."\n";
        }
        if($menu[$count][1]=="0" && $menu[$count][2]=="0") {
            $out.='<li class="top"><a class="top_link" id="'.str_replace($replace_chars, "_", $menu[$count][4]).'" ';
        }
        else {
            if($menu[$count][2]=="0" && $menu[$count][1]==$menu[$count+1][1]) {
                $out.='<li><a class="fly" ';
            }
            else {
                $out.="<li><a ";
            }
        }
        #if($menu[$count][4]==$selected['name'])
        #   $out.= 'class="selected" ';
        if(strpos($menu[$count][3],"*"))
            $out.='href="'.str_replace("*", "",$menu[$count][3]).'">';
        elseif($generat)
            $out.='href="'.$menu[$count][3].'.php">';
        else
            $out.='href="'.$set['indexfile'].'?page='.$menu[$count][3].'">';
        if($menu[$count][1]=="0" && $menu[$count][2]=="0") {
            if($menu[$count][0]==$menu[$count+1][0]) {
                $out.='<span class="down">'.$menu[$count][4]."</span></a>"."\n";
            }
            else {
                $out.="<span>".$menu[$count][4]."</span></a></li>"."\n";
            }
        }
        else {
            if($menu[$count][2]=="0" && $menu[$count][1]==$menu[$count+1][1]) {
                $out.=$menu[$count][4]."</a>"."\n";
            }
            else {
                $out.=$menu[$count][4]."</a></li>"."\n";
            }
        }
    }
    if($intend==1) {    
        $out.="</ul>";
    }
//    $out.="</ul>";
    return $out;
}

function db_changes() {
	global $MySQL, $sqldbdb;
	if($MySQL==1) {
		return mysql_affected_rows($sqldbdb);
	} elseif($MySQL==0) {
		return sqlite_changes($sqldbdb);
	} else {
		return $sqldbdb->changes();
	}
}

function num_rows($result) {
	global $MySQL;
	if($MySQL==1) {
		return mysql_num_rows($result);
	} elseif($MySQL==0) {
		return sqlite_num_rows($result);
	} else {
		for($i = 0; fetch_array($result); $i++);
		$result->reset();
		return $i;
	}
}

function fetch_all($result) {
	for($i = 0; $array[$i] = fetch_array($result); $i++);
	array_pop($array);
	return $array;
}

function fetch_array($result) {
	global $MySQL;
	if($MySQL==1) {
		return mysql_fetch_array($result);
	} elseif($MySQL==0) {
		return sqlite_fetch_array($result);
	} else {
		return $result->fetchArray();
	}
}

function opendb() {
	global $MySQL, $prefix;
	require_once "data/database.php";
	if($MySQL==1) {
		$a = @mysql_connect($databasehost, $databaselogin, $databasepassword) or die("Error - Could not connect to MySQL server: " . mysql_error());
		@mysql_select_db($databasename) or die("Error - Could not open database " . mysql_error());
	} elseif($MySQL==0) {
		if(!$a = @sqlite_open("./data/$databasename.db")) die ("Error - Could not open database");
	} else {
		if(!$a= new SQLite3("./data/$databasename.db")) die ("Couldn't open SQLite 3 database");
	}
	return $a;
}

function dbquery($query) {
	global $sqldbdb, $MySQL;
	if($MySQL) {
		$result = @mysql_query($query,$sqldbdb) or die($query." ".mysql_error());
		return $result;
	} elseif($MySQL==0) {
		$result = @sqlite_query($sqldbdb,$query);
		if (!$result) {
			print $query.sqlite_error_string(sqlite_last_error($sqldbdb));
			return false;
		} else return $result;
	} else {
		$result = $sqldbdb->query($query);
		if (!$result) {
			echo $query." ".$sqldbdb->lastErrorMsg();
			return false;
		} else {
			return $result;
		}
	}
}

//replacement for PHP5 function http_build_query() if that function doesn't exist
//taken from the PHP online manual
if(!function_exists('http_build_query')) {
    function http_build_query($data,$prefix=null,$sep='',$key='') {
        $ret    = array();
            foreach((array)$data as $k => $v) {
                $k    = urlencode($k);
                if(is_int($k) && $prefix != null) {
                    $k    = $prefix.$k;
                };
                if(!empty($key)) {
                    $k    = $key."[".$k."]";
                };

                if(is_array($v) || is_object($v)) {
                    array_push($ret,http_build_query($v,"",$sep,$k));
                }
                else {
                    array_push($ret,$k."=".urlencode($v));
                };
            };

        if(empty($sep)) {
            $sep = ini_get("arg_separator.output");
        };

        return    implode($sep, $ret);
    };
};

?>