/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.stats;

import com.lavans.util.BaseClass;
import com.lavans.util.MethodUtil;
import com.lavans.util.jdbc.stats.StatsRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Statistics
extends BaseClass {
    private Map sqlMap = new HashMap();
    private static Statistics instance = new Statistics();

    private Statistics() {
    }

    public static Statistics getInstance() {
        return instance;
    }

    public void addData(String sql, long costTime, String classname) {
        StatsRecord record = (StatsRecord)this.sqlMap.get(sql);
        if (record == null) {
            record = new StatsRecord();
            this.sqlMap.put(sql, record);
            record.setSql(sql);
        }
        record.callCountUp();
        record.addTotalCostTime(costTime);
        String method = MethodUtil.getMethodName(classname);
        record.addMethodNames(method);
    }

    public List getStatInfoByTotal() {
        return this.getStatInfoByTotal(0, this.sqlMap.size());
    }

    public List getStatInfoByTotal(int fromIndex, int toIndex) {
        ArrayList list = new ArrayList(this.sqlMap.values());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                int result = -1;
                StatsRecord r1 = (StatsRecord)o1;
                StatsRecord r2 = (StatsRecord)o2;
                if (r1.getTotalCostTime() < r2.getTotalCostTime()) {
                    result = 1;
                } else if (r1.getTotalCostTime() == r2.getTotalCostTime()) {
                    result = 0;
                }
                return result;
            }
        });
        return list.subList(fromIndex, toIndex);
    }

    public List getStatInfoByAverage() {
        return this.getStatInfoByAverage(0, this.sqlMap.size());
    }

    public List getStatInfoByAverage(int fromIndex, int toIndex) {
        ArrayList list = new ArrayList(this.sqlMap.values());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                int result = -1;
                StatsRecord r1 = (StatsRecord)o1;
                StatsRecord r2 = (StatsRecord)o2;
                if (r1.getAverage() < r2.getAverage()) {
                    result = 1;
                } else if (r1.getAverage() == r2.getAverage()) {
                    result = 0;
                }
                return result;
            }
        });
        return list.subList(fromIndex, toIndex);
    }
}

