/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.bind;

import com.lavans.util.Logger;
import com.lavans.util.jdbc.bind.BindPreparedStatement;
import com.lavans.util.jdbc.logging.Loggable;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class BindPreparedStatementImpl
implements BindPreparedStatement {
    private PreparedStatement st = null;
    private String sql = null;
    private Map paramMap = null;
    private static final String REMOVE_SINGLEQUOTE = "__remove_singlequote__";
    private static final String REMOVE_DOUBLECOLON = "__remove_doublecolon__";
    private static Logger logger = Logger.getInstance();

    public BindPreparedStatementImpl(Connection con, String sql) throws SQLException {
        logger.enteringTool();
        logger.debugTool(sql);
        this.paramMap = new HashMap();
        List squoteList = this.removeSQuote(sql);
        logger.debugTool("SQuote end." + this.sql);
        this.sql = this.sql.replaceAll("::", REMOVE_DOUBLECOLON);
        logger.debugTool(":: end." + this.sql);
        this.transBindName();
        logger.debugTool(this.sql);
        this.putSQuote(squoteList);
        logger.debugTool("PUT SQuote end." + this.sql);
        this.sql = this.sql.replaceAll(REMOVE_DOUBLECOLON, "::");
        logger.debugTool("\u5b8c\u4e86\n" + this.sql);
        this.st = con.prepareStatement(this.sql);
        if (this.st instanceof Loggable) {
            ((Loggable)((Object)this.st)).setLogsql(sql);
        }
        logger.exitingTool();
    }

    private List removeSQuote(String sql) {
        logger.enteringTool();
        ArrayList<String> removeList = new ArrayList<String>();
        StringBuffer buf = new StringBuffer(sql.length());
        int crnt = 0;
        int from = 0;
        int to = 0;
        while (sql.indexOf("'", crnt) != -1) {
            from = sql.indexOf("'", crnt);
            to = sql.indexOf("'", from + 1) + 1;
            removeList.add(sql.substring(from, to));
            logger.debugTool(sql.substring(from, to));
            buf.append(sql.substring(crnt, from));
            buf.append(REMOVE_SINGLEQUOTE);
            logger.debugTool(buf.toString());
            crnt = to;
        }
        buf.append(sql.substring(crnt, sql.length()));
        logger.debugTool(buf.toString());
        this.sql = buf.toString();
        logger.exitingTool();
        return removeList;
    }

    private void putSQuote(List list) {
        logger.enteringTool();
        StringBuffer buf = new StringBuffer(this.sql.length());
        int crnt = 0;
        int from = 0;
        int i = 0;
        while (i < list.size()) {
            from = this.sql.indexOf(REMOVE_SINGLEQUOTE, crnt);
            buf.append(this.sql.substring(crnt, from));
            logger.debugTool(this.sql.substring(crnt, from));
            buf.append((String)list.get(i));
            crnt = from + REMOVE_DOUBLECOLON.length();
            logger.debugTool(buf.toString());
            ++i;
        }
        buf.append(this.sql.substring(crnt, this.sql.length()));
        logger.debugTool(buf.toString());
        logger.exitingTool();
        this.sql = buf.toString();
    }

    private void transBindName() {
        StringTokenizer token = new StringTokenizer(this.sql, ":");
        int tokenCount = token.countTokens();
        StringBuffer buf = new StringBuffer(this.sql.length());
        buf.append(token.nextToken());
        int i = 1;
        while (i < tokenCount) {
            String param = token.nextToken(")=, \t\r\n").substring(1);
            ArrayList<Integer> paramNums = (ArrayList<Integer>)this.paramMap.get(param);
            if (paramNums == null) {
                paramNums = new ArrayList<Integer>(2);
                this.paramMap.put(param, paramNums);
            }
            paramNums.add(new Integer(i));
            String nextStr = "";
            try {
                nextStr = token.nextToken(":");
            }
            catch (Exception exception) {
                // empty catch block
            }
            buf.append("?" + nextStr);
            ++i;
        }
        this.sql = buf.toString();
    }

    public void setString(String key, String x) throws SQLException {
        List paramNums = (List)this.paramMap.get(key);
        if (paramNums == null) {
            throw new SQLException("No such key [" + key + "]");
        }
        int i = 0;
        while (i < paramNums.size()) {
            Integer num = (Integer)paramNums.get(i);
            this.st.setString(num, x);
            logger.debugTool("[" + num + "]:" + key + "[" + x + "]");
            ++i;
        }
    }

    public void setInt(String key, int x) throws SQLException {
        List paramNums = (List)this.paramMap.get(key);
        if (paramNums == null) {
            throw new SQLException("No such key [" + key + "]");
        }
        int i = 0;
        while (i < paramNums.size()) {
            Integer num = (Integer)paramNums.get(i);
            this.st.setInt(num, x);
            logger.debugTool("[" + num + "]:" + key + "[" + x + "]");
            ++i;
        }
    }

    public void setByte(String key, byte x) throws SQLException {
        List paramNums = (List)this.paramMap.get(key);
        if (paramNums == null) {
            throw new SQLException("No such key [" + key + "]");
        }
        int i = 0;
        while (i < paramNums.size()) {
            Integer num = (Integer)paramNums.get(i);
            this.st.setByte(num, x);
            ++i;
        }
    }

    public void setFloat(String key, float x) throws SQLException {
        List paramNums = (List)this.paramMap.get(key);
        if (paramNums == null) {
            throw new SQLException("No such key [" + key + "]");
        }
        int i = 0;
        while (i < paramNums.size()) {
            Integer num = (Integer)paramNums.get(i);
            this.st.setFloat(num, x);
            ++i;
        }
    }

    public void setDouble(String key, double x) throws SQLException {
        List paramNums = (List)this.paramMap.get(key);
        if (paramNums == null) {
            throw new SQLException("No such key [" + key + "]");
        }
        int i = 0;
        while (i < paramNums.size()) {
            Integer num = (Integer)paramNums.get(i);
            this.st.setDouble(num, x);
            ++i;
        }
    }

    public void setNull(String key, int sqlType) throws SQLException {
        List paramNums = (List)this.paramMap.get(key);
        if (paramNums == null) {
            throw new SQLException("No such key [" + key + "]");
        }
        int i = 0;
        while (i < paramNums.size()) {
            Integer num = (Integer)paramNums.get(i);
            this.st.setNull(num, sqlType);
            ++i;
        }
    }

    public void setLong(String key, long x) throws SQLException {
        List paramNums = (List)this.paramMap.get(key);
        if (paramNums == null) {
            throw new SQLException("No such key [" + key + "]");
        }
        int i = 0;
        while (i < paramNums.size()) {
            Integer num = (Integer)paramNums.get(i);
            this.st.setLong(num, x);
            ++i;
        }
    }

    public void setShort(String key, short x) throws SQLException {
        List paramNums = (List)this.paramMap.get(key);
        if (paramNums == null) {
            throw new SQLException("No such key [" + key + "]");
        }
        int i = 0;
        while (i < paramNums.size()) {
            Integer num = (Integer)paramNums.get(i);
            this.st.setShort(num, x);
            ++i;
        }
    }

    public void setBoolean(String key, boolean x) throws SQLException {
        List paramNums = (List)this.paramMap.get(key);
        if (paramNums == null) {
            throw new SQLException("No such key [" + key + "]");
        }
        int i = 0;
        while (i < paramNums.size()) {
            Integer num = (Integer)paramNums.get(i);
            this.st.setBoolean(num, x);
            ++i;
        }
    }

    public void setBytes(String key, byte[] x) throws SQLException {
        List paramNums = (List)this.paramMap.get(key);
        if (paramNums == null) {
            throw new SQLException("No such key [" + key + "]");
        }
        int i = 0;
        while (i < paramNums.size()) {
            Integer num = (Integer)paramNums.get(i);
            this.st.setBytes(num, x);
            ++i;
        }
    }

    public void setDate(String key, Date x) throws SQLException {
        List paramNums = (List)this.paramMap.get(key);
        if (paramNums == null) {
            throw new SQLException("No such key [" + key + "]");
        }
        int i = 0;
        while (i < paramNums.size()) {
            Integer num = (Integer)paramNums.get(i);
            this.st.setDate(num, x);
            ++i;
        }
    }

    public void setTime(String key, Time x) throws SQLException {
        List paramNums = (List)this.paramMap.get(key);
        if (paramNums == null) {
            throw new SQLException("No such key [" + key + "]");
        }
        int i = 0;
        while (i < paramNums.size()) {
            Integer num = (Integer)paramNums.get(i);
            this.st.setTime(num, x);
            ++i;
        }
    }

    public void setTimestamp(String key, Timestamp x) throws SQLException {
        List paramNums = (List)this.paramMap.get(key);
        if (paramNums == null) {
            throw new SQLException("No such key [" + key + "]");
        }
        int i = 0;
        while (i < paramNums.size()) {
            Integer num = (Integer)paramNums.get(i);
            this.st.setTimestamp(num, x);
            ++i;
        }
    }

    public void setBigDecimal(String key, BigDecimal x) throws SQLException {
        List paramNums = (List)this.paramMap.get(key);
        if (paramNums == null) {
            throw new SQLException("No such key [" + key + "]");
        }
        int i = 0;
        while (i < paramNums.size()) {
            Integer num = (Integer)paramNums.get(i);
            this.st.setBigDecimal(num, x);
            ++i;
        }
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet result = this.st.executeQuery();
        return result;
    }

    public int executeUpdate() throws SQLException {
        int result = this.st.executeUpdate();
        return result;
    }

    public boolean execute() throws SQLException {
        boolean result = this.st.execute();
        return result;
    }

    public void addBatch() throws SQLException {
        this.st.addBatch();
    }

    public void clearParameters() throws SQLException {
        this.st.clearParameters();
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.st.setByte(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.st.setDouble(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.st.setFloat(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.st.setInt(parameterIndex, x);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.st.setNull(parameterIndex, sqlType);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.st.setLong(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.st.setShort(parameterIndex, x);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.st.setBoolean(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.st.setBytes(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.st.setAsciiStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.st.setBinaryStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.st.setUnicodeStream(parameterIndex, x, length);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.st.setCharacterStream(parameterIndex, reader, length);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.st.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.st.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.st.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.st.setNull(paramIndex, sqlType, typeName);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.st.setString(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.st.setBigDecimal(parameterIndex, x);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.st.setURL(parameterIndex, x);
    }

    public void setArray(int i, Array x) throws SQLException {
        this.st.setArray(i, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.st.setBlob(i, x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.st.setClob(i, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.st.setDate(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.st.getParameterMetaData();
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.st.setRef(i, x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.st.getMetaData();
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.st.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.st.setTimestamp(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.st.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.st.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.st.setTimestamp(parameterIndex, x, cal);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return this.st.executeQuery(sql);
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.st.executeUpdate(sql);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.st.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.st.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.st.executeUpdate(sql, columnNames);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.st.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql) throws SQLException {
        return this.st.execute(sql);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.st.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.st.execute(sql, columnNames);
    }

    public int getFetchDirection() throws SQLException {
        return this.st.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.st.getFetchSize();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.st.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.st.getMaxRows();
    }

    public int getQueryTimeout() throws SQLException {
        return this.st.getQueryTimeout();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.st.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.st.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.st.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this.st.getUpdateCount();
    }

    public void cancel() throws SQLException {
        this.st.cancel();
    }

    public void clearBatch() throws SQLException {
        this.st.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.st.clearWarnings();
    }

    public void close() throws SQLException {
        this.st.close();
    }

    public boolean getMoreResults() throws SQLException {
        return this.st.getMoreResults();
    }

    public int[] executeBatch() throws SQLException {
        return this.st.executeBatch();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.st.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.st.setFetchSize(rows);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.st.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.st.setMaxRows(max);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.st.setQueryTimeout(seconds);
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.st.getMoreResults(current);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.st.setEscapeProcessing(enable);
    }

    public void addBatch(String sql) throws SQLException {
        this.st.addBatch(sql);
    }

    public void setCursorName(String name) throws SQLException {
        this.st.setCursorName(name);
    }

    public Connection getConnection() throws SQLException {
        return this.st.getConnection();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.st.getGeneratedKeys();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.st.getResultSet();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.st.getWarnings();
    }
}

