/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc;

import com.lavans.util.Config;
import com.lavans.util.Logger;
import com.lavans.util.MethodUtil;
import com.lavans.util.jdbc.ConnectionPool;
import com.lavans.util.jdbc.bind.BindConnection;
import com.lavans.util.jdbc.cluster.ClusterConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DBManager {
    private static Logger logger = null;
    private static final String CLASSNAME;
    private static final String CONFIG_SECTION = "database";
    private static boolean statistics;
    private static Map countConnMap;
    private static Map dbMap;
    private static final int COUNT_GET = 0;
    private static final int COUNT_RELEASE = 1;
    private static final String CONFIG_FILE = "lavansutil.xml";
    private static final String MSG_ERR_CLUSTER_UNMATCH = "\u30af\u30e9\u30b9\u30bf\u30ce\u30fc\u30c9\u306e\u8a2d\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30ce\u30fc\u30c9\u756a\u53f7:";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.lavans.util.jdbc.DBManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASSNAME = clazz.getName();
        statistics = false;
        countConnMap = null;
        dbMap = null;
        DBManager.init(CONFIG_FILE);
    }

    public static void init(String configFile) {
        logger = Logger.getInstance();
        logger.enteringTool();
        dbMap = new HashMap();
        Element conf = (Element)Config.getInstance(configFile).getNode(CONFIG_SECTION);
        NodeList nodeList = conf.getChildNodes();
        if (nodeList == null) {
            return;
        }
        try {
            statistics = Boolean.valueOf(conf.getAttribute("statistics"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        countConnMap = new HashMap();
        String name = null;
        String driver = null;
        String url = null;
        String user = null;
        String pass = null;
        String valid_sql = null;
        String max = null;
        String init = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).getNodeType() != 3 && nodeList.item(i).getNodeType() != 8) {
                Element dbConf = (Element)nodeList.item(i);
                name = dbConf.getNodeName();
                driver = dbConf.getAttribute("driver");
                url = dbConf.getAttribute("url");
                user = dbConf.getAttribute("user");
                pass = dbConf.getAttribute("pass");
                max = dbConf.getAttribute("max_connections");
                init = dbConf.getAttribute("init_connections");
                logger.debug("max:" + max + ", init:" + init);
                boolean isForceCheck = Boolean.valueOf(dbConf.getAttribute("force_check_connection"));
                valid_sql = dbConf.getAttribute("valid_sql");
                ConnectionPool pool = null;
                int node = 1;
                try {
                    node = Integer.parseInt(dbConf.getAttribute("cluster_node"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (node > 1) {
                    pool = new ClusterConnectionPool(driver, url, user, pass);
                    ArrayList<String> urlList = new ArrayList<String>(node);
                    urlList.add(url);
                    int j = 1;
                    while (j < node) {
                        String cluster_url = dbConf.getAttribute("url" + (j + 1));
                        if (cluster_url.equals("")) {
                            logger.log("\u30af\u30e9\u30b9\u30bf\u30ce\u30fc\u30c9\u306e\u8a2d\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30ce\u30fc\u30c9\u756a\u53f7:[" + j + "].");
                        } else {
                            urlList.add(cluster_url);
                        }
                        ++j;
                    }
                    ((ClusterConnectionPool)pool).setUrlList(urlList);
                } else {
                    logger.debugTool("\u2605ConnectionPool\u4f5c\u6210:" + name);
                    pool = new ConnectionPool(driver, url, user, pass);
                }
                try {
                    pool.setMaxConnections(Integer.parseInt(max));
                }
                catch (NumberFormatException urlList) {
                    // empty catch block
                }
                try {
                    pool.setInitConnections(Integer.parseInt(init));
                }
                catch (NumberFormatException urlList) {
                    // empty catch block
                }
                pool.setStatistics(statistics);
                String logger_name = dbConf.getAttribute("logger");
                if (!logger_name.equals("")) {
                    Logger logger = Logger.getInstance(logger_name);
                    pool.setLogger(logger);
                }
                if (isForceCheck) {
                    pool.setForceCheck(isForceCheck);
                    pool.setValidSql(valid_sql);
                }
                boolean isLogging = true;
                try {
                    isLogging = Boolean.valueOf(dbConf.getAttribute("logging"));
                }
                catch (Exception cluster_url) {
                    // empty catch block
                }
                pool.setLogging(isLogging);
                try {
                    pool.init();
                }
                catch (Exception e) {
                    logger.err(e);
                }
                dbMap.put(name, pool);
                logger.debug("create ConnectionPool[" + name + "]");
            }
            ++i;
        }
        logger.exitingTool();
    }

    public static BindConnection getConnection() throws SQLException {
        return DBManager.getConnection("default");
    }

    public static BindConnection getConnection(String dbName) throws SQLException {
        ConnectionPool pool = (ConnectionPool)dbMap.get(dbName);
        if (statistics) {
            String method = MethodUtil.getMethodName(CLASSNAME).split(":")[0];
            int[] count = (int[])countConnMap.get(method);
            if (count == null) {
                count = new int[]{1, 0};
                countConnMap.put(method, count);
            } else {
                count[0] = count[0] + 1;
            }
        }
        return pool.getConnection();
    }

    public static void releaseConnection(Connection conn) throws SQLException {
        DBManager.releaseConnection(conn, "default");
    }

    public static void releaseConnection(Connection conn, String dbName) throws SQLException {
        ConnectionPool pool = (ConnectionPool)dbMap.get(dbName);
        DBManager.releaseConnection(conn, pool);
    }

    public static void releaseConnection(Connection conn, ConnectionPool pool) throws SQLException {
        pool.releaseConnection(conn);
        if (statistics) {
            String method = MethodUtil.getMethodName(CLASSNAME).split(":")[0];
            int[] count = (int[])countConnMap.get(method);
            if (count == null) {
                logger.debug("\u8cb8\u3057\u51fa\u3057\u3066\u306a\u3044\u30e1\u30bd\u30c3\u30c9\u304b\u3089\u8fd4\u5374\u3055\u308c\u305f\u3002" + method);
                count = new int[]{0, 1};
                countConnMap.put(method, count);
            } else {
                count[1] = count[1] + 1;
            }
        }
    }

    public static String viewConnectionPool() {
        if (!statistics) {
            return "";
        }
        Set col = countConnMap.keySet();
        ArrayList list = new ArrayList(col.size());
        Iterator ite = col.iterator();
        while (ite.hasNext()) {
            list.add(ite.next());
        }
        Collections.sort(list);
        StringBuffer buf = new StringBuffer();
        buf.append("Connection List\n");
        int i = 0;
        while (i < list.size()) {
            int[] count = (int[])countConnMap.get(list.get(i));
            buf.append(list.get(i) + "\t:" + count[0] + "\t:" + count[1] + "\t:" + (count[0] - count[1]) + "\n");
            ++i;
        }
        return buf.toString();
    }

    public static int getConnectionCount() {
        return DBManager.getConnectionCount("default");
    }

    public static int getConnectionCount(String dbName) {
        ConnectionPool pool = (ConnectionPool)dbMap.get(dbName);
        return pool.getUseCount();
    }

    public static int getPoolCount() {
        return DBManager.getPoolCount("default");
    }

    public static int getPoolCount(String dbName) {
        ConnectionPool pool = (ConnectionPool)dbMap.get(dbName);
        return pool.getPoolCount();
    }

    public static int getMaxConnections() {
        return DBManager.getMaxConnections("default");
    }

    public static int getMaxConnections(String dbName) {
        ConnectionPool pool = (ConnectionPool)dbMap.get(dbName);
        return pool.getMaxConnections();
    }

    public static void setMaxConnections(int count) {
        DBManager.setMaxConnections("default", count);
    }

    public static void setMaxConnections(String dbName, int count) {
        ConnectionPool pool = (ConnectionPool)dbMap.get(dbName);
        pool.setMaxConnections(count);
    }

    public static void startTransaction() throws SQLException {
        DBManager.startTransaction("default");
    }

    public static void startTransaction(String dbName) throws SQLException {
        ConnectionPool pool = (ConnectionPool)dbMap.get(dbName);
        pool.startTransaction();
    }

    public static void commit() throws SQLException {
        DBManager.commit("default");
    }

    public static void commit(String dbName) throws SQLException {
        ConnectionPool pool = (ConnectionPool)dbMap.get(dbName);
        pool.commit();
    }

    public static void rollback() throws SQLException {
        DBManager.rollback("default");
    }

    public static void rollback(String dbName) throws SQLException {
        ConnectionPool pool = (ConnectionPool)dbMap.get(dbName);
        pool.rollback();
    }
}

