/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc;

import com.lavans.util.Logger;
import com.lavans.util.jdbc.bind.BindConnection;
import com.lavans.util.jdbc.bind.BindConnectionImpl;
import com.lavans.util.jdbc.logging.LoggingConnection;
import com.lavans.util.jdbc.pool.PooledConnection;
import com.lavans.util.jdbc.stats.StatsConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class ConnectionPool {
    protected Logger logger = null;
    private String driverName = null;
    private String url = null;
    private String user = null;
    private String pass = null;
    private Driver driver = null;
    private boolean statistics = false;
    private boolean isLogging = true;
    private int max_connections = 10;
    private int init_connections = 2;
    private List poolList = Collections.synchronizedList(new ArrayList());
    private List useList = Collections.synchronizedList(new ArrayList());
    private ThreadLocal transactionList = new ThreadLocal();
    protected static final String MSG_ERR_TOOMANYCONNECTIONS = "\u63a5\u7d9a\u6570\u304c\u6700\u5927\u5024\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002";
    protected static final String SQLSTATE_CONNECTION_EXCEPTION = "08000";
    public static final int ERR_CONNECTION_OVERFLOW = 1;
    private boolean isForceCheck = false;
    private String validSql = null;

    public ConnectionPool(String aDriver, String aUrl, String aUser, String aPass) {
        this.driverName = aDriver;
        this.url = aUrl;
        this.user = aUser;
        this.pass = aPass;
        this.logger = Logger.getInstance();
    }

    public void setMaxConnections(int value) {
        this.max_connections = value;
    }

    public void setInitConnections(int value) {
        this.init_connections = value;
    }

    public void init() throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        this.driver = (Driver)Class.forName(this.driverName).newInstance();
        int i = 0;
        while (i < this.init_connections) {
            this.poolList.add(this.createConnection());
            ++i;
        }
    }

    protected synchronized BindConnection createConnection() throws SQLException {
        this.logger.entering("\u2605ConnectionPool", "createConnection");
        Properties info = new Properties();
        if (this.user != null) {
            info.put("user", this.user);
        }
        if (this.pass != null) {
            info.put("password", this.pass);
        }
        if (this.poolList.size() + this.useList.size() >= this.max_connections) {
            this.logger.exiting("\u2605ConnectionPool", "createConnection");
            throw new SQLException(MSG_ERR_TOOMANYCONNECTIONS, SQLSTATE_CONNECTION_EXCEPTION, 1);
        }
        Connection conn = null;
        this.logger.debug(String.valueOf(this.url) + ":" + this.user + ":" + this.pass);
        try {
            conn = this.driver.connect(this.url, info);
        }
        catch (SQLException e) {
            this.logger.exiting("\u2605ConnectionPool", "createConnection");
            throw e;
        }
        if (this.statistics) {
            conn = new StatsConnection(conn);
        }
        if (this.isLogging) {
            conn = new LoggingConnection(conn);
            ((LoggingConnection)conn).setLogger(this.logger);
        }
        BindConnection bcon = new BindConnectionImpl(conn);
        bcon = new PooledConnection(this, bcon);
        this.logger.exiting("\u2605ConnectionPool", "createConnection");
        return bcon;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkConnection(Connection conn) {
        boolean result = false;
        Statement st = null;
        try {
            try {
                st = conn.createStatement();
                if (this.isForceCheck) {
                    st.executeQuery(this.validSql);
                }
                result = true;
            }
            catch (SQLException sQLException) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                st.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (Exception e) {
            return result;
        }
        st.close();
        return result;
    }

    public BindConnection getConnection() throws SQLException {
        this.logger.enteringTool();
        BindConnection conn = null;
        conn = (BindConnection)this.transactionList.get();
        if (conn != null) {
            return conn;
        }
        List list = this.poolList;
        synchronized (list) {
            if (this.poolList.size() > 0 && !this.checkConnection(conn = (BindConnection)this.poolList.remove(0))) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                conn = null;
            }
        }
        if (conn == null) {
            conn = this.createConnection();
        }
        this.logger.debugTool("\u25a1\u25a1 " + conn.toString());
        this.useList.add(conn);
        this.logger.debugTool(this.useList.toString());
        this.logger.exitingTool();
        return conn;
    }

    public void releaseConnection(Connection conn) throws SQLException {
        this.logger.enteringTool();
        this.logger.debugTool("\u25a1\u25a1 " + conn.toString());
        this.logger.debugTool(this.useList.toString());
        BindConnection connTran = (BindConnection)this.transactionList.get();
        if (connTran == conn) {
            return;
        }
        conn.setAutoCommit(true);
        if (conn instanceof PooledConnection) {
            ((PooledConnection)conn).clearStatementList();
        }
        if (!this.useList.remove(conn)) {
            throw new SQLException("This is not my connection.");
        }
        this.poolList.add(conn);
        this.logger.exitingTool();
    }

    public void startTransaction() throws SQLException {
        BindConnection conn = this.getConnection();
        conn.setAutoCommit(false);
        this.transactionList.set(conn);
    }

    public void commit() throws SQLException {
        BindConnection conn = (BindConnection)this.transactionList.get();
        if (conn == null) {
            return;
        }
        conn.commit();
        conn.setAutoCommit(true);
        this.transactionList.remove();
    }

    public void rollback() throws SQLException {
        BindConnection conn = (BindConnection)this.transactionList.get();
        if (conn == null) {
            return;
        }
        conn.rollback();
        conn.setAutoCommit(true);
        this.transactionList.remove();
    }

    public void setStatistics(boolean b) {
        this.statistics = b;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected int getMaxConnections() {
        return this.max_connections;
    }

    protected Driver getDriver() {
        return this.driver;
    }

    protected String getUser() {
        return this.user;
    }

    protected String getPass() {
        return this.pass;
    }

    protected List getPoolList() {
        return this.poolList;
    }

    protected boolean isStatistics() {
        return this.statistics;
    }

    protected List getUseList() {
        return this.useList;
    }

    public void setForceCheck(boolean isForceCheck) {
        this.isForceCheck = isForceCheck;
    }

    public void setValidSql(String validSql) {
        this.validSql = validSql;
    }

    public boolean isLogging() {
        return this.isLogging;
    }

    public void setLogging(boolean isLogging) {
        this.isLogging = isLogging;
    }

    public int getUseCount() {
        return this.useList.size();
    }

    public int getPoolCount() {
        return this.poolList.size();
    }
}

