/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util;

import com.sun.org.apache.xerces.internal.dom.DOMImplementationImpl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

public class Config {
    private static String CONFIG_FILE = "lavansutil.xml";
    private static String CONFIG_PROPERTY = "config";
    private static Map instanceMap = new HashMap();
    private Map nodeMap = null;
    private Map propertyMap = null;
    private Element root = null;

    public static Config getInstance() {
        return Config.getInstance(CONFIG_FILE);
    }

    public static Config getInstance(String configFile) {
        Config config = (Config)instanceMap.get(configFile);
        if (config == null) {
            config = new Config(configFile);
            instanceMap.put(configFile, config);
        }
        return config;
    }

    protected Config(String fileName) {
        this.init(fileName);
    }

    public void init(String fileName) {
        this.nodeMap = new HashMap();
        try {
            DOMImplementationImpl domImplLS = new DOMImplementationImpl();
            LSInput lsInput = domImplLS.createLSInput();
            LSParser lsParser = domImplLS.createLSParser((short)1, null);
            URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
            String fullFileName = URLDecoder.decode(url.getFile(), "UTF-8");
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(fullFileName);
            }
            catch (FileNotFoundException e) {
                System.out.println(String.valueOf(fullFileName) + "\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
            }
            lsInput.setByteStream(fis);
            Document doc = lsParser.parse(lsInput);
            this.root = doc.getDocumentElement();
            NodeList list = this.root.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                    if (node.getNodeName().equals(CONFIG_PROPERTY)) {
                        this.makeProperty(node);
                    } else {
                        this.saveNode(node.getNodeName(), node);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void makeProperty(Node node) {
        this.propertyMap = new HashMap();
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node item = nodeList.item(i);
            if (item.getNodeType() != 3 && item.getNodeType() != 8) {
                Element ele = (Element)item;
                this.propertyMap.put(ele.getAttribute("name"), ele.getAttribute("value"));
            }
            ++i;
        }
    }

    private void saveNode(String nodeName, Node node) {
        ArrayList<Node> nodeList = (ArrayList<Node>)this.nodeMap.get(nodeName);
        if (nodeList == null) {
            nodeList = new ArrayList<Node>();
            this.nodeMap.put(nodeName, nodeList);
        }
        nodeList.add(node);
    }

    public Element getRoot() {
        return this.root;
    }

    public Node getNode(String nodeName) {
        List nodeList = (List)this.nodeMap.get(nodeName);
        if (nodeList == null) {
            return null;
        }
        return (Node)nodeList.get(0);
    }

    public List getNodeList(String nodeName) {
        return (List)this.nodeMap.get(nodeName);
    }

    public String getProperty(String name) {
        return (String)this.propertyMap.get(name);
    }
}

