/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.cluster;

import com.lavans.util.jdbc.cluster.CalledMethod;
import com.lavans.util.jdbc.cluster.ClusterConnection;
import com.lavans.util.jdbc.cluster.ClusterResultSet;
import com.lavans.util.jdbc.cluster.ClusterStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class ClusterPreparedStatement
extends ClusterStatement
implements PreparedStatement {
    private PreparedStatement st = null;
    private ClusterConnection con = null;
    private List methodList = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;

    public ClusterPreparedStatement(ClusterConnection con, PreparedStatement st) {
        super(con, st);
        this.con = con;
        this.st = st;
        this.methodList = new ArrayList();
    }

    public void close() throws SQLException {
        this.methodList.clear();
        super.close();
    }

    public void reupdateStatement(Statement st) throws SQLException {
        ClusterStatement.logger.enteringTool();
        try {
            this.st.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.st = (PreparedStatement)st;
        super.reupdateStatement(st);
        ClusterStatement.logger.debug("reexecute count:" + this.methodList.size());
        int i = 0;
        while (i < this.methodList.size()) {
            CalledMethod calledMethod = (CalledMethod)this.methodList.get(i);
            try {
                ClusterStatement.logger.debugTool(calledMethod.toString());
                calledMethod.invoke(st);
            }
            catch (Exception e) {
                ClusterStatement.logger.err(e);
                throw new SQLException("Statement\u306e\u518d\u751f\u6210\u306b\u5931\u6557\u3002");
            }
            ++i;
        }
        ClusterStatement.logger.exitingTool();
    }

    private Object clusterCall(String methodName, Object[] args, Class[] parameterTypes) throws SQLException {
        ClusterStatement.logger.enteringTool();
        Object result = null;
        CalledMethod calledMethod = new CalledMethod(methodName, args, parameterTypes);
        ClusterStatement.logger.debugTool(calledMethod.toString());
        try {
            result = calledMethod.invoke(this.st);
        }
        catch (Exception e) {
            ClusterStatement.logger.err("\u969c\u5bb3\u304c\u51fa\u305f\u306e\u3067\u63a5\u7d9a\u5148\u3092\u5207\u308a\u66ff\u3048\u307e\u3059\u3002");
            ClusterStatement.logger.err(e);
            if (e.getCause() != null) {
                ClusterStatement.logger.err(e.getCause().getMessage());
            }
            this.con.notifyError(this);
            try {
                result = calledMethod.invoke(this.st);
            }
            catch (Exception e2) {
                throw new SQLException(e2.getMessage());
            }
        }
        this.methodList.add(calledMethod);
        ClusterStatement.logger.exitingTool();
        return result;
    }

    public ResultSet getAnotherResultSet() throws SQLException {
        ClusterStatement.logger.enteringTool();
        try {
            this.st.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.con.notifyError(this);
        ResultSet rs = this.st.executeQuery();
        ClusterStatement.logger.exitingTool();
        return rs;
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet result = (ResultSet)this.clusterCall("executeQuery", null, null);
        return new ClusterResultSet(this, result);
    }

    public int executeUpdate() throws SQLException {
        return (Integer)this.clusterCall("executeUpdate", null, null);
    }

    public boolean execute() throws SQLException {
        return (Boolean)this.clusterCall("execute", null, null);
    }

    public void addBatch() throws SQLException {
        this.clusterCall("addBatch", null, null);
    }

    public void clearParameters() throws SQLException {
        this.clusterCall("clearParameters", null, null);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.clusterCall("setByte", new Object[]{new Integer(parameterIndex), new Byte(x)}, new Class[]{Integer.TYPE, Byte.TYPE});
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.clusterCall("setDouble", new Object[]{new Integer(parameterIndex), new Double(x)}, new Class[]{Integer.TYPE, Double.TYPE});
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.clusterCall("setFloat", new Object[]{new Integer(parameterIndex), new Float(x)}, new Class[]{Integer.TYPE, Float.TYPE});
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.clusterCall("setInt", new Object[]{new Integer(parameterIndex), new Integer(x)}, new Class[]{Integer.TYPE, Integer.TYPE});
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.clusterCall("setNull", new Object[]{new Integer(parameterIndex), new Integer(sqlType)}, new Class[]{Integer.TYPE, Integer.TYPE});
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.clusterCall("setLong", new Object[]{new Integer(parameterIndex), new Long(x)}, new Class[]{Integer.TYPE, Long.TYPE});
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.clusterCall("setShort", new Object[]{new Integer(parameterIndex), new Short(x)}, new Class[]{Integer.TYPE, Short.TYPE});
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.clusterCall("setBoolean", new Object[]{new Integer(parameterIndex), new Boolean(x)}, new Class[]{Integer.TYPE, Boolean.TYPE});
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("setBytes", objectArray, classArray);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x, new Integer(length)};
        Class[] classArray = new Class[3];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.io.InputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        classArray[2] = Integer.TYPE;
        this.clusterCall("setAsciiStream", objectArray, classArray);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x, new Integer(length)};
        Class[] classArray = new Class[3];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.io.InputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        classArray[2] = Integer.TYPE;
        this.clusterCall("setBinaryStream", objectArray, classArray);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x, new Integer(length)};
        Class[] classArray = new Class[3];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.io.InputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        classArray[2] = Integer.TYPE;
        this.clusterCall("setUnicodeStream", objectArray, classArray);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), reader, new Integer(length)};
        Class[] classArray = new Class[3];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.io.Reader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        classArray[2] = Integer.TYPE;
        this.clusterCall("setCharacterStream", objectArray, classArray);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("setObject", objectArray, classArray);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x, new Integer(targetSqlType)};
        Class[] classArray = new Class[3];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        classArray[2] = Integer.TYPE;
        this.clusterCall("setObject", objectArray, classArray);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x, new Integer(targetSqlType), new Integer(scale)};
        Class[] classArray = new Class[4];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        classArray[2] = Integer.TYPE;
        classArray[3] = Integer.TYPE;
        this.clusterCall("setObject", objectArray, classArray);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(paramIndex), new Integer(sqlType), typeName};
        Class[] classArray = new Class[3];
        classArray[0] = Integer.TYPE;
        classArray[1] = Integer.TYPE;
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz;
        this.clusterCall("setNull", objectArray, classArray);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("setString", objectArray, classArray);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("setBigDecimal", objectArray, classArray);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("setURL", objectArray, classArray);
    }

    public void setArray(int i, Array x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(i), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("java.sql.Array");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("setArray", objectArray, classArray);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(i), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("java.sql.Blob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("setBlob", objectArray, classArray);
    }

    public void setClob(int i, Clob x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(i), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("java.sql.Clob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("setClob", objectArray, classArray);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("setDate", objectArray, classArray);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return (ParameterMetaData)this.clusterCall("getParameterMetaData", null, null);
    }

    public void setRef(int i, Ref x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(i), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$11;
        if (clazz == null) {
            try {
                clazz = class$11 = Class.forName("java.sql.Ref");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("setRef", objectArray, classArray);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return (ResultSetMetaData)this.clusterCall("getMetaData", null, null);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$12;
        if (clazz == null) {
            try {
                clazz = class$12 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("setTime", objectArray, classArray);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x};
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$13;
        if (clazz == null) {
            try {
                clazz = class$13 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        this.clusterCall("setTimestamp", objectArray, classArray);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x, cal};
        Class[] classArray = new Class[3];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        Class<?> clazz2 = class$14;
        if (clazz2 == null) {
            try {
                clazz2 = class$14 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz2;
        this.clusterCall("setDate", objectArray, classArray);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x, cal};
        Class[] classArray = new Class[3];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$12;
        if (clazz == null) {
            try {
                clazz = class$12 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        Class<?> clazz2 = class$14;
        if (clazz2 == null) {
            try {
                clazz2 = class$14 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz2;
        this.clusterCall("setTime", objectArray, classArray);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Object[] objectArray = new Object[]{new Integer(parameterIndex), x, cal};
        Class[] classArray = new Class[3];
        classArray[0] = Integer.TYPE;
        Class<?> clazz = class$13;
        if (clazz == null) {
            try {
                clazz = class$13 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz;
        Class<?> clazz2 = class$14;
        if (clazz2 == null) {
            try {
                clazz2 = class$14 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz2;
        this.clusterCall("setTimestamp", objectArray, classArray);
    }
}

