/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Config {
    private static String CONFIG_FILE = "lavansutil.xml";
    private static String CONFIG_PROPERTY = "config";
    private static Map instanceMap = new HashMap();
    private Map nodeMap = null;
    private Map propertyMap = null;
    private Element root = null;

    public static Config getInstance() {
        return Config.getInstance(CONFIG_FILE);
    }

    public static Config getInstance(String configFile) {
        Config config = (Config)instanceMap.get(configFile);
        if (config == null) {
            config = new Config(configFile);
        }
        return config;
    }

    protected Config(String fileName) {
        this.init(fileName);
    }

    public void init(String fileName) {
        this.nodeMap = new HashMap();
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.parse(Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName));
            this.root = doc.getDocumentElement();
            NodeList list = this.root.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.getNodeType() != 3 && node.getNodeType() != 8) {
                    if (node.getNodeName().equals(CONFIG_PROPERTY)) {
                        this.makeProperty(node);
                    } else {
                        this.nodeMap.put(node.getNodeName(), node);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void makeProperty(Node node) {
        this.propertyMap = new HashMap();
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node item = nodeList.item(i);
            if (item.getNodeType() != 3 && item.getNodeType() != 8) {
                Element ele = (Element)item;
                this.propertyMap.put(ele.getAttribute("name"), ele.getAttribute("value"));
            }
            ++i;
        }
    }

    public Element getRoot() {
        return this.root;
    }

    public Node getNode(String nodeName) {
        return (Node)this.nodeMap.get(nodeName);
    }

    public String getProperty(String name) {
        return (String)this.propertyMap.get(name);
    }
}

