/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.cluster;

import com.lavans.util.Logger;
import com.lavans.util.jdbc.cluster.CalledMethod;
import com.lavans.util.jdbc.cluster.ClusterConnection;
import com.lavans.util.jdbc.cluster.ClusterResultSet;
import com.lavans.util.jdbc.cluster.ClusterStatementInterface;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ClusterStatement
implements Statement,
ClusterStatementInterface {
    protected static final String MSG_ERR_REUPDATE = "Statement\u306e\u518d\u751f\u6210\u306b\u5931\u6557\u3002";
    protected static final String MSG_WARN_SWITCH_DB = "\u969c\u5bb3\u304c\u51fa\u305f\u306e\u3067\u63a5\u7d9a\u5148\u3092\u5207\u308a\u66ff\u3048\u307e\u3059\u3002";
    private Statement st = null;
    private ClusterConnection con = null;
    private List methodList = null;
    private String sql = null;
    protected static Logger logger = Logger.getInstance();

    public ClusterStatement(ClusterConnection con, Statement st) {
        this.con = con;
        this.st = st;
        this.methodList = new ArrayList();
    }

    public void reupdateStatement(Statement st) throws SQLException {
        logger.enteringTool();
        try {
            this.st.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.st = st;
        int i = 0;
        while (i < this.methodList.size()) {
            CalledMethod calledMethod = (CalledMethod)this.methodList.get(i);
            try {
                calledMethod.invoke(st);
            }
            catch (Exception e) {
                logger.err(e);
                throw new SQLException(MSG_ERR_REUPDATE);
            }
            ++i;
        }
        logger.exitingTool();
    }

    private Object clusterCall(String methodName, Object[] args, boolean saveMethod) throws SQLException {
        logger.enteringTool();
        Object result = null;
        CalledMethod calledMethod = new CalledMethod(methodName, args);
        logger.debugTool(calledMethod.toString());
        try {
            result = calledMethod.invoke(this.st);
        }
        catch (Exception e) {
            logger.err(MSG_WARN_SWITCH_DB + e.getCause().getMessage());
            this.con.notifyError(this);
            try {
                result = calledMethod.invoke(this.st);
            }
            catch (Exception e2) {
                throw new SQLException(e2.getMessage());
            }
        }
        if (saveMethod) {
            this.methodList.add(calledMethod);
        }
        logger.exitingTool();
        return result;
    }

    public ResultSet getAnotherResultSet() throws SQLException {
        logger.enteringTool();
        logger.debug("\u6b21\u306esql\u3092\u518d\u767a\u884c\u3057\u3066ResultSet\u3092\u518d\u751f\u6210\u3057\u307e\u3059\u3002\n" + this.sql);
        this.con.notifyError(this);
        ResultSet rs = this.st.executeQuery(this.sql);
        logger.exitingTool();
        return rs;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        logger.enteringTool();
        ResultSet rs = (ResultSet)this.clusterCall("executeQuery", new Object[]{sql}, true);
        logger.exitingTool();
        return new ClusterResultSet(this, rs);
    }

    public int executeUpdate(String sql) throws SQLException {
        return (Integer)this.clusterCall("executeUpdate", new Object[]{sql}, true);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return (Integer)this.clusterCall("executeUpdate", new Object[]{sql, new Integer(autoGeneratedKeys)}, true);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return (Integer)this.clusterCall("executeUpdate", new Object[]{sql, columnIndexes}, true);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return (Integer)this.clusterCall("executeUpdate", new Object[]{sql, columnNames}, true);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return (Boolean)this.clusterCall("execute", new Object[]{sql, new Integer(autoGeneratedKeys)}, true);
    }

    public boolean execute(String sql) throws SQLException {
        return (Boolean)this.clusterCall("execute", new Object[]{sql}, true);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return (Boolean)this.clusterCall("execute", new Object[]{sql, columnIndexes}, true);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return (Boolean)this.clusterCall("execute", new Object[]{sql, columnNames}, true);
    }

    public int getFetchDirection() throws SQLException {
        return (Integer)this.clusterCall("getFetchDirection", null, false);
    }

    public int getFetchSize() throws SQLException {
        return (Integer)this.clusterCall("getFetchSize", null, false);
    }

    public int getMaxFieldSize() throws SQLException {
        return (Integer)this.clusterCall("getMaxFieldSize", null, false);
    }

    public int getMaxRows() throws SQLException {
        return (Integer)this.clusterCall("getMaxRows", null, false);
    }

    public int getQueryTimeout() throws SQLException {
        return (Integer)this.clusterCall("getQueryTimeout", null, false);
    }

    public int getResultSetConcurrency() throws SQLException {
        return (Integer)this.clusterCall("getResultSetConcurrency", null, false);
    }

    public int getResultSetHoldability() throws SQLException {
        return (Integer)this.clusterCall("getResultSetConcurrency", null, false);
    }

    public int getResultSetType() throws SQLException {
        return (Integer)this.clusterCall("getResultSetType", null, false);
    }

    public int getUpdateCount() throws SQLException {
        return (Integer)this.clusterCall("getUpdateCount", null, false);
    }

    public void cancel() throws SQLException {
        this.clusterCall("cancel", null, true);
    }

    public void clearBatch() throws SQLException {
        this.clusterCall("clearBatch", null, true);
        this.st.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.clusterCall("clearWarnings", null, true);
        this.st.clearWarnings();
    }

    public void close() throws SQLException {
        this.clusterCall("close", null, true);
        this.st.close();
        this.con.remove(this);
    }

    public boolean getMoreResults() throws SQLException {
        return (Boolean)this.clusterCall("getMoreResults", null, false);
    }

    public int[] executeBatch() throws SQLException {
        return (int[])this.clusterCall("executeBatch", null, true);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.clusterCall("setFetchDirection", new Object[]{new Integer(direction)}, true);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.clusterCall("setFetchSize", new Object[]{new Integer(rows)}, true);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.clusterCall("setMaxFieldSize", new Object[]{new Integer(max)}, true);
    }

    public void setMaxRows(int max) throws SQLException {
        this.clusterCall("setMaxRows", new Object[]{new Integer(max)}, true);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.clusterCall("setQueryTimeout", new Object[]{new Integer(seconds)}, true);
    }

    public boolean getMoreResults(int current) throws SQLException {
        return (Boolean)this.clusterCall("getMoreResults", new Object[]{new Integer(current)}, false);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.clusterCall("setFetchDirection", new Object[]{new Boolean(enable)}, true);
    }

    public void addBatch(String sql) throws SQLException {
        this.clusterCall("addBatch", new Object[]{sql}, true);
    }

    public void setCursorName(String name) throws SQLException {
        this.clusterCall("setCursorName", new Object[]{name}, true);
    }

    public Connection getConnection() throws SQLException {
        return this.con;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return (ResultSet)this.clusterCall("getGeneratedKeys", null, false);
    }

    public ResultSet getResultSet() throws SQLException {
        return (ResultSet)this.clusterCall("getResultSet", null, false);
    }

    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this.clusterCall("getWarnings", null, false);
    }
}

