/*
 * Decompiled with CFR 0.152.
 */
package com.lavans.util.jdbc.cluster;

import com.lavans.util.jdbc.ConnectionPool;
import com.lavans.util.jdbc.bind.BindConnection;
import com.lavans.util.jdbc.cluster.ClusterConnection;
import com.lavans.util.jdbc.logging.LoggingConnection;
import com.lavans.util.jdbc.stats.StatsConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ClusterConnectionPool
extends ConnectionPool {
    private static final String MSG_ERR_NOCONNECT = "\u6709\u52b9\u306a\u63a5\u7d9a\u5148\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
    private List urlList = null;
    private static Random rnd = new Random();
    private Map urlMap = null;

    public ClusterConnectionPool(String driver, String url, String user, String pass) {
        super(driver, url, user, pass);
    }

    public List getUrlList() {
        return this.urlList;
    }

    public void setUrlList(List list) {
        this.urlList = list;
        this.urlMap = new HashMap(list.size());
    }

    protected BindConnection createConnection() throws SQLException {
        this.logger.entering("\u2605ConnectionPool", "createConnection");
        if (this.getPoolList().size() + this.getUseList().size() >= this.getMax_connections()) {
            throw new SQLException("\u63a5\u7d9a\u6570\u304c\u6700\u5927\u5024\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002");
        }
        Connection conn = this.createNativeConnection();
        conn = new ClusterConnection(conn, this);
        this.logger.debugTool(conn.getMetaData().getURL());
        this.urlMap.put(conn, conn.getMetaData().getURL());
        if (this.isStatistics()) {
            conn = new StatsConnection(conn);
        }
        conn = new LoggingConnection(conn);
        ((LoggingConnection)conn).setLogger(this.logger);
        BindConnection bcon = new BindConnection(conn);
        this.logger.exiting("\u2605ConnectionPool", "createConnection");
        return bcon;
    }

    private Connection createNativeConnection() throws SQLException {
        return this.createNativeConnection(new ArrayList(this.urlList));
    }

    private Connection createNativeConnection(List workList) throws SQLException {
        while (workList.size() > 0) {
            String url = this.getRandomSelectUrl(workList);
            try {
                Connection conn = DriverManager.getConnection(url, this.getUser(), this.getPass());
                if (this.checkConnection(conn)) {
                    return conn;
                }
                workList.remove(url);
            }
            catch (SQLException e) {
                workList.remove(url);
            }
        }
        throw new SQLException(MSG_ERR_NOCONNECT);
    }

    private String getRandomSelectUrl(List list) {
        int i = (int)Math.ceil(rnd.nextInt(list.size()));
        this.logger.debug("\u2605 " + i + "\u756a\u76ee\u304c\u9078\u629e\u3055\u308c\u305f\u3002");
        return (String)list.get(i);
    }

    public Connection getAnotherConnection(ClusterConnection target) throws SQLException {
        this.logger.enteringTool();
        String url = (String)this.urlMap.remove(target);
        ArrayList workList = new ArrayList(this.urlList);
        workList.remove(url);
        Connection conn = this.createNativeConnection(workList);
        this.logger.debugTool(conn.getMetaData().getURL());
        this.urlMap.put(target, conn.getMetaData().getURL());
        this.logger.exitingTool();
        return conn;
    }

    public BindConnection getConnection() throws SQLException {
        BindConnection con = super.getConnection();
        con.rollback();
        return con;
    }
}

