//@formatter:off
/*
 * Auther: tukune
 * 
 * DON'T CODE FORMAT!
 * DON'T CONVERT TAB <---> SPACE
 * DON'T STRIP TRAILING BLANKS FROM END OF LINE
 */
package jp.sf.l2j.boundArrays;

import java.util.ArrayList;
import java.util.Collection;

/**
 * @author JOJO
 */
public class BoundArrayList<E>
{
	private ArrayList<E> elementData = new ArrayList<>();
	private int lbound;
	
	public BoundArrayList() {}
	
	public BoundArrayList(int lbound) { this.lbound = lbound; }
	
	public BoundArrayList<E> to(int ubound) {
		final int s = ubound - lbound + 1;
		elementData.ensureCapacity(s);
		while (elementData.size() < s) elementData.add(null);
		while (elementData.size() > s) elementData.remove(elementData.size() - 1);
		return this;
	}
	
	public int size() { return elementData.size(); }
	
	public boolean isEmpty() { return elementData.isEmpty(); }
	
	public int lbound() { return lbound; }
	
	public int ubound() { return lbound + elementData.size() - 1; }
	
	public boolean contains(E element) { return indexOf(element) >= 0; }
	
	public boolean containsKey(int index) {
	//	return lbound() <= index && index <= ubound();
		int pos = index - lbound;
		return 0 <= pos && pos < elementData.size();
	}
	
	public int indexOf(E element) {
		return elementData.indexOf(element);
	}
	
	public int lastIndexOf(E element) {
		return elementData.lastIndexOf(element);
	}
	
	public Object[] toArray() { return elementData.toArray(); }
	
	public E get(int index) {
		final int pos = index - lbound;
		return pos >= 0 && pos < elementData.size() ? (E) elementData.get(pos) : null;
	}
	
	public E set(int index, E element) {
		final int pos = index - lbound;
		return elementData.set(pos, element);
	}
	
	public E put(int index, E element) {
		final int size = elementData.size();
		if (size == 0 && lbound == 0)
			lbound = index;
		final int pos = index - lbound;
		if (pos == size)
			{ elementData.add(element); return null; }
		else
			return elementData.set(pos, element);
	}
	
	public BoundArrayList<E> append(int index, E element) {
		final int size = elementData.size();
		if (size == 0 && lbound == 0)
			lbound = index;
		final int pos = index - lbound;
		if (pos == size)
			elementData.add(element);
		else
			elementData.set(pos, element);
		return this;
	}
	
	public BoundArrayList<E> append(E element) {
		elementData.add(element);
		return this;
	}
	
	public void clear() { elementData.clear(); }
	
	public boolean addAll(E[] a) {
		for (E e : a) elementData.add(e);
		return a.length != 0;
	}
	
	public boolean addAll(Collection<E/*=>TODO:? extends V*/> c) { return elementData.addAll(c); }
	
	public void fill(E element) { for (int pos = elementData.size(); --pos >= 0; ) elementData.set(pos, element); }
	
	public ArrayList<E> values() { return elementData; }
}
