//@formatter:off
/*
 * Auther: tukune
 * 
 * DON'T CODE FORMAT!
 * DON'T CONVERT TAB <---> SPACE
 * DON'T STRIP TRAILING BLANKS FROM END OF LINE
 */
package jp.sf.l2j.arrayMaps;

import static jp.sf.l2j.arrayMaps.SortedArrayMap.*;

import java.util.Arrays;
import java.util.Map;
import java.util.Map.Entry;

/*
 * @auther JOJO
 */
public class SortedIntIntArrayMap
{
	private int[] _keys;
	private int[] _values;
	public final int NULL;
	
	public SortedIntIntArrayMap()
	{
		this(INT_NULL);
	}
	
	public SortedIntIntArrayMap(int nullValue)
	{
		this(nullValue, INT_EMPTY, INT_EMPTY);
	}
	
	public SortedIntIntArrayMap(int[] keys, int[] values)
	{
		this(INT_NULL, keys, values);
	}
	
	public SortedIntIntArrayMap(int nullValue, int[] keys, int[] values)
	{
		NULL = nullValue;
		_keys = keys;
		_values = values;
		sort();
	}
	
	public SortedIntIntArrayMap(Map<Integer, Integer> t)
	{
		this(INT_NULL, t);
	}
	
	public SortedIntIntArrayMap(int nullValue, Map<Integer, Integer> t)
	{
		NULL = nullValue;
		int length = t.size();
		int[] tmpKeys = new int[length];
		int[] tmpValues = new int[length];
		
		Integer w;
		int index = 0;
		for (Entry<Integer, Integer> e : t.entrySet())
		{
			tmpKeys[index] = e.getKey();
			tmpValues[index] = (w = e.getValue()) == null ? NULL : w;
			++index;
		}
		_keys = tmpKeys;
		_values = tmpValues;
		sort();
	}
	
	public void clear()
	{
		_keys = INT_EMPTY;
		_values = INT_EMPTY;
	}
	
	public boolean containsKey(int key)
	{
		return Arrays.binarySearch(_keys, key) >= 0;
	}
	
	public boolean containsValue(int value)
	{
		for (int index = _values.length; --index >= 0;)
			if (_values[index] == value)
				return true;
		return false;
	}
	
	public int get(int key)
	{
		return getOrDefault(key, NULL);
	}
	
	public int getOrDefault(int key, int defaultValue)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return _values[index];
		else
			return defaultValue;
	}
	
	public boolean isEmpty()
	{
		return _keys.length == 0;
	}
	
	public int[] keySet()
	{
		return _keys;
	}
	
	public int[] keys()
	{
		return _keys;
	}
	
	public int put(int key, int value)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0) {
			int prev = _values[index];
			_values[index] = value;
			return prev;
		} else {
			return insertEntry(-(index + 1), key, value);
		}
	}
	
	public int putIfAbsent(int key, int value)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return _values[index];
		else
			return insertEntry(-(index + 1), key, value);
	}
	
	public void putAll(Map<Integer, Integer> t)
	{
		for (Entry<Integer, Integer> e : t.entrySet())
			put(e.getKey(), e.getValue());
	}
	
	public int remove(int key)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return deleteEntry(index);
		else
			return NULL;
	}
	
	public int size()
	{
		return _keys.length;
	}
	
	public int[] values()
	{
		return _values;
	}
	
	public SortedIntIntArrayMap append(int key, int value)
	{
		int prev = put(key, value);
		if (prev != NULL) throw new RuntimeException("Duplicate key:" + key + " value:" + value + " previus:" + prev);
		return this;
	}
	
	private int deleteEntry(int index)
	{
		final int length = _keys.length - 1;
		if (length < 0)
			return NULL;
		int[] tmpKeys = new int[length];
		int[] tmpValues = new int[length];
		if (index > 0) {
			System.arraycopy(_keys, 0, tmpKeys, 0, index);
			System.arraycopy(_values, 0, tmpValues, 0, index);
		}
		int n;
		if ((n = length - index) > 0) {
			System.arraycopy(_keys, index + 1, tmpKeys, index, n);
			System.arraycopy(_values, index + 1, tmpValues, index, n);
		}
		int prev = _values[index];
		_keys = tmpKeys;
		_values = tmpValues;
		return prev;
	}
	
	public int indexOf(int key)
	{
		return Arrays.binarySearch(_keys, key);
	}
	
	private int insertEntry(int index, int key, int value)
	{
		final int length = _keys.length;
		int[] tmpKeys = new int[length + 1];
		int[] tmpValues = new int[length + 1];
		if (index > 0) {
			System.arraycopy(_keys, 0, tmpKeys, 0, index);
			System.arraycopy(_values, 0, tmpValues, 0, index);
		}
		tmpKeys[index] = key;
		tmpValues[index] = value;
		int n;
		if ((n = length - index) > 0) {
			System.arraycopy(_keys, index, tmpKeys, index + 1, n);
			System.arraycopy(_values, index, tmpValues, index + 1, n);
		}
		_keys = tmpKeys;
		_values = tmpValues;
		return NULL;
	}
	
	public int keyAt(int index)
	{
		return _keys[index];
	}
	
	public int valueAt(int index)
	{
		return _values[index];
	}
	
	public int getKey(int index)
	{
		return keyAt(index);
	}
	
	public int getValue(int index)
	{
		return valueAt(index);
	}
	
	public int setValue(int index, int value)
	{
		int prev = _values[index];
		_values[index] = value;
		return prev;
	}
	
	public void fill(int value)
	{
		Arrays.fill(_values, value);
	}
	
	public void sort()
	{
		sort(0, _keys.length - 1);
	}
	
	private void sort(int left, int right)
	{
		if (left >= right) return;
		int pivot = _keys[(left + right) / 2];
		int i = left;
		int j = right;
		for (;;) {
			while (_keys[i] < pivot) ++i;
			while (pivot < _keys[j]) --j;
			if (i >= j) break;
			int key = _keys[i]; _keys[i] = _keys[j]; _keys[j] = key;
			int value = _values[i]; _values[i] = _values[j]; _values[j] = value;
			++i;
			--j;
		}
		sort(left,  i - 1);
		sort(j + 1, right);
	}
}
