/*****************************************************************************
 * H
 ****************************************************************************/
//@formatter:off
package quests.Q00620_FourGoblets;

import com.l2jserver.gameserver.enums.QuestType;
import com.l2jserver.gameserver.instancemanager.FourSepulchersManager;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.State;

/**
 * @author JOJO (java)
 * @author sandman (python script)
 */
public class Q00620_FourGoblets extends Quest
{
	private static final String qn = "Q00620_FourGoblets";
	
	// NPC
	private static final int NAMELESS_SPIRIT = 31453;	// 썰
	
	private static final int GHOST_OF_WIGOTH_1 = 31452;	// EBSbg̗H({X)
	private static final int GHOST_OF_WIGOTH_2 = 31454;	// EBSbg̗H(O)
	
	private static final int CONQ_SM = 31921;	// ҂̗_Ǘl
	private static final int EMPER_SM = 31922;	// xz҂̗_Ǘl
	private static final int SAGES_SM = 31923;	// 匫҂̗_Ǘl
	private static final int JUDGE_SM = 31924;	// R҂̗_Ǘl
	
	private static final int GHOST_CHAMBERLAIN_1 = 31919;	// GAf]̗H(҂̎@)
	private static final int GHOST_CHAMBERLAIN_2 = 31920;	// GAf]̗H(XSX̕)
	
	// ITEMS
	@SuppressWarnings("unused") private static final int ENTRANCE_PASS = 7075;		// _̒ʍs
	private static final int USED_PASS = 7261;			// gpς݂̗_̒ʍs
	private static final int GOBLET_OF_ALECTIA = 7256;	// ANeBA̔t
	private static final int GOBLET_OF_TISHAS  = 7257;	// eBVX̔t
	private static final int GOBLET_OF_MEKARA  = 7258;	// J̔t
	private static final int GOBLET_OF_MORIGUL = 7259;	// O̔t
	
	private static final int RELIC = 7254;				// ꂽ╨̔j
	private static final int SEALED_BOX = 7255;			// 󂳂ꂽ
	
	// REWARDS
	private static final int ANTIQUE_BROOCH = 7262;	// Âu[`
	private static final int[] RCP_REWARDS = { 6881, 6883, 6885, 6887, 7580, 6891, 6893, 6895, 6897, 6899 };	// 31454-16.htm
				// 6881 }FtH[Sbg u[h(60%)
				// 6883 }FoTg ogn}[(60%)
				// 6885 }FCyA X^bt(60%)
				// 6887 }FGWF XC[(60%)
				// 7580 }FhRjbN {E(60%)
				// 6891 }FhS n^[ AbNX(60%)
				// 6893 }FZCg XsA[(60%)
				// 6895 }Ff[ Xv^[(60%)
				// 6897 }FwX fBoC_[(60%)
				// 6899 }FAJi CX(60%)
	
	private Q00620_FourGoblets()
	{
		super(620, qn, "4̔t");
		registerQuestItems(ANTIQUE_BROOCH, SEALED_BOX, GOBLET_OF_ALECTIA, GOBLET_OF_TISHAS, GOBLET_OF_MEKARA, GOBLET_OF_MORIGUL, USED_PASS);
		
		addStartNpc(NAMELESS_SPIRIT);
		addTalkId(NAMELESS_SPIRIT);
		addTalkId(GHOST_OF_WIGOTH_1, GHOST_OF_WIGOTH_2, CONQ_SM, EMPER_SM, SAGES_SM, JUDGE_SM, GHOST_CHAMBERLAIN_1, GHOST_CHAMBERLAIN_2);
		addStartNpc(CONQ_SM, EMPER_SM, SAGES_SM, JUDGE_SM, GHOST_CHAMBERLAIN_1, GHOST_CHAMBERLAIN_2);
		
		for (int npcKillId = 18120; npcKillId <= 18255; ++npcKillId)
			addKillId(npcKillId);
	}
	
	// GOBLETS
	private long countGoblets(QuestState st)
	{
		return st.getQuestItemsCount(GOBLET_OF_ALECTIA)
			+ st.getQuestItemsCount(GOBLET_OF_TISHAS )
			+ st.getQuestItemsCount(GOBLET_OF_MEKARA )
			+ st.getQuestItemsCount(GOBLET_OF_MORIGUL);
	}
	private boolean hasFourGoblets(QuestState st)
	{
		return st.hasQuestItems(
			GOBLET_OF_ALECTIA,
			GOBLET_OF_TISHAS ,
			GOBLET_OF_MEKARA ,
			GOBLET_OF_MORIGUL);
	}
	private void takeAllGoblets(QuestState st)
	{
		st.takeItems(GOBLET_OF_ALECTIA, -1);
		st.takeItems(GOBLET_OF_TISHAS , -1);
		st.takeItems(GOBLET_OF_MEKARA , -1);
		st.takeItems(GOBLET_OF_MORIGUL, -1);
	}
	
	// REWARDS
	private boolean giveRandomRewards(QuestState st)
	{
		boolean reward = false;
		final int rnd = getRandom(5);
		if (rnd == 0) {
			st.giveItems(57, 10000);
			reward = true;
		}
		else if (rnd == 1) {
			if (getRandom(1000) < 848) {
				reward = true;
				int i = getRandom(1000);
				if      (i < 43)  st.giveItems(1884, 42);	// 
				else if (i < 66)  st.giveItems(1895, 36);	// @
				else if (i < 184) st.giveItems(1876, 4);	// ~X̌
				else if (i < 250) st.giveItems(1881, 6);	// t{[ pE_[
				else if (i < 287) st.giveItems(5549, 8);	// 
				else if (i < 484) st.giveItems(1874, 1);	// InŘ
				else if (i < 681) st.giveItems(1889, 1);	// R|Wbg Xgbv
				else if (i < 799) st.giveItems(1877, 1);	// A_}^Cg
				else if (i < 902) st.giveItems(1894, 1);	// U[
				else              st.giveItems(4043, 1);	// A\y
			}
			if (getRandom(1000) < 323) {
				reward = true;
				int i = getRandom(1000);
				if      (i < 335) st.giveItems(1888, 1);	// R[NX
				else if (i < 556) st.giveItems(4040, 1);	// ^̏
				else if (i < 725) st.giveItems(1890, 1);	// ~X
				else if (i < 872) st.giveItems(5550, 1);	// ⋭
				else if (i < 962) st.giveItems(1893, 1);	// InR
				else if (i < 986) st.giveItems(4046, 1);	// }GXg̋
				else              st.giveItems(4048, 1);	// }GXg̒^
			}
		}
		else if (rnd == 2) {
			if (getRandom(1000) < 847) {
				reward = true;
				int i = getRandom(1000);
				if      (i < 148) st.giveItems(1878, 8);	// n[h Xgbv
				else if (i < 175) st.giveItems(1882, 24);	// U[
				else if (i < 273) st.giveItems(1879, 4);	// R[NX
				else if (i < 322) st.giveItems(1880, 6);	// |S
				else if (i < 357) st.giveItems(1885, 6);	// XEF[h
				else if (i < 554) st.giveItems(1875, 1);	// s[t@C Xg[
				else if (i < 685) st.giveItems(1883, 1);	// |S̒^
				else if (i < 803) st.giveItems(5220, 1);	// 
				else if (i < 901) st.giveItems(4039, 1);	// ^̐ڒ
				else              st.giveItems(4044, 1);	// \Y
			}
			if (getRandom(1000) < 251) {
				reward = true;
				int i = getRandom(1000);
				if      (i < 350) st.giveItems(1887, 1);	// ̌
				else if (i < 587) st.giveItems(4042, 1);	// GA
				else if (i < 798) st.giveItems(1886, 1);	// ␻̒^
				else if (i < 922) st.giveItems(4041, 1);	// ^̋
				else if (i < 966) st.giveItems(1892, 1);	// b艮̌^
				else if (i < 996) st.giveItems(1891, 1);	// Eľ^
				else              st.giveItems(4047, 1);	// Ȟ^
			}
		}
		else if (rnd == 3) {
			if (getRandom(1000) < 31) {
				reward = true;
				int i = getRandom(1000);
				if      (i < 223) st.giveItems(730, 1);	// hXN[FAO[h
				else if (i < 893) st.giveItems(948, 1);	// hXN[FBO[h
				else              st.giveItems(960, 1);	// hXN[FSO[h
			}
			if (getRandom(1000) < 5) {
				reward = true;
				int i = getRandom(1000);
				if      (i < 202) st.giveItems(729, 1);	// 틭XN[FAO[h
				else if (i < 928) st.giveItems(947, 1);	// 틭XN[FBO[h
				else              st.giveItems(959, 1);	// 틭XN[FSO[h
			}
		}
		else if (rnd == 4) {
			if (getRandom(1000) < 329) {
				reward = true;
				int i = getRandom(1000);
				if      (i < 88)  st.giveItems(6698, 1);	// 󂳂ꂽ^eIVA CAǑ
				else if (i < 185) st.giveItems(6699, 1);	// 󂳂ꂽ^eIVA ÕWF
				else if (i < 238) st.giveItems(6700, 1);	// 󂳂ꂽ^eIVA lbNX̃`F[
				else if (i < 262) st.giveItems(6701, 1);	// 󂳂ꂽCyA NZC_[ A[}[̌
				else if (i < 292) st.giveItems(6702, 1);	// 󂳂ꂽCyA NZC_[ Q[g̃p^[
				else if (i < 356) st.giveItems(6703, 1);	// 󂳂ꂽCyA NZC_[ Kgbǧ^
				else if (i < 420) st.giveItems(6704, 1);	// 󂳂ꂽCyA NZC_[ u[č^
				else if (i < 482) st.giveItems(6705, 1);	// 󂳂ꂽCyA NZC_[ V[ȟ
				else if (i < 554) st.giveItems(6706, 1);	// 󂳂ꂽCyA NZC_[ w̃p^[
				else if (i < 576) st.giveItems(6707, 1);	// 󂳂ꂽhRjbN U[ A[}[̌
				else if (i < 640) st.giveItems(6708, 1);	// 󂳂ꂽhRjbN U[ O[u̍ޗ
				else if (i < 704) st.giveItems(6709, 1);	// 󂳂ꂽhRjbN U[ u[č^
				else if (i < 777) st.giveItems(6710, 1);	// 󂳂ꂽhRjbN U[ w̃p^[
				else if (i < 799) st.giveItems(6711, 1);	// 󂳂ꂽW[ AJi [u̔j
				else if (i < 863) st.giveItems(6712, 1);	// 󂳂ꂽW[ AJi O[u̍ޗ
				else if (i < 927) st.giveItems(6713, 1);	// 󂳂ꂽW[ AJi u[č^
				else              st.giveItems(6714, 1);	// 󂳂ꂽW[ AJi T[Nbg̃p^[
			}
			if (getRandom(1000) < 54) {
				reward = true;
				int i = getRandom(1000);
				if      (i < 100) st.giveItems(6688, 1);	// tH[Sbg u[h̓g
				else if (i < 198) st.giveItems(6689, 1);	// oTg ogn}[̓
				else if (i < 298) st.giveItems(6690, 1);	// CyA X^bť
				else if (i < 398) st.giveItems(6691, 1);	// GWF XC[̓g
				else if (i < 499) st.giveItems(7579, 1);	// hRjbN {ẼVtg
				else if (i < 601) st.giveItems(6693, 1);	// hS n^[ AbNX̓g
				else if (i < 703) st.giveItems(6694, 1);	// ZCg XsA[̓g
				else if (i < 801) st.giveItems(6695, 1);	// f[ Xv^[̓g
				else if (i < 902) st.giveItems(6696, 1);	// wX fBoC_[̓g
				else              st.giveItems(6697, 1);	// AJi CX̓
			}
		}
		return reward;
	}
	
	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		String htmltext = Quest.getNoQuestMsg(player);
		final QuestState st = player.getQuestState(qn);
		if (st.getState() == State.CREATED)
			st.set("cond", "0");
		final int cond;
		
		switch (npc.getId()) {
		case NAMELESS_SPIRIT:
			cond = st.getInt("cond");
			if (cond == 0) {
				if (st.getPlayer().getLevel() >= 74) {
					htmltext = "31453-1.htm";
				}
				else {
					htmltext = "31453-12.htm";
					st.exitQuest(QuestType.REPEATABLE);
				}
			}
			else if (cond == 1) {
				if (hasFourGoblets(st))
					htmltext = "31453-15.htm";
				else
					htmltext = "31453-14.htm";
			}
			else if (cond == 2) {
				htmltext = "31453-17.htm";
			}
			break;
		case GHOST_OF_WIGOTH_1:
			cond = st.getInt("cond");
			if (cond == 1) {
				final long goblets = countGoblets(st);
				if (goblets == 1)
					htmltext = "31452-1.htm";
				else if (goblets > 1)
					htmltext = "31452-2.htm";
			}
			else if (cond == 2) {
				htmltext = "31452-2.htm";
			}
			break;
		case GHOST_OF_WIGOTH_2:
			if (st.getQuestItemsCount(RELIC) >= 1000) {
				if (st.getQuestItemsCount(SEALED_BOX) >= 1) {
					if (hasFourGoblets(st))
						htmltext = "31454-4.htm";
					else if (countGoblets(st) > 1)
						htmltext = "31454-8.htm";
					else
						htmltext = "31454-12.htm";
				}
				else {
					if (hasFourGoblets(st))
						htmltext = "31454-3.htm";
					else if (countGoblets(st) > 1)
						htmltext = "31454-7.htm";
					else
						htmltext = "31454-11.htm";
				}
			}
			else {
				if (st.getQuestItemsCount(SEALED_BOX) >= 1) {
					if (hasFourGoblets(st))
						htmltext = "31454-2.htm";
					else if (countGoblets(st) > 1)
						htmltext = "31454-6.htm";
					else
						htmltext = "31454-10.htm";
				}
				else {
					if (hasFourGoblets(st))
						htmltext = "31454-1.htm";
					else if (countGoblets(st) > 1)
						htmltext = "31454-5.htm";
					else
						htmltext = "31454-9.htm";
				}
			}
			break;
			
		case CONQ_SM:
			htmltext = "31921-E.htm";
			break;
		case EMPER_SM:
			htmltext = "31922-E.htm";
			break;
		case SAGES_SM:
			htmltext = "31923-E.htm";
			break;
		case JUDGE_SM:
			htmltext = "31924-E.htm";
			break;
		case GHOST_CHAMBERLAIN_1:
			htmltext = "31919-1.htm";
			break;
		} // switch
		return htmltext;
	}
	
	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isSummon)
	{
		final QuestState st = killer.getQuestState(qn);
		if (st != null) {
			final int cond = st.getInt("cond");
			if (cond == 1 || cond == 2) {
				if (getRandom(100) < 30) {
					st.giveItems(SEALED_BOX, 1);
					st.playSound(com.l2jserver.gameserver.enums.QuestSound.ITEMSOUND_QUEST_ITEMGET);
				}
			}
		}
		return null;
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		final QuestState st = player.getQuestState(qn);
		String htmltext = event;
		if (event.equals("Enter")) {
			// 31921-E.htm <Α̏ɎڂĐ_W> ҂̗_Ǘl
			// 31922-E.htm <Α̏ɎڂĐ_W> xz҂̗_Ǘl
			// 31923-E.htm <Α̏ɎڂĐ_W> 匫҂̗_Ǘl
			// 31924-E.htm <Α̏ɎڂĐ_W> R҂̗_Ǘl
			FourSepulchersManager.getInstance().tryEntry(npc, player);
			return null;
		}
		
		if (st == null) return null;
		
		switch (event) {
		case "accept":
			// 31453-11.htm <`ƌ> 썰
			if (st.getInt("cond") == 0) {
				if (st.getPlayer().getLevel() >= 74) {
					st.setState(State.STARTED);
					st.playSound(com.l2jserver.gameserver.enums.QuestSound.ITEMSOUND_QUEST_ACCEPT);
					htmltext = "31453-13.htm";
					st.set("cond", "1");
				}
				else {
					htmltext = "31453-12.htm";
					st.exitQuest(QuestType.REPEATABLE);
				}
			}
			break;
		case "11":
			// 31454-2.htm  <JĂƌ> EBSbg̗H
			// 31454-4.htm  <JĂƌ> EBSbg̗H
			// 31454-6.htm  <JĂƌ> EBSbg̗H
			// 31454-8.htm  <JĂƌ> EBSbg̗H
			// 31454-10.htm <JĂƌ> EBSbg̗H
			// 31454-12.htm <JĂƌ> EBSbg̗H
			if (takeItems(st.getPlayer(), SEALED_BOX, 1)) {
				if (giveRandomRewards(st))
					htmltext = "31454-13.htm";
				else if (getRandom(2) == 0)
					htmltext = "31454-14.htm";
				else
					htmltext = "31454-15.htm";
			}
			break; // "11"
		case "12":
			// 31453-15a.htm <ul̎vƁH> 썰
			if (hasFourGoblets(st)) {
				takeAllGoblets(st);
				st.giveItems(ANTIQUE_BROOCH, 1);
				st.set("cond", "2");
				st.playSound(com.l2jserver.gameserver.enums.QuestSound.ITEMSOUND_QUEST_FINISH);
				htmltext = "31453-16.htm";
			}
			else {
				htmltext = "31453-14.htm";
			}
			break;
		case "13":
			// 31453-14.htm <߂> 썰
			// 31453-16.htm <߂> 썰
			// 31453-17.htm <߂> 썰
			st.playSound(com.l2jserver.gameserver.enums.QuestSound.ITEMSOUND_QUEST_FINISH);
			st.exitQuest(QuestType.REPEATABLE);
			htmltext = "31453-18.htm";
			break;
		case "14":
			// 31453-14.htm <܂ƌ> 썰
			// 31453-16.htm <܂ƌ> 썰
			// 31453-17.htm <܂ƌ> 썰
			if (st.getInt("cond") == 2)
				htmltext = "31453-19.htm";
			else
				htmltext = "31453-13.htm";
			break;
		case "15":
			// data/html/SepulcherNpc/31919.htm <l_Ƀe|[g> GAf]̗H
			// data/html/SepulcherNpc/31920.htm <l_Ƀe|[g> GAf]̗H
			// Ghost Chamberlain of Elmoreden: Teleport to 4th sepulcher
			if (hasQuestItems(st.getPlayer(), ANTIQUE_BROOCH)
			 || takeItems(st.getPlayer(), USED_PASS, 1)) {
				st.getPlayer().teleToLocation(178298, -84574, -7216);
				htmltext = null;
			}
			else {
				htmltext = npc.getId() + "-0.htm";	// 31919-0.htm | 31920-0.htm
			}
			break;
		case "16":
			// data/html/SepulcherNpc/31919.htm <鍑̕n̓Ƀe|[g> GAf]̗H
			// data/html/SepulcherNpc/31920.htm <鍑̕n̓Ƀe|[g> GAf]̗H
			// Ghost Chamberlain of Elmoreden: Teleport to Imperial Tomb entrance
			if (hasQuestItems(st.getPlayer(), ANTIQUE_BROOCH)
			 || takeItems(st.getPlayer(), USED_PASS, 1)) {
				st.getPlayer().teleToLocation(186942, -75602, -2834);
				htmltext = null;
			}
			else {
				htmltext = npc.getId() + "-0.htm";	// 31919-0.htm | 31920-0.htm
			}
			break;
		case "17":
			// 31452-1.htm <Eo> EBSbg̗H
			// 31452-3.htm <Eo> EBSbg̗H
			// 31452-4.htm <Eo> EBSbg̗H
			// 31452-5.htm <Eo> EBSbg̗H
			// Teleport to Pilgrims Temple
		//	if (!hasQuestItems(st.getPlayer(), ANTIQUE_BROOCH))	//TODO:vmF
		//		takeItems(st.getPlayer(), USED_PASS, 1);		//TODO:vmF
			st.getPlayer().teleToLocation(169590, -90218, -2914);
			htmltext = "31452-6.htm";
			break;
		case "18":
			// 31452-2.htm <Do you know them?> EBSbg̗H
			final long goblets = countGoblets(st);
			if (goblets <= 2)
				htmltext = "31452-3.htm";
			else if (goblets <= 3)
				htmltext = "31452-4.htm";
			else
				htmltext = "31452-5.htm";
			break;
		case "19":
			// 31919-1.htm <Jė~ƌ> GAf]̗H
			if (takeItems(st.getPlayer(), SEALED_BOX, 1)) {
				if (giveRandomRewards(st))
					htmltext = "31919-3.htm";
				else if (getRandom(2) == 0)
					htmltext = "31919-4.htm";
				else
					htmltext = "31919-5.htm";
			}
			else {
				htmltext = "31919-6.htm";
			}
			break;
		default:
			if (com.l2jserver.gameserver.util.Util.isDigit(event)) {
				final int itemId = Integer.parseInt(event);
				if (com.l2jserver.gameserver.util.Util.contains(RCP_REWARDS, itemId)) {
					// 31454-16.htm (}) EBSbg̗H
					if (takeItems(st.getPlayer(), RELIC, 1000)) {
						st.giveItems(itemId, 1);
						htmltext = "31454-17.htm";
					}
					break; // break switch
				}
			}
			_log.warning("Q00620_FourGoblets: onAdvEvent(" + event + "," + (npc == null ? "NULL" : npc.getId() + npc.getName()) + "," + player.getName() + ")");
			break;
		} // end switch
		return htmltext;
	}
	
	@Override
	public String showHtmlFile(L2PcInstance player, String filename, L2Npc npc, boolean questwindow)
	{
		QuestState st = player.getQuestState(qn);
		return super.showHtmlFile(player, filename, npc, st != null && st.isCreated());
	}
	
	public static void main(String[] args)
	{
		new Q00620_FourGoblets();
	}
}
