# Made by disKret
import sys
from com.l2jserver.gameserver.model.quest import State
from com.l2jserver.gameserver.model.quest import QuestState
from com.l2jserver.gameserver.model.quest import Quest as JQuest
from com.l2jserver.gameserver.enums import QuestSound
qn = "356_DigUpTheSeaOfSpores"

#NPC
GAUEN = 30717

#MOBS
SPORE_ZOMBIE = 20562
ROTTING_TREE = 20558

#QUEST ITEMS
CARNIVORE_SPORE = 5865
HERBIBOROUS_SPORE = 5866

class Quest (JQuest) :

 def __init__(self,id,name,descr):
     JQuest.__init__(self,id,name,descr)
     self.questItemIds = [CARNIVORE_SPORE, HERBIBOROUS_SPORE]

 def onEvent (self,event,st) :
   htmltext = event
   carn=st.getQuestItemsCount(CARNIVORE_SPORE)
   herb=st.getQuestItemsCount(HERBIBOROUS_SPORE)
   if event == "30717-5.htm" :
     if st.getPlayer().getLevel() >= 43 :
       st.set("cond","1")
       st.setState(State.STARTED)
       st.playSound(QuestSound.ITEMSOUND_QUEST_ACCEPT)
     else :
       htmltext = "30717-4.htm"
       st.exitQuest(1)
   elif event in [ "30717-10.htm", "30717-9.htm" ] and (carn>=50 and herb>=50) :
     if event == "30717-9.htm" :
        st.giveItems(57,44000)
     else :
        st.addExpAndSp(36000,2600)
     st.takeItems(CARNIVORE_SPORE,-1)
     st.takeItems(HERBIBOROUS_SPORE,-1)
     st.playSound(QuestSound.ITEMSOUND_QUEST_FINISH)
     st.exitQuest(1)
   return htmltext

 def onTalk (self,npc,player):
   htmltext = Quest.getNoQuestMsg(player)
   st = player.getQuestState(qn)
   if not st : return htmltext

   npcId = npc.getId()
   id = st.getState()
   cond = st.getInt("cond")
   carn=st.getQuestItemsCount(CARNIVORE_SPORE)
   herb=st.getQuestItemsCount(HERBIBOROUS_SPORE)
   if cond == 0 :
     htmltext = "30717-0.htm"
   elif cond != 3 :
     htmltext = "30717-6.htm"
   elif cond == 3 or (carn>=50 and herb>=50) :
     htmltext = "30717-7.htm"
   return htmltext

 def onKill(self,npc,player,isPet):
   st = player.getQuestState(qn)
   if not st : return 
   if st.getState() != State.STARTED : return 
   
   npcId = npc.getId()
   carn=st.getQuestItemsCount(CARNIVORE_SPORE)
   herb=st.getQuestItemsCount(HERBIBOROUS_SPORE)
   if npcId == SPORE_ZOMBIE and carn < 50 :
     st.giveItems(CARNIVORE_SPORE,1)
     if carn == 49 :
       if herb >= 50 :
         st.playSound(QuestSound.ITEMSOUND_QUEST_MIDDLE)
         st.set("cond","3")
       else :
         st.playSound(QuestSound.ITEMSOUND_QUEST_MIDDLE)
         st.set("cond","2")
     else :
       st.playSound(QuestSound.ITEMSOUND_QUEST_ITEMGET)
   elif npcId == ROTTING_TREE and herb < 50 :
     st.giveItems(HERBIBOROUS_SPORE,1)
     if herb == 49 :
       if carn >= 50 :
         st.playSound(QuestSound.ITEMSOUND_QUEST_MIDDLE)
         st.set("cond","3")
       else :
         st.playSound(QuestSound.ITEMSOUND_QUEST_MIDDLE)
         st.set("cond","2")
     else:
       st.playSound(QuestSound.ITEMSOUND_QUEST_ITEMGET)
   return

QUEST       = Quest(356,qn,'Eq̊CnI')

QUEST.addStartNpc(GAUEN)

QUEST.addTalkId(GAUEN)

QUEST.addKillId(SPORE_ZOMBIE)
QUEST.addKillId(ROTTING_TREE)