/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.individual;

import javolution.lang.MathLib;
import ai.npc.AbstractNpcAI;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.util.Rnd;

public final class FleeNpc extends AbstractNpcAI
{
	private static final int[] MOBS =
	{
		20432,	// Gs[ L2Monster
		22228,	// OC Gs[ L2Monster
	};
	
	private FleeNpc()
	{
		super(FleeNpc.class.getSimpleName(), "ai/individual");
		addAttackId(MOBS);
		addSpawnId(MOBS);
		
		// Disable L2AttackableAIScript.
		Quest attackableAIScript = QuestManager.getInstance().getQuest("L2AttackableAIScript");
		for (int npcId : MOBS)
		{
			L2NpcTemplate t = NpcData.getInstance().getTemplate(npcId);
			t.removeQuest(attackableAIScript);
		}
	}
	
	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isSummon)
	{
		L2Attackable mob = (L2Attackable) npc;
		if (mob.isMovementDisabled())
		{
			return null;
		}
		if (mob.getAI().getIntention() == CtrlIntention.AI_INTENTION_MOVE_TO && !(npc.getXdestination() == npc.getSpawn().getX() && npc.getYdestination() == npc.getSpawn().getY()))
		{
			return null;
		}
		
		flee(npc, attacker, 100, 300);
		return null;
	}
	
	private void flee(L2Npc npc, L2PcInstance attacker, int min, int max)
	{
		double r = Rnd.get(min, max);
		double a = Math.atan2(npc.getY() - attacker.getY(), npc.getX() - attacker.getX());
		int x = npc.getX() + (int) Math.round(r * Math.cos(a));
		int y = npc.getY() + (int) Math.round(r * Math.sin(a));
		int z = npc.getZ();
		int h = (int) Math.round(a * 65536 / MathLib.TWO_PI);
		if (Config.GEODATA > 0)
		{
			Location destiny = GeoData.getInstance().moveCheck(npc.getX(), npc.getY(), npc.getZ(), x, y, z, npc.getInstanceId());
			x = destiny.getX();
			y = destiny.getY();
			z = destiny.getZ();
		}
		npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new Location(x, y, z, h));
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		npc.disableCoreAI(true);
		return super.onSpawn(npc);
	}
	
	// Register the new Script at the Script System
	public static void main(String[] args)
	{
		new FleeNpc();
	}
}
