## Active Perl 5.8.8 ～ 5.10.1

# カスタムNPCバッファ用
# NpcBuffer-41.htm、NpcBuffer-42.htm を生成する
# NpcBuffer-41_ja.txt、NpcBuffer-42_ja.txt がテンプレート

use utf8;
use strict;
use warnings;
use Encode;
use DBI;
use Jcode;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $vars_txt = '../../../tools/vars.txt';
open FILE,'<',$vars_txt  or do {warn "'$vars_txt' $!";exit 0};
read FILE,my $vars,-s FILE;
close FILE;
my $gsuser = ($vars =~ m/^\@*set gsuser=(.+)$/m)[0];
my $gspass = ($vars =~ m/^@*set gspass=(.+)$/m)[0];
my $gsdb   = ($vars =~ m/^@*set gsdb=(.+)$/m)[0];
my $gshost = ($vars =~ m/^@*set gshost=(.+)$/m)[0];

my $DEBUG = 0; # 1 or 0

my $db = DBI->connect("DBI:mysql:$gsdb:$gshost", $gsuser, $gspass, {mysql_enable_utf8=>1}) or do{warn DBI::errstr;exit 0};
   $db->do('SET NAMES UTF8');

&start('', 'NpcBuffer-41_ja.txt', 'NpcBuffer-41.htm');
&start('', 'NpcBuffer-42_ja.txt', 'NpcBuffer-42.htm');

exit 0;

sub start {
	my ($subDir, $fileName, $outName) = @_;

	my $filePath = $subDir.$fileName;
	my $outPath  = $subDir.$outName;

	print "$filePath:\n";
	open FILE, '<:utf8', FS($filePath) or die "'$filePath' $!";
	read FILE,my $text,-s FILE;
	close FILE;

	my $original = $text;

	if ($text =~ m!\%LIST\%!) {
		# <a action="bypass -h npc_%objectId%_Buff 264 266 268 269 271 274 275 304 310 1036 1040 1045 1062 1068 1077 1086 1240 1242" value="Fighter" width=200 height=21 back="L2UI_ct1.button_df" fore="L2UI_ct1.button_df"><br>
		# <a action="bypass -h npc_%objectId%_Buff 264 266 268 273 276 304 1035 1040 1045 1048 1062 1085 1240" value="Mage" width=200 height=21 back="L2UI_ct1.button_df" fore="L2UI_ct1.button_df"><br>
		if ($text =~ m!<a action="bypass -h npc_\%objectId\%_Buff ([0-9 ]+)"!) {
			my $command = $1;
			my @buffGroupArray = split(/ /, $command);
			my $totalFee = 0;
			my $list = '';

			for (my $i=0; $i <= $#buffGroupArray; ++$i) {
				my $id = $buffGroupArray[$i];
				my($name_jp,$fee) = &getNameAndFee($id);
				die "'$fileName' group '$id' skill notfound." unless $name_jp;
				$list .= "$name_jp<BR1>\n";
				$totalFee += $fee;
				print "$name_jp\t$fee\n";
			}
			$list =~ s!<BR1>\n$!!;

			$text =~ s!\%LIST\%!$list! if $list;
			$text =~ s!\%FEE\%!$totalFee!;
		}
		else {
			die "'$fileName' No action tag."
		}
	}

	if ($original ne $text) {
		open FILE, '>:utf8', FS($outPath) or die "'$outPath' $!";
		print FILE $text;
		close FILE;
	}
}

sub getNameAndFee {
	my ($buff_group) = @_;

	my $sql = "SELECT skillname_ja.name,custom_npc_buffer.skill_level,custom_npc_buffer.skill_fee_amount FROM custom_npc_buffer
 LEFT JOIN skillname_ja
  ON ( custom_npc_buffer.skill_id   =skillname_ja.id
   AND custom_npc_buffer.skill_level=skillname_ja.level )
 WHERE custom_npc_buffer.buff_group=?";
	my $sth = $db->prepare($sql);
	$sth->execute($buff_group) or die DBI::errstr;
	$sth->bind_columns(undef, \(my($N_name,$N_level,$N_fee))) or die DBI::errstr;
	my $rc = $sth->fetch();

	return ('',0) unless $N_name;
	$N_name = Encode::decode_utf8(Jcode->new($N_name, 'utf8')->z2h->utf8) . " Lv$N_level";
	return ($N_name, $N_fee)
}
