/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.Config;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public abstract class FloodProtectedListener
extends Thread {
    private final Logger _log = Logger.getLogger(FloodProtectedListener.class.getName());
    private final Map<String, ForeignConnection> _floodProtection = new FastMap();
    private final String _listenIp;
    private final int _port;
    private ServerSocket _serverSocket;

    public FloodProtectedListener(String listenIp, int port) throws IOException {
        this._port = port;
        this._listenIp = listenIp;
        this._serverSocket = this._listenIp.equals("*") ? new ServerSocket(this._port) : new ServerSocket(this._port, 50, InetAddress.getByName(this._listenIp));
    }

    @Override
    public void run() {
        Socket connection = null;
        while (!this.isInterrupted()) {
            try {
                connection = this._serverSocket.accept();
                if (Config.FLOOD_PROTECTION) {
                    ForeignConnection fConnection = this._floodProtection.get(connection.getInetAddress().getHostAddress());
                    if (fConnection != null) {
                        ++fConnection.connectionNumber;
                        if (fConnection.connectionNumber > Config.FAST_CONNECTION_LIMIT && System.currentTimeMillis() - fConnection.lastConnection < (long)Config.NORMAL_CONNECTION_TIME || System.currentTimeMillis() - fConnection.lastConnection < (long)Config.FAST_CONNECTION_TIME || fConnection.connectionNumber > Config.MAX_CONNECTION_PER_IP) {
                            fConnection.lastConnection = System.currentTimeMillis();
                            connection.close();
                            --fConnection.connectionNumber;
                            if (!fConnection.isFlooding) {
                                this._log.warning("Potential Flood from " + connection.getInetAddress().getHostAddress());
                            }
                            fConnection.isFlooding = true;
                            continue;
                        }
                        if (fConnection.isFlooding) {
                            fConnection.isFlooding = false;
                            this._log.info(connection.getInetAddress().getHostAddress() + " is not considered as flooding anymore.");
                        }
                        fConnection.lastConnection = System.currentTimeMillis();
                    } else {
                        fConnection = new ForeignConnection(System.currentTimeMillis());
                        this._floodProtection.put(connection.getInetAddress().getHostAddress(), fConnection);
                    }
                }
                this.addClient(connection);
            }
            catch (Exception e) {
                if (!this.isInterrupted()) continue;
                try {
                    this._serverSocket.close();
                }
                catch (IOException io) {
                    this._log.log(Level.INFO, "", io);
                }
                break;
            }
        }
    }

    public abstract void addClient(Socket var1);

    public void removeFloodProtection(String ip) {
        if (!Config.FLOOD_PROTECTION) {
            return;
        }
        ForeignConnection fConnection = this._floodProtection.get(ip);
        if (fConnection != null) {
            --fConnection.connectionNumber;
            if (fConnection.connectionNumber == 0) {
                this._floodProtection.remove(ip);
            }
        } else {
            this._log.warning("Removing a flood protection for a GameServer that was not in the connection map??? :" + ip);
        }
    }

    public void close() {
        try {
            this._serverSocket.close();
        }
        catch (IOException e) {
            this._log.warning(this.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    protected static class ForeignConnection {
        public int connectionNumber;
        public long lastConnection;
        public boolean isFlooding = false;

        public ForeignConnection(long time) {
            this.lastConnection = time;
            this.connectionNumber = 1;
        }
    }
}

