/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.IProcedure;
import com.l2jserver.gameserver.network.serverpackets.CharInfo;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.RelationChanged;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Broadcast {
    private static Logger _log = Logger.getLogger(Broadcast.class.getName());

    public static void toPlayersTargettingMyself(L2Character character, L2GameServerPacket mov) {
        Collection plrs = character.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player.getTarget() != character) continue;
            player.sendPacket(mov);
        }
    }

    public static void toKnownPlayers(L2Character character, L2GameServerPacket mov) {
        Collection plrs = character.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null) continue;
            try {
                player.sendPacket(mov);
                if (!(mov instanceof CharInfo) || !(character instanceof L2PcInstance)) continue;
                int relation = ((L2PcInstance)character).getRelation(player);
                Integer oldrelation = (Integer)character.getKnownList().getKnownRelations().get(player.getObjectId());
                if (oldrelation == null || oldrelation == relation) continue;
                player.sendPacket(new RelationChanged((L2PcInstance)character, relation, character.isAutoAttackable(player)));
                if (!character.hasSummon()) continue;
                player.sendPacket(new RelationChanged(character.getSummon(), relation, character.isAutoAttackable(player)));
            }
            catch (NullPointerException e) {
                _log.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public static void toKnownPlayersInRadius(L2Character character, L2GameServerPacket mov, int radius) {
        if (radius < 0) {
            radius = 1500;
        }
        Collection plrs = character.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (!character.isInsideRadius(player, radius, false, false)) continue;
            player.sendPacket(mov);
        }
    }

    public static void toSelfAndKnownPlayers(L2Character character, L2GameServerPacket mov) {
        if (character instanceof L2PcInstance) {
            character.sendPacket(mov);
        }
        Broadcast.toKnownPlayers(character, mov);
    }

    public static void toSelfAndKnownPlayersInRadius(L2Character character, L2GameServerPacket mov, int radius) {
        if (radius < 0) {
            radius = 600;
        }
        if (character instanceof L2PcInstance) {
            character.sendPacket(mov);
        }
        Collection plrs = character.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !Util.checkIfInRange(radius, character, player, false)) continue;
            player.sendPacket(mov);
        }
    }

    public static void toAllOnlinePlayers(L2GameServerPacket mov) {
        L2World.getInstance().forEachPlayer(new ForEachPlayerBroadcast(mov));
    }

    public static void announceToOnlinePlayers(String text, boolean isCritical) {
        CreatureSay cs = isCritical ? new CreatureSay(0, 18, "", text) : new CreatureSay(0, 10, "", text);
        Broadcast.toAllOnlinePlayers(cs);
    }

    public static void announceToOnlinePlayers(String text) {
        Broadcast.toAllOnlinePlayers(new CreatureSay(0, 10, "", text));
    }

    public static void announceToOnlinePlayers(SystemMessage message) {
        Broadcast.toAllOnlinePlayers(message);
    }

    public static void toPlayersInInstance(L2GameServerPacket mov, int instanceId) {
        L2World.getInstance().forEachPlayer(new ForEachPlayerInInstanceBroadcast(mov, instanceId));
    }

    private static final class ForEachPlayerInInstanceBroadcast
    implements IProcedure<L2PcInstance, Boolean> {
        private final L2GameServerPacket _packet;
        private final int _instanceId;

        protected ForEachPlayerInInstanceBroadcast(L2GameServerPacket packet, int instanceId) {
            this._packet = packet;
            this._instanceId = instanceId;
        }

        public final boolean execute(L2PcInstance onlinePlayer) {
            if (onlinePlayer != null && onlinePlayer.isOnline() && onlinePlayer.getInstanceId() == this._instanceId) {
                onlinePlayer.sendPacket(this._packet);
            }
            return true;
        }
    }

    private static final class ForEachPlayerBroadcast
    implements IProcedure<L2PcInstance, Boolean> {
        L2GameServerPacket _packet;

        protected ForEachPlayerBroadcast(L2GameServerPacket packet) {
            this._packet = packet;
        }

        public final boolean execute(L2PcInstance onlinePlayer) {
            if (onlinePlayer != null && onlinePlayer.isOnline()) {
                onlinePlayer.sendPacket(this._packet);
            }
            return true;
        }
    }
}

