/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager.tasks;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import java.util.Calendar;

public class TaskClanLeaderApply
extends Task {
    private static final String NAME = "clanleaderapply";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void onTimeElapsed(TaskManager.ExecutedTask task) {
        Calendar cal = Calendar.getInstance();
        if (cal.get(7) == Config.ALT_CLAN_LEADER_DATE_CHANGE) {
            for (L2Clan clan : ClanTable.getInstance().getClans()) {
                L2ClanMember member;
                if (clan.getNewLeaderId() == 0 || (member = clan.getClanMember(clan.getNewLeaderId())) == null) continue;
                clan.setNewLeader(member);
            }
            this._log.info(this.getClass().getSimpleName() + ": launched.");
        }
    }

    @Override
    public void initializate() {
        TaskManager.addUniqueTask(NAME, TaskTypes.TYPE_GLOBAL_TASK, "1", Config.ALT_CLAN_LEADER_HOUR_CHANGE, "");
    }
}

