/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DateRange {
    protected static final Logger _log = Logger.getLogger(DateRange.class.getName());
    private final Date _startDate;
    private final Date _endDate;
    private static SimpleDateFormat format_date_short_JP = new SimpleDateFormat("yyyy/MM/dd", Locale.JAPAN);
    private static SimpleDateFormat format_date_long_JP = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.JAPAN);

    public DateRange(Date from, Date to) {
        this._startDate = from;
        this._endDate = to;
    }

    public static DateRange parse(String dateRange, DateFormat format) {
        String[] date = dateRange.split("-");
        if (date.length == 2 && date[0].contains("****") && date[1].contains("****")) {
            Calendar now = Calendar.getInstance();
            String year = String.valueOf(now.get(1));
            date[0] = date[0].replace("****", year);
            date[1] = date[1].replace("****", year);
            DateRange range = DateRange._parse(date[0] + "-" + date[1], format);
            if (range.getStartDate() == null || range.getEndDate() == null) {
                return range;
            }
            GregorianCalendar startDate = new GregorianCalendar();
            GregorianCalendar endDate = new GregorianCalendar();
            startDate.setTime(range.getStartDate());
            endDate.setTime(range.getEndDate());
            if (startDate.after(endDate)) {
                startDate.add(1, -1);
            }
            if (now.after(endDate)) {
                startDate.add(1, 1);
                endDate.add(1, 1);
            }
            return new DateRange(startDate.getTime(), endDate.getTime());
        }
        return DateRange._parse(dateRange, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateRange _parse(String dateRange, DateFormat format) {
        String[] date = dateRange.split("-");
        if (date.length == 2) {
            SimpleDateFormat format0;
            DateFormat dateFormat = date[0].matches("\\d{4}/\\d{1,2}/\\d{1,2}") ? format_date_short_JP : (format0 = date[0].matches("\\d{4}/\\d{1,2}/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}") ? format_date_long_JP : format);
            SimpleDateFormat format1 = date[1].matches("\\d{4}/\\d{1,2}/\\d{1,2}") ? format_date_short_JP : (date[1].matches("\\d{4}/\\d{1,2}/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}") ? format_date_long_JP : format);
            try {
                Date end;
                Date start;
                SimpleDateFormat simpleDateFormat = format0;
                synchronized (simpleDateFormat) {
                    start = format0.parse(date[0]);
                }
                simpleDateFormat = format1;
                synchronized (simpleDateFormat) {
                    end = format1.parse(date[1]);
                }
                return new DateRange(start, end);
            }
            catch (ParseException e) {
                _log.log(Level.WARNING, "Invalid Date Format.", e);
            }
        }
        return new DateRange(null, null);
    }

    public boolean isValid() {
        return this._startDate != null && this._endDate != null && this._startDate.before(this._endDate);
    }

    public boolean isWithinRange(Date date) {
        return date.after(this._startDate) && date.before(this._endDate);
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public String toString() {
        return "DateRange: From: " + this.getStartDate() + " To: " + this.getEndDate();
    }
}

