/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.TradeItem;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.AbstractItemPacket;

public class PrivateStoreManageListSell
extends AbstractItemPacket {
    private final int _objId;
    private final long _playerAdena;
    private final boolean _packageSale;
    private final TradeItem[] _itemList;
    private final TradeItem[] _sellList;

    public PrivateStoreManageListSell(L2PcInstance player, boolean isPackageSale) {
        this._objId = player.getObjectId();
        this._playerAdena = player.getAdena();
        player.getSellList().updateItems();
        this._packageSale = isPackageSale;
        this._itemList = player.getInventory().getAvailableItems(player.getSellList());
        this._sellList = player.getSellList().getItems();
    }

    @Override
    protected final void writeImpl() {
        this.writeC(160);
        this.writeD(this._objId);
        this.writeD(this._packageSale ? 1 : 0);
        this.writeQ(this._playerAdena);
        this.writeD(this._itemList.length);
        for (TradeItem item : this._itemList) {
            this.writeItem(item);
            this.writeQ(item.getItem().getReferencePrice() * 2);
        }
        this.writeD(this._sellList.length);
        for (TradeItem item : this._sellList) {
            this.writeItem(item);
            this.writeQ(item.getPrice());
            this.writeQ(item.getItem().getReferencePrice() * 2);
        }
    }
}

