/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.HennaData;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.L2Henna;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;

public class HennaEquipList
extends L2GameServerPacket {
    private final L2PcInstance _player;
    private final List<L2Henna> _hennaEquipList;

    public HennaEquipList(L2PcInstance player) {
        this._player = player;
        this._hennaEquipList = HennaData.getInstance().getHennaList(player.getClassId());
    }

    public HennaEquipList(L2PcInstance player, List<L2Henna> list) {
        this._player = player;
        this._hennaEquipList = list;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(238);
        this.writeQ(this._player.getAdena());
        this.writeD(3);
        this.writeD(this._hennaEquipList.size());
        for (L2Henna henna : this._hennaEquipList) {
            if (this._player.getInventory().getItemByItemId(henna.getDyeItemId()) == null) continue;
            this.writeD(henna.getDyeId());
            this.writeD(henna.getDyeItemId());
            this.writeQ(henna.getWearCount());
            this.writeQ(henna.getWearFee());
            this.writeD(henna.isAllowedClass(this._player.getClassId()) ? 1 : 0);
        }
    }
}

