/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.ManorData;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.SeedProduction;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class ExShowSeedSetting
extends L2GameServerPacket {
    private final int _manorId;
    private final int _count;
    private final long[] _seedData;

    public ExShowSeedSetting(int manorId) {
        this._manorId = manorId;
        Castle c = CastleManager.getInstance().getCastleById(this._manorId);
        int[] seeds = ManorData.getInstance().getSeedsForCastle(this._manorId);
        this._count = seeds.length;
        this._seedData = new long[this._count * 12];
        for (int i = 0; i < this._count; ++i) {
            int s = seeds[i];
            int dx = i * 12;
            this._seedData[dx + 0] = s;
            this._seedData[dx + 1] = ManorData.getInstance().getSeedLevel(s);
            this._seedData[dx + 2] = ManorData.getInstance().getRewardItemBySeed(s, 1);
            this._seedData[dx + 3] = ManorData.getInstance().getRewardItemBySeed(s, 2);
            this._seedData[dx + 4] = ManorData.getInstance().getSeedSaleLimit(s);
            this._seedData[dx + 5] = ManorData.getInstance().getSeedBuyPrice(s);
            this._seedData[dx + 6] = ManorData.getInstance().getSeedBasicPrice(s) * 60 / 100;
            this._seedData[dx + 7] = ManorData.getInstance().getSeedBasicPrice(s) * 10;
            SeedProduction seedPr = c.getSeed(s, 0);
            if (seedPr != null) {
                this._seedData[dx + 8] = seedPr.getStartProduce();
                this._seedData[dx + 9] = seedPr.getPrice();
            }
            if ((seedPr = c.getSeed(s, 1)) == null) continue;
            this._seedData[dx + 10] = seedPr.getStartProduce();
            this._seedData[dx + 11] = seedPr.getPrice();
        }
    }

    @Override
    public void writeImpl() {
        this.writeC(254);
        this.writeH(38);
        this.writeD(this._manorId);
        this.writeD(this._count);
        for (int i = 0; i < this._count; ++i) {
            int dx = i * 12;
            this.writeD((int)this._seedData[dx + 0]);
            this.writeD((int)this._seedData[dx + 1]);
            this.writeC(1);
            this.writeD((int)this._seedData[dx + 2]);
            this.writeC(1);
            this.writeD((int)this._seedData[dx + 3]);
            this.writeD((int)this._seedData[dx + 4]);
            this.writeD((int)this._seedData[dx + 5]);
            this.writeD((int)this._seedData[dx + 6]);
            this.writeD((int)this._seedData[dx + 7]);
            this.writeQ(this._seedData[dx + 8]);
            this.writeQ(this._seedData[dx + 9]);
            this.writeQ(this._seedData[dx + 10]);
            this.writeQ(this._seedData[dx + 11]);
        }
    }
}

